#include <stdio.h>
#include <iostream>
#include <sstream>
#include <cstring>
#include "TaxMap.h"

#define STACKSIZE 5000

TaxonomyMapping::TaxonomyMapping(SpecTree* spTree, SpecSetInstances* spInst, double _bestRatio, FILE *ofp) :
	taxMapOutData(), taxNodes(), specSetInst(spInst), outFp(ofp), specTree(spTree), bestRatio(_bestRatio), clustNodePool()
{
	taxMapOutData.reserve(1000);
	taxNodes.reserve(5000);
}

/*
TaxonomyMapping::mapTaxInfoAll(ClusterInfo *cinfo, int clustnum)
{
	listIter iter;
	int i;
	FILE *fp;

	fp = Opt.taxMapOutFp;
	if (fp == NULL) fp = stdout;
	for (i = 0; i < clustnum; i++) {
		if (cinfo[i].clustid < 0) {
			continue;
		}
		fprintf(fp, "#clustid=%d\n",cinfo[i].clustid);
		mapTaxInfo_Cinfo(&cinfo[i]);
	}
	free_sStack(taxNodes);
}
*/

void TaxonomyMapping::mapTaxInfo_output(string clustname) {
	map<string, TaxMapOutBuf*> taxMapHash;
	
	/* eliminate redundant data */
	for (unsigned int i = 0; i < taxMapOutData.size(); i++) {
		TaxMapOutBuf *taxInfo = &(taxMapOutData[i]);
		double score = taxInfo->taxinfo_score();
		string keystr = taxInfo->getKeyName();
		map<string, TaxMapOutBuf*>::iterator
			p = taxMapHash.find( keystr );
		if (p != taxMapHash.end()) {
			/* found in hash: a duplicated node */
			TaxMapOutBuf *tmpbuf = p->second;
			if (tmpbuf != taxInfo) {
				double maxScore = tmpbuf->taxinfo_score();
				if (score > maxScore) {
					// replace
					memcpy(tmpbuf, taxInfo, sizeof(TaxMapOutBuf)); /* copy taxInfo to hashed data */
				}
				/* delete */
				taxInfo->flag = 0;
			}
		} else {
			taxMapHash.insert(
			    pair<string,TaxMapOutBuf*>(keystr,taxInfo));
		}
		
	}
	if (outFp == stdout) {
		printf("======\n");
	} else {
		fprintf(outFp, "#clustid=%s\n", clustname.c_str());
	}
	for (unsigned int i = 0; i < taxMapOutData.size(); i++) {
		TaxMapOutBuf *taxInfo = &taxMapOutData[i];
		if (taxInfo->flag == 0) continue;
//cout << "2>taxinfo[" << i << "]==>" << taxInfo << endl;
		outputTaxInfo(taxInfo);
	}
	if (outFp == stdout) {
		printf("======\n");
	}

	taxMapOutData.clear();
}

void TaxonomyMapping::mapTaxInfo_Cinfo(list<ClusterNode*> *roots)
{
	list<ClusterNode*>::iterator p = roots->begin();

	while (p != roots->end()) {
		mapTaxInfo( *p );
		p++;
	}
}

void TaxonomyMapping::mapTaxInfo(ClusterNode *cnode)
{
/*
	if (taxNodes == NULL) {
		taxNodes = create_sStack(STACKSIZE, sizeof(TaxNodeData));
	}
*/
	mapTaxInfo_sub(cnode);
	taxNodes.clear();
}
void TaxonomyMapping::mapTaxInfo_sub(ClusterNode *cnode)
{
	ClusterNode *child1 = cnode->getChild(0);
	ClusterNode *child2 = cnode->getChild(1);
	int skipflag1 = 0, skipflag2 = 0;
	TaxNodeData spnode;
/*
	specFlag spFlag_cmpr, spFlag_taxQueryCompl;;
*/

	if ( (specSetInst->taxQueryCluster(cnode->getSpSet())
			&& specSetInst->unknownOnlyCluster(cnode->getSpSet()))
			|| cnode->getSpSet().count() == 1 ) {
		/* output result */
//cout << "save>>" << taxNodes.size() << ":" << cnode->getName() << " " << cnode->getScore() <<" "<<cnode->getCount()<<endl;
		saveTaxMap(cnode);
		return;
	} else if (specSetInst->taxKnownCluster(cnode->getSpSet())) {
		/* no query taxon: do nothing */
		return;
	}
	specFlagANDNOT(cnode->getSpSet(), specSetInst->unknown_SpecSet, spnode.spFlag_cmpr);
//	spnode.genenode = cnode;
	spnode.genenode = clustNodePool.create(*cnode);
	taxNodes.push_back(spnode);

	/* set skipflag if the other subtree contains only taxquery clusters
	 * --sp2
	 * |
         * |  +- unk
	 * +- +
         *    +- sp1
	 */

	if (! child1 || specSetInst->unknownOnlyCluster(child1->getSpSet())) {
		skipflag1 = 1;
	}
	if (! child2 || specSetInst->unknownOnlyCluster(child2->getSpSet())) {
		skipflag2 = 1;
	}
	if (skipflag2 && child1) {
		if (child2) mapTaxInfo_sub(child2);
		taxNodes.pop_back();
		mapTaxInfo_sub(child1);
	} else if (skipflag1 && child2) {
		if (child1) mapTaxInfo_sub(child1);
		taxNodes.pop_back();
		mapTaxInfo_sub(child2);
	} else {
		if (child1) mapTaxInfo_sub(child1);
		if (child2) mapTaxInfo_sub(child2);
		taxNodes.pop_back();
	}
}

void TaxonomyMapping::saveTaxMap(ClusterNode *cnode)
{
/*
	TaxNodeData *spnode, *prev_spnode;
	spnode = &taxNodes[taxNodes.size() - 1];
	prev_spnode = &taxNodes[taxNodes.size() - 2];
*/
	spnode_idx = taxNodes.size() - 1;
	prev_spnode_idx = taxNodes.size() - 2;


	if (outFp == NULL) {
		outFp = stdout;
	}
	saveTaxMap_sub(cnode);
}
void TaxonomyMapping::saveTaxMap_sub(ClusterNode *cnode)
{
	Domain dom;
	int domn = 0;
	TaxMapOutBuf taxInfo;

	if (cnode->isLeaf() && specSetInst->taxQueryCluster(cnode->getSpSet())) {
		if (spnode_idx >= 0) {
			taxInfo.taxNode1.copyData( &(taxNodes[spnode_idx]) );
		} else {
			taxInfo.taxNode1.copyData( NULL );
		}
		if (prev_spnode_idx >= 0) {
			taxInfo.taxNode2.copyData( &(taxNodes[prev_spnode_idx]) );
		} else {
			taxInfo.taxNode2.copyData( NULL );
		}

		taxInfo.domn = domn;
//		taxInfo.cnode = cnode;
		taxInfo.cnode = clustNodePool.create(*cnode);
		taxInfo.flag = 1;


		taxMapOutData.push_back(taxInfo);

		/* tmporary */
//		outputTaxInfo(&taxInfo);
	} else {
		if (cnode->getChild(0)) {
			saveTaxMap_sub(cnode->getChild(0));
		}
		if (cnode->getChild(1)) {
			saveTaxMap_sub(cnode->getChild(1));
		}
	}
}
TaxNodeData::TaxNodeData() : genenode(NULL), spFlag_cmpr() {
}
void TaxNodeData::copyData(TaxNodeData *taxData2) {
	if (taxData2) {
		spFlag_cmpr = taxData2->spFlag_cmpr;
        	genenode = taxData2->genenode;
	} else {
		genenode = NULL;
	}
}

string TaxMapOutBuf::getKeyName() {
/*
	ostringstream os;
	os << cnode->getName() << ":" << domn;
	return( os.str() );
*/
	return cnode->getName();
//	return cnode.getName();
}

void TaxonomyMapping::outputTaxInfo(TaxMapOutBuf* taxInfo) {
	if (taxInfo->taxNode1.genenode == NULL
		&& taxInfo->taxNode2.genenode == NULL) {
		// no information is available (both assignments are null)
		return;
	}
	ClusterNode *cnode = taxInfo->cnode;
/*
	Domain *dom = cnode->getDomain();
	Domain *orig_dom = dom->getOrigDomain();
*/
	fprintf(outFp, "%s", cnode->getName().c_str());
	fprintf(outFp, "\t");

	taxnode_output(&(taxInfo->taxNode1), &(cnode->getSpSet()));
	fprintf(outFp, "\t");
	taxnode_output(&(taxInfo->taxNode2), &(cnode->getSpSet()));
	fprintf(outFp, "\n");
}
void TaxonomyMapping::taxnode_output(TaxNodeData* taxNode, SpecSet* selfSet)
{
	SpecSet tmp_spFlag_cmpr;
	int taxnode_id;
	if (taxNode->genenode == NULL) {
		fprintf(outFp, "null");
	} else {
		if (selfSet) {
			specFlagANDNOT(taxNode->spFlag_cmpr, *selfSet, tmp_spFlag_cmpr);
			taxnode_id = specTree->matchFlags(tmp_spFlag_cmpr);
		} else {
			taxnode_id = specTree->matchFlags(taxNode->spFlag_cmpr);
		}
		if (taxnode_id < 0) {
			cerr << specTree->getNode(0)->spSet << endl;
			cerr << taxNode->spFlag_cmpr << endl;
			cerr << "Error in SpecTree::matchFlags\n";
			abort();
		}
		string name = specTree->getTaxName(taxnode_id);
		fprintf(outFp, "%s(%.1f,%.1f,%d)", name.c_str(),
			taxNode->genenode->getPairDist()->getScore(),
			taxNode->genenode->getPairDist()->getDist(),
			taxNode->taxnode_size() );
	}
}
double TaxMapOutBuf::taxinfo_score()
{
	return ( taxNode1.taxnode_score() + taxNode2.taxnode_score() );
}
bool TaxMapOutBuf::better_taxinfo_score(double score)
{
	double this_score = taxinfo_score();
	if (SimValue::reprValue == SimValue::SCORE) {
		return (this_score > score);
	} else {
		return (this_score < score);
	}
}
int TaxNodeData::taxnode_size()
{
	if (genenode==NULL) {
		return 0;
	}
	int spcnt = genenode->getSpSet().count() - 1;
	return(spcnt);
}
double TaxNodeData::taxnode_score()
{
/*
	return (double) taxnode_size();
*/
	if (genenode==NULL) {
		// return smallest score
		if (SimValue::reprValue == SimValue::SCORE) {
			return 0;
		} else {
			// DIST
			return -999999999;
		}
	}
	return (genenode->getPairDist()->getSimValueScore());
}
#ifdef DEBUG_MAIN
main(){
	
}
#endif
