#!/usr/bin/perl -s
use strict;
use DirHandle;
use FileHandle;

package BuildStatus;

###############################################################################
#
sub get_ver_domclust {

    my($cmd_domclust) = "$ENV{'RECOG_HOME'}/binaries/domclust";
    my($cmd) = "$cmd_domclust 2>&1 1>/dev/null";
    my($fh) = FileHandle->new("$cmd |") || return;
    my($line) = $fh->getline();
    $fh->close();

    my($ver) = ($line =~ /ver\.(.+)$/);

    return $ver;
}

###############################################################################
#
sub count_line_text {
    my($file_text) = shift;
    my($n) = 0;

    #
    my($fh) = FileHandle->new("$file_text") || return;
    while (my$line=$fh->getline()) {
        $n++;
    }
    $fh->close();

    return $n;
}

###############################################################################
#
sub count_fasta_seq {
    my($file_query) = shift;
    my($n) = 0;

    #
    my($fh) = FileHandle->new("$file_query") || return;
    while (my$line=$fh->getline()) {
        if ($line =~ /^\s*\>/) {
            $n++;
        }
    }
    $fh->close();

    return $n;
}

###############################################################################
#
sub count_bldp_files {
    my($dir) = shift;
    my($n) = 0;

    my($dh) = DirHandle->new("$dir") || return;
    while (my$file=$dh->read()) {
        if ($file =~ /^blastdpres\.[^\.\-]+\-[^\.\-]+\.pack$/) {
            $n++;
        }
    }

    return $n;
}

###############################################################################
#
sub count_bldp_file_entries {
    my($dir) = shift;
    my($sp1) = shift;
    my($sp2) = shift;
    my($pack_templ) = "a30 a30 S S S S f f f f";
    my($pack_size) = length(pack($pack_templ));
    my($n) = 0;

    if ($sp2 lt $sp1) {
        my($wk) = $sp1;
        $sp1 = $sp2;
        $sp2 = $wk;
    }

    my($filename) = sprintf("%s/blastdpres.%s-%s", $dir, $sp1, $sp2);
    my($fh) = FileHandle->new("$filename") || return;
    my($buf);
    while (my$rsize=$fh->read($buf, $pack_size)) {
        if ($rsize == $pack_size) {
            my($rspname1, $rspname2) = unpack($pack_templ, $buf);
            my($rsp1, $rname1) = split(/\:/, $rspname1);
            my($rsp2, $rname2) = split(/\:/, $rspname2);
            if (($rsp1 eq $sp1) &&
                ($rsp2 eq $sp2)) {
                $n++;
            }
        }
    }
    $fh->close();

    return $n;
}

###############################################################################
#
sub count_bldp_splist_entries {
    my($dir) = shift;
    my(@splist) = @_;
    my($count_ref) = {};

    foreach my$sp1 (@splist) {
        foreach my$sp2 (@splist) {
            if (exists($count_ref->{"$sp1"}->{"$sp2"}) ||
                exists($count_ref->{"$sp2"}->{"$sp1"})) {
                next;
            }

            $count_ref->{"$sp1"}->{"$sp2"} = $count_ref->{"$sp2"}->{"$sp1"} = count_bldp_file_entries($dir, $sp1, $sp2);
        }
    }

    return $count_ref;
}

###############################################################################
#
sub fsize_bldp_splist_files {
    my($dir) = shift;
    my(@splist) = @_;
    my($fsize_ref) = {};

    if (! -e $dir) {
        return;
    }

    foreach my$sp1 (@splist) {
        foreach my$sp2 (@splist) {
            if (exists($fsize_ref->{"$sp1"}->{"$sp2"}) ||
                exists($fsize_ref->{"$sp2"}->{"$sp1"})) {
                next;
            }

            my($filename) = sprintf("%s/blastdpres.%s-%s.pack", $dir, $sp1, $sp2);
            if ($sp2 lt $sp1) {
                $filename = sprintf("%s/blastdpres.%s-%s.pack", $dir, $sp2, $sp1);
            }

            if (-e $filename) {
                $fsize_ref->{"$sp1"}->{"$sp2"} = $fsize_ref->{"$sp2"}->{"$sp1"} = -s $filename;
            }
        }
    }

    return $fsize_ref;
}

###############################################################################
1;#
###############################################################################
