#!/usr/bin/perl -s
use strict;
use POSIX "sys_wait_h";
use MBGD::DB;

package CheckStatus;

###############################################################################
# RETURN
#  0 : status OK
#  1 : can not connect
#  2 : slow down
# -1 : NG
sub checkStatusMysql {
    my($dbname) = shift;

    #
    my($db) = new MBGD::DB($dbname);
    if ($db->{'conn'} =~ /^\s*$/) {
        # ERROR :: can not connect $dbname.
        return 1;
    }

    my($pid) = fork();
    if ($pid) {
        #
        sleep(3);
        my($ret) = waitpid($pid, POSIX::WNOHANG);
        if ($ret != $pid) {
            # child process is running.
            return 2;
        }
    }
    elsif (defined($pid)) {
        # child
        my($tab) = "genome";
        my($opt) = {};
        $opt->{'columns'} = "count(*)";
        my($refRes) = $db->select_fetch($tab, $opt);
        exit(0);
    }
    else {
        return -1;
    }

    return 0;
}

if ($0 eq __FILE__) {
    print "STATUS :: ", checkStatusMysql($ARGV[0]), "\n";
}

1;#
