#!/usr/local/bin/perl -s

###############################################################################
#                                                                             #
# Name          : Make complement sequence                                    #
#                                                                             #
# Synopsis      : &Complement($org_sequence);                                 #
#                     $org_sequence : only nucleic acid code                  #
#                                                                             #
# Retuen Value  : complemented sequence                                       #
#                                                                             #
###############################################################################
sub Complement
{
    my( $org_seq ) = @_;
    my( $new_seq ) = $org_seq;

    $new_seq =~ tr/ACGTURYMKWSBDHVNXacgturymkwsbdhvnx/TGCAAYRKMWSVHDBNXtgcaayrkmwsvhdbnx/;
    $new_seq =  reverse $new_seq;

    return $new_seq;
}
###############################################################################
# execute convert (except 'require' this file)
###############################################################################
if ($0 eq __FILE__) {
    while(<>) {
        next if (/^</);
        chop();
        $sequence .= $_;
    }
    print &Complement($sequence), "\n";
}
###############################################################################
1;                                                # Return TRUE Value
###############################################################################
