#!/usr/local/bin/perl -s

###############################################################################
use File::Basename;
use FileHandle;
require "libSeq.pl";
require "libPvm.pl";
require "MBGD_Conf.pl";

$CMD_dp   = "$ENV{'HOME'}/pvm3/bin/$ENV{'PVM_ARCH'}/pdp";

###############################################################################
# ꤬ʬȤΤǤ libSeq.pl  readFastaSequence() Ѥ
# bget ٤
#
# bget ޥɤȤ
# ա
# 󤬼Ǥʤä ID ϡ 1 äƤ
sub GetSequenceByBget {
    my(@idList) = @_;
    my($id, $seq);
    my($info);
    my($fileIdList);
    my($cmd);
    my($fileCmd);
    local(*FH);

    # bget Ǽ ID ΰե
    ($fileCmd) = fileparse(__FILE__, '\..*');
    $fileIdList = "$main::DIR_work/tmp_$fileCmd.$$";
    $info = {};
    foreach $id (@idList) {
        next if ($id =~ /^\s*$/);
        $info->{"$id"} = "1";
    }
    open(FH, ">$fileIdList") || die("Can not open $fileIdList($!)");
    print FH join("\n", keys(%{$info})), "\n";
    close(FH);

    # bget ޥ
    $cmd = "$CMD_bget";
    if ($ENV{'DBTAB'} ne '') {
        $cmd = "$cmd -p $ENV{'DBTAB'}";
    }
    $cmd = "$cmd < $fileIdList";

    # bget η̤
    open(FH, "$cmd |") || die("Can not exec $cmd($!)");
    $seq = '';
    while(<FH>) {
        if (/^>\s*(\S+)/) {
            if ($seq ne '') {
                $info->{"$id"} = $seq;
            }
            $id = $1;
            $seq = $_;
        }
        else {
            $seq .= $_;
        }
    }
    if ($seq ne '') {
        $info->{"$id"} = $seq;
    }
    close(FH);

    # եκ
    unlink("$fileIdList");

    return $info;
}

###############################################################################
# ե뤫ñ̤ǼФ
# Фܤ ID ϡTAB ɤڤʸȤʸ˳ǼƤ
#     "ID1\tID2"
sub GetSeqPair {
    my($fileDb, $fileOut, @idPairList) = @_;
    my($filename);
    my($idPair);
    my($id1, $id2);
    my($numOut);
    my($fh);
    my($fe);

    # оݤ ID
    foreach $idPair (@idPairList) {
        ($id1, $id2) = split(/\t/, $idPair);
        if ($id1 =~ /^\s*$/) {
            print STDERR "WARNING :: wrong sequence ID[$idPair]\n";
            next;
        }
        if ($id2 =~ /^\s*$/) {
            print STDERR "WARNING :: wrong sequence ID[$idPair]\n";
            next;
        }

        push(@idList, $id1, $id2);
    }

    # 
    $infoSeq = &readFastaSequence($fileDb);

    # ڥǽ
    $filename= $fileOut;
    $fh = new FileHandle(">$filename")     || die("Can not open $filename($!)");
    $fe = new FileHandle(">$filename.err") || die("Can not open $filename.err($!)");
    $numOut = 0;
    while(@idList) {
        ($id1) = (shift(@idList) =~ /\:(\S+)/);
        ($id2) = (shift(@idList) =~ /\:(\S+)/);

        # ΥڥǤå
        $seq1 = $infoSeq->{"$id1"};
        $seq2 = $infoSeq->{"$id2"};
        if ($seq1 eq '') {
            print STDERR "Can not found sequence[$id1]\n";

            # 顼ե ID 
            $fe->print($id1, "\t", $id2, "\n");

            next;
        }
        if ($seq2 eq '') {
            print STDERR "Can not found sequence[$id2]\n";

            # 顼ե ID 
            $fe->print($id1, "\t", $id2, "\n");

            next;
        }

        # ϡɬۥڥǽϤ
        $fh->print($seq1);
        $fh->print($seq2);
        $numOut++;
    }
    $fe->close();
    $fh->close();

    if (-z "$filename.err") {
        unlink("$filename.err");
    }

    # ե˽Ϥڥۤο֤
    return $numOut;
}

###############################################################################
# dp ޥɺ
sub makeDpCmd {
    my($filename, $dpOptions) = @_;
    my(@hosts);
    my($hostname);
    my($cmd);

    # pvmd  dp ¹Ԥ host ؼ
    @hosts = ();
    foreach $hostname (sort(keys(%PVM_HOSTS))) {
        next if ($PVM_HOSTS{"$hostname"} < 1);

        push(@hosts, $hostname);
    }
    &UpPvmd(@hosts);

    $cmd = "$CMD_dp";
    foreach $hostname (@hosts) {
        $cmd = "$cmd +H" . $hostname . ":" . $PVM_HOSTS{"$hostname"};
    }
    $cmd = "$cmd $filename $dpOptions";
    if ($PDP_HOST) {
        $cmd = "$CMD_rsh $PDP_HOST '$cmd'"
    }
#print STDERR "CMD(pdp) :: $cmd\n";

    return $cmd;
}

###############################################################################
# dp ¹Ԥ
sub ExecDp {
    my($filename, $dpOptions) = @_;
    my($cmd);
    my($res);
    my($info);

    # ޥɤ
    $cmd = &makeDpCmd($filename, $dpOptions);
    if ($DEBUG) {
        print STDERR "ADD tee\n";
        $cmd = "$cmd | tee /tmp/tmp_$ENV{'USER'}.$$";
    }

    # ޥɤ¹
    $res = `$cmd`;
    $info = [];
    push(@{$info}, split(/\n/, $res));

    return $info;
}

###############################################################################
if ($0 eq __FILE__) {
    my($fileDb);
    my($fileTmp);
    my($id1, $id2);
    my($ref);

    $fileDb = shift(@ARGV);
    $id1    = shift(@ARGV);
    $id2    = shift(@ARGV);

    # ե̾
    $fileTmp = "/tmp/tmp_$ENV{'USER'}.$$";

    # оݤ
    &GetSeqPair($fileDb, $fileTmp, "$id1\t$id2");

    # dp ¹
    $ref = &ExecDp($fileTmp);

    # dp η̤ɽ
    print join("\n",@{$ref}), "\n";

    # ե
    unlink("$fileTmp");

    exit;
}

###############################################################################
1;#
###############################################################################
