#!/usr/local/bin/perl

package MBGD::Chromosome;
use MBGD;

@ISA = qw{ MBGD::Object };

sub setValues {
	my($this, $values) = @_;
	$this->SUPER::setValues($values);

	if (! $this->{chksum} && $values->{seq}) {
		if (ref $values->{seq}) {
			$this->{seq} = $values->{seq};
#		} else {
#			$this->{seq} = MBGD::DNASeq->new({
#					name => $this->{name},
#					seq => $values->{seq}
#				});
		}
		$this->{chksum} = $this->{seq}->{chksum};
		$this->{length} = $this->{seq}->{length};
	}
}

sub print_seq {
	my($this, $opt) = @_;
	my $dispname = $this->get_dispname;
	$this->{seq}->print_fasta("$dispname", $opt);
}

sub get {
	my($this, $db, $keyvalues, $opt) = @_;
	my @ret = $this->SUPER::get($db, $keyvalues, $opt);
	($db,$keyvalues,$opt) = MBGD::Object::__process_args($db,$keyvalues,$opt);
	if ($opt->{with_length}) {
		foreach $chr (@ret) {
			$chr->length($db);
		}
	}
	@ret;
}
sub fetch {
	my($this, $db, $keyvalues, $opt) = @_;
	my @ret = $this->SUPER::fetch($db, $keyvalues, $opt);
	if ($opt->{with_length}) {
		foreach $chr (@ret) {
			$chr->length($db);
		}
	}
	@ret;
}
sub length {
	my($this, $db) = @_;
	return $this->{seq_length} if ($this->{seq_length});
	return $this->{length} if ($this->{length});
	$db = $this->{db} if (! $db);
	if ($this->{seq}) {
		return $this->{seq}->length if (ref $this->{seq});
		my($seq) = MBGD::DNASeq->get($db, [$this->{seq}],
			{keys=>"id", fields=>"length"});
		return ($this->{length} = $seq->{length});
	}
}
sub get_subseq {
	my($this, $from, $to, $dir, $opt) = @_;
	my($flag);
	my($origfrom, $origto);
	if ($from <= 0) {
		$origfrom = $from;
		$from = 1;
	}
	if ($to > $this->length) {
		$origto = $to;
		$to = $this->length;
	}
	my $seq = MBGD::DNASeq->get_subseq($this->{db},
			$this->{seq}, $from, $to, $dir);
	my $seqlen = length($seq);
	if ($opt->{upper_gene}) {
		my @Genes = $this->getGenes({from=>$from, to=>$to});
		foreach $g (@Genes) {
			my $f = $g->{from1} - $from;
			my $t = $g->{to1} - $from;

			$f = 0 if ($f < 0);
			$t = $seqlen - 1 if ($t >= $seqlen);
			my $len = $t - $f + 1;
			if ($dir < 0) {
				$f = $seqlen - 1 - $t;
			}
			substr($seq, $f, $len) = uc(substr($seq,$f,$len));
		}
	}
	if ($origfrom) {
		$seq_f = $this->get_subseq($this->length + $origfrom - 1,
					$this->length, $dir, $opt);
		$seq = "${seq_f}${seq}";
	}
	if ($origto) {
		$seq_t = $this->get_subseq(1, $origto - $this->length, $dir, $opt);
		$seq = "${seq}${seq_t}";
	}
	$seq;
}
sub getGenes {
	my($this, $opt) = @_;
	my($db) = ($opt->{db} ? $opt->{db} : $this->{db});
	my($query) = "chrid=" . $this->{id};
	if (defined $opt->{from} && defined $opt->{to}) {
		$query .= " and from1 < $opt->{to} and to1 > $opt->{from}";
	}
	MBGD::Gene->find($db, $query, $opt);
}
sub set_dispname {
	my($this, $dispname) = @_;
	if (! $dispname) {
		$this->{dispname} = $this->{sp} . ":" . $this->{name};
	}
	$this->{dispname} = $dispname;
}
sub get_dispname {
	my($this) = @_;
	if (! $this->{dispname}) {
		$this->set_dispname;
	}
	$this->{dispname};
}
sub get_name {
	my($this) = @_;

    my($name) = $this->{name};
    if ($name !~ /$this->{type}/i) {
        $name = join('-', $this->{type}, $this->{name});
    }

    return $name;
}

1;
