#!/usr/local/bin/perl

use MBGD::ClustTab;

package MBGD::ClustTab::PosCluster;

sub create {
	my($class, $clusttab, $opt) = @_;
	my($this) = {};
	bless $this, $class;

#	my @splist = split(/,/, $splist);

	my $MaxDist = 5000;
	my $QueueSize = 5;
	my $Graph = {};
	my $cnt = 0;
	my @splist = @{ $clusttab->splist };
	my $geneinfo = $clusttab->geneinfo;

	$QueueSize = $opt->{QueueSize} if ($opt->{QueueSize});

	foreach $t ($clusttab->list_clusters) {
		my $pinfo = [];
		my $clust = $t->cluster;
		my $i = 0;
#		foreach my $spg (@{$clust}) {
		for ($i = 0; $i < @splist; $i++) {
			my $sp = $splist[$i];
			$spg = $clusttab->get_spdata($t, $i);
#print STDERR ">>>$sp,$splist[$i],$i\n";
			foreach my $g (@{$spg}) {
				my ($gene,$dom) = &MBGD::ClustTab::parse_genename($g);
				my $spgene = "$sp:$gene";

warn "No geneinfo for $spgene\n" if (! defined $geneinfo->{$spgene});
				my $pos = ($geneinfo->{$spgene}->{from1} +
					$geneinfo->{$spgene}->{to1}) / 2;
				my $chr = $geneinfo->{$spgene}->{chrid};
				foreach my $ppinfo (@{$pposinfo}) {
					foreach my $prevg (@{$ppinfo->[$i]}) {
						($pgene, $pchr, $ppos) = @{$prevg};
						if ($chr == $pchr &&
							$pos <= $ppos + $MaxDist &&
							$pos >= $ppos - $MaxDist) {
							&graphAdd($Graph, $sp,$gene,$pgene);
						}
						
					}
				}
				push(@{$pinfo->[$i]}, [$gene, $chr, $pos]);
			}
#			$i++;
		}
		if (++$cnt >= $QueueSize) {
			shift(@{$pposinfo});
		}
		push(@{$pposinfo}, $pinfo);
	}
	$this->{posclust} = &posClustCreate($Graph);
	return $this;
}

sub get_color {
	my($this, $ent) = @_;
	my(@Colors) = (
		'#ff8888', '#88ffff', '#ffff88', '#8888ff',
		'#ff88ff', '#88ff88', '#ffcc88', '#ff88cc',
		'#88ffcc', '#ccff88', '#cc88ff', '#88ccff'
	);
 
	if (my $clid = $this->{posclust}->{$ent}) {
		return $Colors[$clid % (0+@Colors)];
	} else {
		return "#ffffff";
	}
}

sub graphAdd {
	my($Graph, $sp,$name1,$name2) = @_;
	$Graph->{$sp}->{$name1}->{$name2} = 1;
	$Graph->{$sp}->{$name2}->{$name1} = 1;
}

sub posClustCreate {
	my($Graph) = @_;
	my($posclust, $clustid) = ({}, 1);

	foreach my $sp (keys %{$Graph}) {
		foreach $n1 (keys %{$Graph->{$sp}}) {
			&posClustCreate0($posclust, $Graph->{$sp}, $sp, $n1, $clustid);
			$clustid++;
		}
	}
	return $posclust;
}
sub posClustCreate0 {
	my($posclust, $Graph, $sp, $n1, $clustid) = @_;
	return if ($posclust->{"$sp:$n1"});

	$posclust->{"$sp:$n1"} = $clustid;

	foreach $n2 (keys %{$Graph->{$n1}}) {
		posClustCreate0($posclust, $Graph, $sp, $n2, $clustid);
	}
}


1;
