#!/usr/local/bin/perl

package MBGD::FlatDB;

use DBI;
use MBGD;
use MBGD::FlatTab;
use MBGD::Schema;
use FileHandle;

@ISA = qw{ MBGD::DB };

sub new {
	my($class, $datadir, $option) = @_;
	my($this) = {};
	bless $this, $class;
	
	if (! $datadir) {
		$datadir = $MBGD::Config{datadir};
	}
	$this->{datadir} = $datadir;
	return $this;
}
sub disconnect {
	my($this) = @_;
	foreach $cl (keys %{$this->{tables}}) {
		$this->{tables}->{$cl}->close;
	}
}
sub list_tables {
	my($this) = @_;
	return $this->{conn}->tables;
}
sub exist_table {
	my($this, $table) = @_;
	foreach my $t ($this->list_tables) {
		if ($t eq $tables) {
			return 1;
		}
	}
	return 0;
}
sub drop_tables {
	my($this, @tables) = @_;
	foreach my $t ($this->list_tables) {
		if (! @tables || grep($t eq $_, @tables)) {
			$this->do("drop table $t");
		}
	}
}

sub store_object {
	my($this, $obj) = @_; 
	my $class = $obj->{schema}->{classname};
	my $opt = {};
	if (! $this->{tables}->{$class}) {
#		if ($this->exist_table($class) == 0) {
#			$opt->{create} = 1;
#		}
#		$opt->{prepare_insert} = 1;
		$this->{tables}->{$class} = MBGD::FlatTab->new(	
				$this, $class, {mode=>'w'});
	}
	$this->{tables}->{$class}->store_object($obj);
}
sub get_table {
	my($this, $class, $opt) = @_;
	if ($this->{tables}->{$class}) {
		return $this->{tables}->{$class};
	}
	if ($opt->{create}) {
		return $this->{tables}->{$class} = MBGD::FlatTab->new(this, $class, $opt);
	} else {
		return 0;
	}
}

1;
