#!/usr/local/bin/perl

package MBGD::DB;

use DBI;
use MBGD;
use MBGD::DBTable;
use MBGD::Schema;
use MBGD::SQL;

@ISA = qw{ MBGD::DB };

sub new {
	my($class, $DBS, $option) = @_;
	my($this) = {};
	bless $this, $class;
	
	if (! $DBS) {
		$DBS = $MBGD::Config{default_dbs}
	}

	($dmy, $dbdrv, $dbname) = split(/:/, $DBS);
	$this->{dbdrv} = $dbdrv;
	$this->{dbname} = $dbname;

	$this->{conn} = $this->connect($DBS,
			$option->{username}, $option->{PW});
	if ($option->{update_mode}) {
		$this->{update_mode} = $option->{update_mode};
	}
	return $this;
}
sub connect {
	my($this, $DBS, $username, $PW, $opt) = @_;
	$username = 'uchiyama' if (! $username);
	$PW = 'co19re84' if (! $PW);
	$this->{conn} = DBI->connect($DBS, $username, $PW, $opt);
	$this->{conn}->{LongReadLen} = 10000;
	$this->{conn};
}
sub disconnect {
	my($this) = @_;
	$this->{conn}->disconnect;
}
sub prepare {
	my($this, @args) = @_;
	$this->{conn}->prepare(@args);
}
sub execute {
	my($this, @args) = @_;
	$sth = $this->{conn}->prepare(@args);
	$sth->execute();
	return $sth;
}
sub do {
	my($this, @args) = @_;
	foreach my $stmt (@args) {
		$this->{conn}->do($stmt);
	}
}
sub list_tables {
	my($this) = @_;
	return $this->{conn}->tables;
}
sub exist_table {
	my($this, $table) = @_;
	foreach my $t ($this->list_tables) {
		if ($t eq $table) {
			return 1;
		}
	}
	return 0;
}
sub drop_tables {
	my($this, @tables) = @_;
	foreach my $t ($this->list_tables) {
		if (! @tables || grep($t eq $_, @tables)) {
			$this->do(MBGD::SQL::drop_table($this, $t));
		}
	}
}

sub check_updated {
	my($this, $class, $condition, $opt) = @_;
	my $tab = $this->get_table($class, {mode=>'update'});
	my $sth = $tab->difference($condition);
	while (my @a = $sth->fetchrow_array) {
		print join(' ', @a),"\n";
	} 
}
sub store_object {
	my($this, $obj, $opt) = @_; 
	my $class = $obj->{schema}->{classname};
	my $tabopt = {};

	my $table = $this->get_table($class, {mode=>'update', create=>1});
	return -1 if (! $table);

#	if (! $this->{tables}->{$class}->{update}) {
#		if ($this->{update_mode} eq 'temporal') {
#			$tabopt->{temporal} = 1;
#		} elsif ($this->exist_table($class) == 0) {
#			$tabopt->{create} = 1;
#		}
#		$tabopt->{prepare_insert} = 1;
#		$this->{tables}->{$class}->{update} = MBGD::DBTable->new(	
#				$this, $obj->{schema}, $tabopt);
#	}

	my $id = $table->store_object($obj, $opt);
	return $id;
}
sub get_table {
	my($this, $class, $opt) = @_;
	my $mode = 'read';
	$mode = $opt->{mode} if (! $opt->{mode});

	if ($this->{tables}->{$class}->{$mode}) {
		return $this->{tables}->{$class}->{$mode};
	}

	if ($this->{update_mode} eq 'temporal') {
		$tabopt->{temporal} = 1;
	} elsif ($this->exist_table($class) == 0) {
		if ($opt->{create}) {
			$tabopt->{create} = 1;
		} else {
			return 0;
		}
	}
	return $this->{tables}->{$class}->{$mode}
		= MBGD::DBTable->new($this, $class, $tabopt);
}

package MBGD::ObjTab;

$objtab = 'otab';
sub store {
	my($db, $tabname) = @_;
	my $sth = $db->{conn}->prepare(
		"insert into $objtab (tabname) values ($tabname)");
	$sth->execute;
	$sth = $db->{conn}->prepare(MBGD::SQL::get_idval);
	$sth->execute;
	my @ret = $sth->fetchrow_array;
	return $ret[0];
}

1;
