#!/bin/perl

package MBGD::SQL;

use DBI;
use MBGD::DB;
use MBGD::SQL_mysql;
use MBGD::SQL_Pg;
use MBGD::SQL_Sybase;

%ObjRef;

sub new {
	my($class, $drvtype) = @_;
	my($this) = {};
	if (! $drvtype && $class =~ /SQL_(.*)$/) {
		$drvtype = $1;
	}
	return $ObjRef{$drvtype} if ($ObjRef{$drvtype});
	$ObjRef{$drvtype} = $this;
	$this->{drvtype} = $drvtype;
	bless $this, $class;
}

sub create_table_header {
	my($this, $tempopt, $tablename) = @_;
	return "create ${tempopt} table if not exists ${tablename} (\n";
}

sub create_table_primary_key {
       $SQL .= "primary key(" .
		join(',', @{$this->{option}->{PRIMKEY}}) . ")";

}

sub drop_table {
	my($this, $tablename) = @_;
	my(@SQL, $sql);

	push(@SQL, "drop table $tablename");

	@SQL;
}
sub copy_table {
	my($this) = @_;
	&NotDefined("get_idval");
	return '';
}
sub lock_table {
	my($this) = @_;
	&NotDefined("get_idval");
	return '';
}

sub get_idval {
	my($this) = @_;
	&NotDefined("get_idval");
	return '';
}
sub table_options {
	my($this) = @_;
	return '';
}
sub merge_table_options {
	my($this) = @_;
	return '';
}
sub type_convert {
	my($this, $attrinfo) = @_;
	type_convert_1($attrinfo);
	return $this->type_convert_2($attrinfo);
}
sub type_convert_1 {
	my($attrinfo) = @_;
	if ($attrinfo->{type} =~ /^(identity|serial)$/i ||
		$attrinfo->{option} =~ /auto_increment/) {
		$attrinfo->{type} = 'ID';
		$attrinfo->{option} =~ s/auto_increment//;
	} elsif ($attrinfo->{option} =~ /^references (\w+)(.*)$/i) {
		$tblname = $1;
		$attrinfo->{type} = "Ref($1)";
	} elsif ($attrinfo->{type} =~ /^(timestamp)$/i) {
		$attrinfo->{type} = 'TIMESTAMP';
	}
}
sub type_convert_2 {
	my($this, $attrinfo) = @_;
	my $type = $attrinfo->{type};
	my $option = $attrinfo->{option};

	if ($attrinfo->{type} =~ /Ref\((.*)\)/i) {
		my $ref = $1; $ref = lc($ref);
		$type = 'int';
		$option .= " references $ref (id)";
	}
	($type, $option);
}
sub NotDefined {
	my($methodname) = @_;
	warn "$methodname is not defined for this driver.\n";
}

1;
