#!/usr/local/bin/perl

package MBGD::WWW;

use CGI;
use File::Path;
use UserInfo;
use ArgCheck;
use File::Basename;
use MbgdUserGenomeCommon;

$PageBgColor = "e0f2e0";
$DefaultTitle = "Microbial Genome Database for Comparative Analysis";
$DefaultStyleSheet = { -src=> '/css/mbgd.css' };
$MailTo = 'uchiyama@nibb.ac.jp'; 

$ARGLIST = {
	'title' => 1,
	'type' => {check=>1, default=> 'text/html'},
	'charset' => {check=>1, default=> 'us-ascii'},
};

sub new {
	my($class, %option) = @_;
	return ${MBGD::WWW::obj_WWW} if (${MBGD::WWW::obj_WWW});	## singleton class
	my $this = {};
	bless $this, $class;

	if (! $option{no_cgi}) {
		if ($option{cgiparam}) {
			if (-f "$option{cgiparam}") {
				local(*CGIPARAM);
				open(CGIPARAM, $option{cgiparam});
				$this->{cgi} = new CGI(CGIPARAM);
				close(CGIPARAM);
			} else {
print STDERR "OO>$option{cgiparam}\n";
				$this->{cgi} = new CGI($option{cgiparam});
print STDERR "OK:$this->{cgi}->{motif}->[0]<<\n";
			}
		} else {
			$this->{cgi} = new CGI;
		}
		$this->{uid} = $this->{cgi}->cookie('uid');
		if ($option{cookie_check} && ! $this->{uid}) {
			$this->start_html();
			$this->setting_error();
			exit;
		}
		$this->{uInfo} = UserInfo->new($this->{uid});
		if ($this->{uInfo}->is_newuid) {
print STDERR "NEW UID :: ", $this->{uInfo}->uid, "\n";
			$this->{cookie} = $this->{cgi}->cookie(
					-name=>'uid',
					-value=>$this->{uInfo}->uid,
					-expires=>"+30d",
			);
			$this->{uid} = $this->{uInfo}->uid;
		}
	}
print STDERR "UID :: ", $this->{uid}, "\n";

	#
	$main::DIR_userDatabase = $main::DIR_database;
	my($uid) = $this->{uid};
	$main::ENV{'MBGD_UID'} = $uid;
    my($modeMymbgd) = MbgdUserGenomeCommon::isMymbgdMode($uid);
    my($dirUserGenome) = MbgdUserGenomeCommon::getDirBaseUserGenome($uid); 
    my($dirUserDb)   = $main::DIR_userDb = "$dirUserGenome/database";
    if (($modeMymbgd) &&
	    (-e "$dirUserDb")) {
        my($sta) = MbgdUserGenomeCommon::isReadyUserGenome($uid);
        if ($sta) {
            # UserGenome ĶۺѤ
            MbgdUserGenomeCommon::setupUserGenomeEnv($uid);
	    }
	}

	$this->{argcheck} = ArgCheck->new($ARGLIST,{'DEBUG'=>0});
	$newopt = $this->{argcheck}->check(\%option);
	$this->setOptions(%{$newopt});

	${MBGD::WWW::obj_WWW} = $this;
	return ${MBGD::WWW::obj_WWW};
}
sub setOptions {
	my($this, %option) = @_;
	foreach my $k (keys %option) {
		$this->{$k} = $option{$k};
	}
} 
sub set_title {
	my($this, $title) = @_;
	$this->{title} = $title;
}
sub cgiGetArgs {
	my($this) = @_;
	my($cgi) = $this->{cgi};
	my(%ArgsHash);
	foreach $key ($cgi->param()) {
		my(@values) = $cgi->param($key);
		if (@values > 1) {
			$ArgsHash{$key} = \@values;
		} else {
			$ArgsHash{$key} = $values[0];
		}
	}
	return %ArgsHash;
}
sub set_MultiValuedArg {
	my($arg, $splitPat) = @_;
	my(%Hash);
	if (ref $arg eq 'ARRAY') {
		foreach $data (@{$arg}) {
			foreach $d (split($splitPat, $data)) {
				$Hash{$d} = 1;
			}
		}
	} elsif (! ref $arg) {
		foreach $d (split($splitPat, $arg)) {
			$Hash{$d} = 1;
		}
	}
	%Hash;
}
sub cgiGetQueryString {
	my($this) = @_;
	$this->cgi->query_string();
}

sub start_html {
	my($this, %option) = @_;

	if (! $option{'-title'}) {
		if ($option{title}) {
			$option{'-title'} = $option{title}
		} elsif ($this->{title}) {
			$option{'-title'} = $this->{title}
		} else {
			$option{'-title'} = $DefaultTitle;
		}
	}
	$option{'-style'} = $DefaultStyleSheet
		if (! $option{'-style'} && ! $option{'-bgcolor'});
	$option{'-title'} = "MBGD: $option{'-title'}";

	my(%http_header_opt);
	$http_header_opt{-type} = $this->{type} if ($this->{type});
	$http_header_opt{-charset} = $this->{charset} if ($this->{charset});
	my(%start_opt) = (
		-author=>$MailTo,
		%option	
	);
	$http_header_opt{-cookie} = $this->{cookie} if ($this->{cookie});
	if ($this->{cgi}) {
		if (! $option{no_http_header}) {
			print $this->{cgi}->header(%http_header_opt);
		}
		print $this->{cgi}->start_html(%start_opt);
	} else {
		print "Content-type: text/html; charset=$this->{charset}\n\n";
		print "<HTML><HEAD><TITLE>$option{-title}</TITLE></HEAD>\n";
		print "<LINK rel=\"stylesheet\" href=\"/css/mbgd.css\">\n";
		if (ref($option{'-meta'})) {
			my($name, $content, $info);
			foreach $name (keys %{$option{'-meta'}}) {
				$content = $option{'-meta'}->{$name};
				print "<META NAME=\"$name\" CONTENT=\"$content\">\n";
			}
		}
		print "</HTML>\n";
		print "<BODY" .
		  ($option{'-bgcolor'} ? "bgcolor=$option{'-bgcolor'}" : "")
		  . ">";
	}
}
sub end_html {
	my($this) = @_;
	print $this->{cgi}->end_html,"\n";
}

sub setting_error {
	my($this) = @_;
	print <<EOF;
<H1>Please turn on "Accept cookies" at the preference menu of your browser.</H1><BR> <BR>
<NOSCRIPT>
<H1>Please turn on \"Enable JavaScript\" at the preference menu of your
browser.</H1><BR>
</NOSCRIPT>
<A HREF=\"/\">Top PAGE.</A>
</BODY>
</HTML>
EOF
}
sub error_message {
	my($this, $message) = @_;
	$this->start_html(title=>"ERROR");
	print "<H1>$message</H1>\n";
	$this->end_html;
}

sub page_header {
	my($this, %option) = @_;
	my($h) = $option{hrank} ? $option{hrank} : 'h2';
	my($title) = $option{title} ? $option{title} : $this->{title};
	if ($title) {
		if ($option{center}) {
			print "<center><$h>$title</$h></center>\n";
		} else {
			print "<$h>$title</$h>\n";
		}
	}
}

sub logo {

	print <<END;
<TABLE BORDER=3><TD><A HREF=/ TARGET=_top>
<IMG SRC=/image/MBGDlogo3-mini.gif BORDER=0>
</A></TD></TABLE>
<i>Microbial Genome Database for Comparative Analysis</i>
END

}
sub page_footer {
	my($this) = @_;
	print "\n<hr>\n";
	$this->logo;
	print "<br>\n";
	print "Questions and comments to: $MailTo\n";
}

sub cgi {
	my($this) = @_;
	return $this->{cgi};
}
sub uid {
	my($this) = @_;
	return $this->{uid};
}
sub uInfo {
	my($this) = @_;
	return $this->{uInfo};
}
1;
