#!/usr/bin/perl -s
use FileHandle;
require 'libMBGDclusttab.pl';
require 'libMBGDClustMethod.pl';
require 'MBGD_commonPath.pl';

package MBGD::WWW::Clustering;

use UserInfo;
use Digest::MD5;
use Property::HomolParam;
use MbgdUserGenomeCommon;

sub _initVars {
$TMPFILEDIR       = "$main::DIR_tmp";
if ($ENV{'MBGD_TMP'}) {
    $TMPFILEDIR   = "$ENV{'MBGD_TMP'}";
}

$TMPCLSTFILE      = "${TMPFILEDIR}/tmp_mbgd_cluster";
$TMP_TMPCLSTFILE  = "${TMPFILEDIR}/__tmp_mbgd_cluster";
$TMPTABFILE       = "${TMPFILEDIR}/tmp_mbgd_table";
$TMP_TMPTABFILE   = "${TMPFILEDIR}/__tmp_mbgd_table";
$TMPTREEFILE  = "${TMPFILEDIR}/tmp_mbgd_clstTree";
$TMP_TMPTREEFILE  = "${TMPFILEDIR}/__tmp_mbgd_clstTree";
$TMP_IN_ADDINFO   = "${TMPFILEDIR}/__tmp_mbgd_in_addinfo";
$TMP_IN_CLUSTCAT  = "${TMPFILEDIR}/__tmp_mbgd_in_clustcat";

$PBS_queue = 'mbgd';
$QSUB_HEADER_STRING = qq{#PBS -N domclust
#PBS -l nodes=1
#PBS -q $PBS_queue

# MYSQL_MYCNF
setenv MYSQL_MYCNF $ENV{'MYSQL_MYCNF'}
export MYSQL_MYCNF=$ENV{'MYSQL_MYCNF'}
};
}
$| = 1;


#$WWWROOT = "/dbb/project/MBGD/Devel/WWW";
$WWWROOT = $main::DIR_www;

sub new {
	my($class, %option) = @_;

	_initVars();

	if ($Clustering::Instance) {
		return $MBGD::WWW::Clustering::Instance;
	}
	my($this) = {};
	bless $this, $class;
	$MBGD::WWW::Clustering::Instance = $this;
	if ($option{homParam}) {
		$this->{homParam} = $option{homParam}; 
	}
	if ($option{uInfo}) {
		$this->{uInfo} = $option{uInfo}; 
	}
	if ($option{no_check}) {
		$this->{no_check} = 1;
	}
	if ($option{qstring}) {
		$this->{qstring} = $option{qstring};
	}
	if (! $option{no_qsub} && -f $main::CMD_qsub) {
		$this->{qsub} = 1;
	}
	$this;
}
###############################################################################
sub makeCommand {
	my($this) = @_;
	my($objMd5);
	my($homParam, %param);

	$homParam = $this->get_HomParam;
	%param = $homParam->asHash;

	$species = join(',',split(/\|/,$param{species}));

	$CMD_SELECT = &main::getCmdSelect($species, $homParam);
	$CMD_CLUST = &main::getCmdClust($homParam, '', $param{'opt_clust'}, $this->{uInfo});

    my($fileClustCat) = $this->getFilenameClustcat();
	$CMD_ADDINFO = "$main::CMD_addinfo -cons_gene -category_col=category ";
	$CMD_ADDINFO .= " -getfunc=fromdb";	## get funccat from gene table
	$CMD_ADDINFO .= " -FILE_category='$fileClustCat'";

	## command string used as a cache key 
	($this->{clstCmdInfo}, $this->{clstSortCmdInfo}) = &main::execClustOptInfo(
		$CMD_SELECT, $CMD_CLUST, $CMD_ADDINFO, $CMD_SORT, $species);

#    # $B0J2<$N>pJs$O!"(Bcache key $B$H$7$FMxMQ$7$J$$$,!"%3%^%s%I<B9T$K$OI,MW(B
#    $CMD_ADDINFO .= " -FILE_category='$fileClustCat'";

	## command string for actual execution
	($this->{clstCmd1}, $this->{clstCmd2}, $this->{clstSortCmd}) = &main::execClustOpt(
		$CMD_SELECT, $CMD_CLUST, $CMD_ADDINFO, $CMD_SORT, $species);
   ## add as a md5 digest of species list
	$objMd5 = Digest::MD5->new();
	$objMd5->add($species);
	$this->{md5value} = $objMd5->hexdigest();
	$this->{species} = $species;
}
sub get_HomParam {
	my($this) = @_;
	my($homParam);
	if ($this->{homParam}) {
		$homParam = $this->{homParam};
	} elsif ($this->{uInfo}) {
		$homParam = $this->{uInfo}->loadHomolParams;
	} else {
		die "Homparam unspecified\n";
	}
	return $homParam;
}
sub open_ClstTableFile {
	my($this, $query_tabid, $noexec) = @_;
	my($TableFile, $TableFile0);

	if ($query_tabid) {
		$RDB_tableid = $query_tabid if(&main::testClustTableID($query_tabid));
		if ($this->{uInfo}) {
			$this->{uInfo}->saveTableIDs($RDB_tableid);
		}
		return "RDB:$RDB_tableid";
	}
#print STDERR "CMD>$this->{clstCmdInfo}\n";

#	$RDB_tableid = &main::getClustTableID($this->{clstCmdInfo});
	$RDB_tableid = &MBGD::ClustTab::DB::getClustTableID($this->{clstCmdInfo});
print STDERR "RDB>$RDB_tableid\n";

	if ( $RDB_tableid ) {
		if ($this->{uInfo}) {
			$this->{uInfo}->saveTableIDs($RDB_tableid);
		}
		return "RDB:$RDB_tableid";
	}
	if ($noexec) {
		return;
	}

	my @sp = split(/,/, $this->{species});
	my $uid = $this->{uInfo}->uid();
	my $hom = $this->{uInfo}->loadHomolParams;
	my $cluster_MAXSP        = $hom->getMaxSpec('MBGD',   $uid);
	my $cluster_MAXSP_MyMBGD = $hom->getMaxSpec('MyMBGD', $uid);
	my $maxSp = $cluster_MAXSP;
	if (MbgdUserGenomeCommon::isContainUserGenome($uid)) {
		$maxSp = $cluster_MAXSP_MyMBGD;
	}

	if (@sp > $maxSp) {
		print "Content-Type: text/html; charset=us-ascii\n\n";
	print "<H2>Please choose at most $maxSp organisms</H2>\n";
	print "Currently, we limit the number of organisms ".
		"for clustering to $maxSp.\n";
	print "Please <A HREF=/htbin/SelectOrganism.pl>re-select</A>".
		" organisms to be less than the limit," .
		" or use the <A HREF=/htbin/SetDefaultParam.pl?Location=SelectOrganism.pl>default set</A>.<br>\n";
		print "We are sorry for inconvenience.\n";
		exit(0);
	}

	###########################################################################

	if ($TableFile0 = &search_tmpfile($this->{clstCmdInfo}, "$TMP_TMPCLSTFILE.$this->{md5value}")){
		my($pid) = ($TableFile0 =~ /(\d+)$/);
		$this->execCheckCluster($pid);
		exit(0);	## never come here !!
	}

	if ($this->{no_check}) {
		## direct execution; for debug
		$this->execClusteringAll();
	} elsif ($pid = fork()) {
		# Parent
		$this->execCheckCluster($pid, $RDB_tableid);
		exit(0);	## never come here !!
	} elsif (defined($pid)) {
		# Child
		close(STDIN); close(STDOUT);
		close(STDERR);

		# Do clustering
		$this->execClusteringAll();
	} else {
		die "fork error!!($!)";
	}
	exit;
}
sub search_tmpfile {
	my($CMD,$TMPFILE) = @_;
	my(@tmpfiles,$l,$TableFile,$f);
	local(*F);

	@tmpfiles = <$TMPFILE.*>;
	foreach $f (@tmpfiles) {
		next if (! open(F, $f));
		$l = <F>;
		close(F);

		if ($l eq "# $CMD\n") {
            my($pid) = ($f =~ /(\d+)$/);
            my($sta) = kill(0 => $pid);
            if ($sta) {
    			$TableFile = $f;
	    		last;
            }

            # $BBP1~$9$k%W%m%;%9$,B8:_$7$J$$(B ==> $B;D3<%U%!%$%k(B
            unlink("$f");
		}
	}

	$TableFile;
}
###############################################################################
sub execClusteringAll {
	my($this) = @_;
	$this->set_variables;
	$this->change_dir;
	$this->setTmpFiles;
	$this->execClustering();
	$this->insertDB;
	$this->renameTmpFiles;
	$this->submit;
}
sub set_variables {
	my($this) = @_;
	my(@keyList) = ('MBGD_HOME', 'PERLLIB', 'MBGD_UID', 'MYSQL_DBTMP');
    foreach my$key (@keyList) {
		if ($ENV{"$key"}) {
			$this->{qsub_commands} .= "setenv $key $ENV{$key}\n";
#			$this->{qsub_commands} .= "export $key=$ENV{$key}\n";
		}
	}
}
sub change_dir {
	my($this) = @_;
	my($datadir);
	if ($this->{uInfo}) {
		$datadir =  $this->{uInfo}->getDataFile;
	} else {
		$datadir = main::DIR_tmp;
	}
	chdir $datadir;
	$this->{qsub_commands} .= "cd $datadir\n";
}
sub setTmpFiles {
	my($this) = @_;
	local(*FH);

	$this->{tmp_clustTree} = "$TMP_TMPTREEFILE.$this->{md5value}.$$"; # __tmp_mbgd_clstTree
	$this->{tmp_clustFile} = "$TMP_TMPCLSTFILE.$this->{md5value}.$$"; # __tmp_mbgd_cluster
	$this->{tmp_clustTab}  = "$TMP_TMPTABFILE.$this->{md5value}.$$";  # __tmp_mbgd_table
	$this->{clustTab} = "$TMPCLSTFILE.$this->{md5value}.$$"; # tmp_mbgd_cluster
	$this->{clustFile} = "$TMPTABFILE.$this->{md5value}.$$"; # tmp_mbgd_table
	$this->{clustTree} = "$TMPTREEFILE.$this->{md5value}.$$"; # tmp_mbgd_table

	$this->{tmp_in_addinfo}  = "$TMP_IN_ADDINFO.$this->{md5value}.$$";  # __tmp_mbgd_in_addinfo

	open(FH, "> $this->{tmp_clustTab}") || die "Can not open $this->{tmp_clustTab}($!)";
	print FH "# $this->{clstCmdInfo} | $this->{clstSortCmdInfo}\n";
	close(FH);

	open(FH, "> $this->{tmp_clustTree}") || die "Can not open $this->{tmp_clustTree}($!)";
	print FH "# $this->{clstCmdInfo}\n";
	close(FH);

	open(FH, "> $this->{tmp_clustFile}") || die "Can not open $this->{tmp_clustFile}($!)";
	print FH "# $this->{clstCmdInfo}\n";
	close(FH);
}

sub renameTmpFiles {
	my($this) = @_;
	# Rename result filenames (eliminating the leading '__')
	if($this->{qsub}) {
		$this->{qsub_commands} .=
			("mv $this->{tmp_clustFile} $this->{clustFile}\n" .
			 "mv $this->{tmp_clustTab} $this->{clustTab}\n" .
			 "mv $this->{tmp_clustTree} $this->{clustTree}\n");
	} else {
		rename("$this->{tmp_clustFile}", "$this->{clustFile}");
		rename("$this->{tmp_clustTab}", "$this->{clustTab}");
		rename("$this->{tmp_clustTree}", "$this->{clustTree}");
	}
}
sub exec_cmd {
	my($this, $cmd) = @_;
	if ($this->{qsub}) {
		$this->{qsub_commands} .= "$cmd\n";
	} else {
		system("$cmd");
	}
}
sub submit {
	my($this) = @_;
	if ($this->{qsub}) {
		my $tmpfile = "mbgd_qsub";
open(T,">$tmpfile");
print T "$QSUB_HEADER_STRING";
print T "$this->{qsub_commands}";
close(T);
#system("$main::CMD_qsub $tmpfile");
`$main::CMD_qsub $tmpfile`;
#unlink($tmpfile);

#		system("$main::CMD_qsub <<EOF
#$QSUB_HEADER_STRING
#$this->{qsub_commands}
#EOF");
	}
}
###############################################################################
sub execClustering
{
	my($this) = @_;
	my($filename);
	my($cmd);


	if (! $this->{tmp_clustTree}) {
		print "# $this->{clstCmd1}\n";
	}
	$cmd = "$this->{clstCmd1}";
	if ($this->{tmp_clustTree} && -f $this->{tmp_clustTree}) {
		$cmd .= " >> $this->{tmp_clustTree}";
	}
	$this->exec_cmd($cmd);
}
sub insertDB {
	my($this) = @_;

    #
    my($fileCategory) = $this->getFilenameClustcat();

    #
    my($tabid) = ($this->{tmp_clustTree} =~ /(\d+)$/);

    #
	my($cmd) = "$main::CMD_dbInsert $this->{tmp_clustTree}\n";

	if ($this->{qsub}) {
		$this->{qsub_commands} .= "$cmd\n";
	} elsif (! ($pid = fork)) {
		## fork if not qsub mode
		close(STDIN); close(STDOUT); close(STDERR);
		exec("$cmd");
	}

	$cmd = "$main::CMD_cat $this->{tmp_clustTree}";
	$cmd .= "| $this->{clstCmd2}"	if ($this->{clstCmd2});
	$cmd .= "| $this->{clstSortCmd}" if ($this->{clstSortCmd});
	$cmd .= ">> $this->{tmp_clustTab}";
	$this->exec_cmd($cmd);

	$cmd = "$main::CMD_dbInsert2 -FILE_category='$fileCategory' $this->{tmp_clustTab}";
	$this->exec_cmd($cmd);
	if (! $this->{qsub}) {
		## wait until the job is finished
		wait;
	}

    #
	$cmd = "$main::CMD_create_clustxref -DBNAME=$main::DBNAME_TMP -TABID=$tabid";
	$this->exec_cmd($cmd);
	if (! $this->{qsub}) {
		## wait until the job is finished
		wait;
	}

    $cmd = "$main::CMD_rm $fileCategory";
    $this->exec_cmd($cmd);
}
###############################################################################
sub execCheckCluster {
	my($this, $pid, $tabid) = @_;
	my($filename);

	# output clustering condition into the user file
	$rawinput =~ s/%([0-9A-Fa-f]{2})/pack("H2", $1)/eg;

	$this->{uInfo}->writeQueueCheck($this->{qstring});
	my $uid = $this->{uInfo}->{uid};

	$cmd = "$WWWROOT/htbin/checkCluster.pl -rawinput='pid=$pid&uid=$uid&tabid=$tabid'";
	exec("$cmd");
}

sub getFilenameClustcat {
    my($this) = shift;

    if (!exists($this->{'tmp_in_clustcat'})) {
        $this->{'tmp_in_clustcat'} = "$TMP_IN_CLUSTCAT.$$";
    }

    return $this->{'tmp_in_clustcat'};
}

###############################################################################
#
#sub close_TableFile {
#	my($CLUST, $WF) = @_;
#	close($CLUST);
#	if ($WF) {
#		close($WF)
#	}
#
#	if ($EXEC_DOMCLUSTINFO ne '') {
#		system("$EXEC_DOMCLUSTINFO");
#		undef($EXEC_DOMCLUSTINFO);
#	}
#
#	if ($TMP_WClstFile) {
#		rename $TMP_WClstFile, $WClstFile;
#	}
#	if ($TMP_WTableFile) {
#		rename $TMP_WTableFile, $WTableFile;
#	}
#}

#package main;
#if ($0 eq __FILE__) {
#	$uInfo = UserInfo->new('tmpuid');
#	$uInfo->saveHomolParams;
#	if ($main::species) {
#		$uInfo->setHomolParamFromHash({species=>$main::species})
#	}
#	$param{uInfo} = $uInfo;
#	$param{no_check} = 1;
#
#	$c = Clustering->new( %param );
#	$c->makeCommand;
#
#	$c->open_ClstTableFile;
###	$c->execClustering;
#}
###############################################################################
1;#
###############################################################################
