package MBGD_ACCUM::Schema::Chromosome;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("chromosome");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "udate",
  {
    data_type => "TIMESTAMP",
    default_value => undef,
    is_nullable => 1,
    size => 14,
  },
  "seqreg_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "source",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 20,
  },
  "name",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 12,
  },
  "seqno",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "type",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 20,
  },
  "shape",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 10,
  },
  "status",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 10,
  },
);
__PACKAGE__->set_primary_key("id");
__PACKAGE__->add_unique_constraint(chromosome_FKIndex2=>['seqreg_id']);


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-19 15:12:49
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:lfSYnPB9o3d6PEXirXnZAg

__PACKAGE__->belongs_to (
    seqreg => 'MBGD_ACCUM::Schema::Seqreg', {
        'foreign.id' => 'self.seqreg_id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
