package MBGD_ACCUM::Schema::Project;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("project");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "udate",
  {
    data_type => "TIMESTAMP",
    default_value => undef,
    is_nullable => 1,
    size => 14,
  },
  "institution_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "organism_id",
  { data_type => "INT", default_value => undef, is_nullable => 1, size => 10 },
  "environment_id",
  { data_type => "INT", default_value => undef, is_nullable => 1, size => 10 },
  "sp",
  { data_type => "VARCHAR", default_value => undef, is_nullable => 0, size => 5 },
  "spid",
  { data_type => "VARCHAR", default_value => undef, is_nullable => 0, size => 7 },
  "source",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 20,
  },
  "type",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 20,
  },
  "wwwlink",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 1,
    size => 200,
  },
  "date_release",
  { data_type => "DATE", default_value => undef, is_nullable => 1, size => 10 },
  "date_modify",
  { data_type => "DATE", default_value => undef, is_nullable => 1, size => 10 },
  "mbgd_update",
  { data_type => "DATE", default_value => undef, is_nullable => 1, size => 10 },
);
__PACKAGE__->set_primary_key("id");
__PACKAGE__->add_unique_constraint("project_unique_spid", ["spid"]);


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-19 15:12:50
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:cSpJU0EmcjF3zMICYV5pwA

__PACKAGE__->belongs_to (
    institution => 'MBGD_ACCUM::Schema::Institution', {
        'foreign.id' => 'self.institution_id'
    }
);
__PACKAGE__->belongs_to (
    organism => 'MBGD_ACCUM::Schema::Organism', {
        'foreign.id' => 'self.organism_id'
    }
);
__PACKAGE__->belongs_to (
    environment => 'MBGD_ACCUM::Schema::Environment', {
        'foreign.id' => 'self.environment_id'
    }
);
__PACKAGE__->has_many (
    genesets => 'MBGD_ACCUM::Schema::Geneset', {
        'foreign.project_id' => 'self.id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
