#!/usr/bin/perl -s
use File::Basename;
###############################################################################
package main;

###############################################################################
#
$URL_ncbi           = "http://www.ncbi.nlm.nih.gov";
$URL_kegg           = "http://www.genome.ad.jp";
$URL_mbgd           = "http://mbgd.genome.ad.jp";

###############################################################################
#
$CGI_entrez         = "$URL_ncbi//htbin-post/Entrez/query";
$CGI_pubmed         = "$URL_ncbi/entrez/query.fcgi?cmd=Retrieve&db=PubMed&list_uids=%d&dopt=Abstract";

##############################################################################
# CGI
$MBGD_PATH_HTBIN = "/htbin/";

###############################################################################
# MBGD command PATH
$CMD_mqblast            = "$DIR_mqblast/mqblast";
$CMD_createList         = "$DIR_mqblast/create_list";
$CMD_execmdp            = "$DIR_mqblast/execmdp.pl";
$CMD_execdp2            = "$DIR_mqblast/execdp2.pl";
$CMD_exechmmer          = "$DIR_mqblast/exechmmer.pl";
$CMD_execrpsblast       = "$DIR_mqblast/execrpsblast.pl";
$CMD_updateList         = "$DIR_mqblast/update_list.pl";
$CMD_convrps            = "$DIR_mqblast/convrps.pl";
$CMD_readRpsBlastDomTop = "$DIR_rpsblast/bin/readRpsBlast.pl";
$CMD_domclust           = "$DIR_www/bin/domclust";
$CMD_mergetree          = "$DIR_www/bin/mergetree";
$CMD_clusttree2flat     = "$DIR_www/bin/clusttree2flat.pl";
$CMD_convClustFile      = "$DIR_www/bin/convClustFile.pl";
$CMD_select             = "$DIR_www/bin/select.pl";
$CMD_select_homlist     = "$DIR_www/bin/select_homolog_list.pl";
$CMD_disp_align         = "$DIR_binaries/disp_align";
$CMD_clv2fs             = "$DIR_www/bin/clv2fs";
$CMD_hcluster           = "$DIR_www/bin/hcluster.pl";
$CMD_conv_addinfo_in    = "$DIR_www/bin/conv_addinfo_in.pl";
$CMD_addinfo            = "$DIR_www/bin/addinfo";
$CMD_getinfo            = "$DIR_www/bin/getinfo";
$CMD_mapgapfilt         = "$DIR_www/bin/mapgapfilt";
$CMD_treealig           = "$DIR_www/bin/treealig";
$CMD_mbget              = "$DIR_www/bin/mbget";
$CMD_convtax            = "$DIR_www/bin/convtax.pl";
$CMD_get_base_cluster   = "$DIR_www/bin/get_base_cluster.pl";

$CMD_dbInsert           = "$DIR_www/bin/dbInsert.pl";
$CMD_dbInsert2          = "$DIR_www/bin/dbInsert2.pl";
$CMD_dbInsert_base_cluster = "$DIR_www/bin/dbInsert_base_cluster.pl";

$CMD_dp2                = "$DIR_mbgdhome/binaries/dp2";
$CMD_create_sortres     = "$DIR_mbgdhome/bin/create_sortres";
$CMD_readRpsBlast       = "$DIR_mbgdhome/bin/readRpsBlast.pl";
$CMD_pfsearch_pl        = "$DIR_mbgdhome/bin/pfsearch.pl";
$CMD_readBlast          = "$DIR_mbgdhome/bin/read_blast2";
$CMD_blastPdp           = "$DIR_mbgdhome/bin/blastPdp";

$CMD_convPhyloPat       = "$DIR_mbgdhome/WWW/bin/RECOG/convPhyloPat.pl";
$CMD_phylopat           = "$DIR_mbgdhome/WWW/bin/RECOG/phylopat";
$CMD_phylopatCluster    = "$DIR_mbgdhome/WWW/bin/RECOG/phylopatCluster";

$CMD_parseHomology      = "$DIR_build/parseHomology.pl";
$CMD_parsePrositeSearch = "$DIR_build/parsePrositeSearch.pl";
$CMD_parsePfSearch      = "$DIR_build/parsePfSearch.pl";
$CMD_parseRpsBlast      = "$DIR_build/parseRpsBlast.pl";
$CMD_filter_ftp_goa     = "$DIR_build/filter_ftp_goa.pl";
$CMD_select_default_orgs= "$DIR_build/select_default_orgs.pl";

$CMD_clustw2fasta       = "$DIR_www/bin/clustw2fasta.pl";

###############################################################################
1;#
###############################################################################
