#!/usr/bin/perl -s
package Nqs;
use strict;
use DirHandle;
use FileHandle;
use File::Basename;
use File::Path;

###############################################################################
# ᥽åɰ
#     new()                :
#     setDirWork()         :
#     getDirWork()         :
#     setDirCommand()      : PBS/LSF Υޥɥǥ쥯ȥ
#     setSleepTime()       : JOB νλåֳ[]
#     getSleepTime()       : JOB νλåֳ[]μ
#     clearJobIdx()        : Nqs ⥸塼Ǥ JOB ֹν
#     getJobIdx()          : Nqs ⥸塼Ǥ JOB ֹ
#     clearJobId()         : JOB ID ΰν
#     setJobId()           : ¹Ԥ JOB ID Ͽ
#     unsetJobId()         : λ JOB ID 
#     getJobIdList()       : ¹ԤλƤʤ JOB ID ΥꥹȤ
#     statOneJob()         : JOB ID ꤷƤ JOB ¹Ծ
#     waitOneJob()         : JOB ID ꤷ JOB νλԤ
#     waitJobs()           : ¹ JOB ξ¤ꤷޤԤ
#     waitAllJobs()        : Ƥμ¹ JOB λޤԤ
#     createJobfile()      : jobfile 
#     execJobfileUnlimit() : JOB μ¹ԡjobfile 
#     execOneJobfile()     : Ĥ JOB μ¹ԤȽλԤjobfile 
#     execOneJob()         : Ĥ JOB μ¹ԤȽλԤjobfile 
#     execJobfile()        : ¹ JOB ξ¤ꤷJOB μ¹ԡjobfile 
#     execJob()            : ¹ JOB ξ¤ꤷJOB μ¹ԡjobfile 
###############################################################################


###############################################################################
#
sub new {
    my($class) = shift;
    my($dirCmd) = shift;
    my($dirPub) = shift;
    my($self) = {};

    bless($self, $class);

    # qsub/qstat ޥɥǥ쥯ȥ
    $self->setDirCommand("$dirCmd");

    # ȥǥ쥯ȥ
    $self->setDirWork("$dirPub/$ENV{'USER'}");

    # ǥեȤǣôֳ֤ǽλå
    $self->setSleepTime(5);

    #
    $self->clearJobIdx();

    #
    $self->clearJobId();

    return $self;
}

###############################################################################
#
sub setDirWork {
    my($self) = shift;
    my($dirWork) = shift;

    $self->{'DIR_WORK'} = $dirWork;

    #
    mkpath("$dirWork", 0, 0750);
    if (! -e "$dirWork") {
        print STDERR "WARNING :: Can not create '$dirWork' directory. ($!)\n";
    }

    #
    my($fileWork) = "$dirWork/test.$$";
    my($fh) = new FileHandle(">$fileWork");
    if (! $fh) {
        print STDERR "WARNING :: Can not write '$dirWork' directory. ($!)\n";
    } else {
        $fh->close();
        unlink();
    }

    return;
}

###############################################################################
#
sub getDirWork {
    my($self) = shift;

    return $self->{'DIR_WORK'};
}

###############################################################################
#
sub setDirCommand {
    my($self) = shift;
    my($dir) = shift;

    $self->{'DIR_COMMAND'} = $dir;

    foreach my$cmd ('qsub', 'qstat') {
        if (-e "$dir/$cmd") {
            $self->{"CMD_$cmd"} = "$dir/$cmd";
        }
        elsif (-e "$dir/bin/$cmd") {
            $self->{"CMD_$cmd"} = "$dir/bin/$cmd";
        }
        else {
            print STDERR "Can not found $cmd.\n";
            exit(0);
        }
        print STDERR "DBG :: FOUND ", $self->{"CMD_$cmd"}, "\n" if ($main::DEBUG);
    }

    return;
}

###############################################################################
#
sub setSleepTime {
    my($self) = shift;
    my($t) = shift;

    if ($t < 1) {
        $t = 1;
    }
    $self->{'TIME_SLEEP'} = $t;
    print STDERR "DBG :: SET sleep time $t\n" if ($main::DEBUG);

    return;
}

###############################################################################
#
sub getSleepTime {
    my($self) = shift;

    return $self->{'TIME_SLEEP'};
}

###############################################################################
#
sub clearJobIdx {
    my($self) = shift;

    $self->{'JOB_IDX'} = 0;

    return;
}

###############################################################################
#
sub getJobIdx {
    my($self) = shift;

    my($idx) = $self->{'JOB_IDX'};
    $self->{'JOB_IDX'}++;
    if (100000000 <= $self->{'JOB_IDX'}) {
        $self->clearJobIdx();
    }

    return $idx;
}

###############################################################################
#
sub clearJobId {
    my($self) = shift;

    print STDERR "DBG :: CLEAR job id\n" if ($main::DEBUG);
    $self->{'HASH_JOB_ID'} = {};

    return;
}

###############################################################################
#
sub setJobId {
    my($self) = shift;
    my($id) = shift;

    $self->{'HASH_JOB_ID'}->{"$id"} = 1;

    return;
}

###############################################################################
#
sub unsetJobId {
    my($self) = shift;
    my($id) = shift;

    delete($self->{'HASH_JOB_ID'}->{"$id"});

    return;
}

###############################################################################
#
sub getJobIdList {
    my($self) = shift;

    my(@jobIdList) = keys(%{$self->{'HASH_JOB_ID'}});

    return @jobIdList;
}

###############################################################################
#
sub statOneJob {
    my($self) = shift;
    my($id) = shift;

    my($t) = $self->getSleepTime();
    my($now) = time();
    if ($self->{'TIME_QUEUE'} + $t <= $now) {
        print STDERR "DBG :: UPDATE qstat\n" if ($main::DEBUG);
        my($cmd) = "$self->{'CMD_qstat'}";
        $self->{'STAT_QUEUE'} = join('', `$cmd`);
        $self->{'TIME_QUEUE'} = $now;
    }

    #
    foreach my$line (split(/[\r\n]+/, $self->{'STAT_QUEUE'})) {
        if (($line =~ /^(\d+)/) && ($1 == $id)) {
            print STDERR "DBG :: FOUND(pbs) $id\n" if ($main::DEBUG);
            return 1;    # queue ¸ߤƤ
        }
        elsif (($line =~ /(\d+)\s+$ENV{'USER'}/) && ($1 == $id)) {
            print STDERR "DBG :: FOUND(lsf) $id\n" if ($main::DEBUG);
            return 1;    # queue ¸ߤƤ
        }
    }

    return 0;
}

###############################################################################
#
sub waitOneJob {
    my($self) = shift;
    my($id) = shift;

    my($t) = $self->getSleepTime();
    for(;;) {
        my($sta) = $self->statOneJob($id);
        if (! $sta) {
            $self->unsetJobId($id);
            return;
        }

        sleep($t);
    }
}

###############################################################################
#
sub waitJobs {
    my($self) = shift;
    my($limit) = shift;

    if ($limit < 1) {
        $limit = 1;
    }

    my($t) = $self->getSleepTime();
    for(;;) {
        my(@jobIdList) = $self->getJobIdList();
        if (scalar(@jobIdList) < $limit) {
            # ¹ JOB ¤꾯ʤʤä
            return;
        }
        foreach my$id (@jobIdList) {
            my($sta) = $self->statOneJob($id);
            if (! $sta) {
                $self->unsetJobId($id);
            }
        }

        sleep($t);
    }
}

###############################################################################
#
sub waitAllJobs {
    my($self) = shift;

    $self->waitJobs(0);
}

###############################################################################
#
sub createJobfile {
    my($self) = shift;
    my($cmd) = shift;

    my($idx) = $self->getJobIdx();
    my($filename) = sprintf("%s/job_%s_%d", $self->getDirWork(),
                                            $ENV{'USER'},
                                            $idx);
    my($fh) = new FileHandle(">$filename") || die("Can not open $filename($!)");
    $fh->print($cmd, "\n");
    $fh->close();

    return $filename;
}

###############################################################################
#
sub execJobfileUnlimit {
    my($self) = shift;
    my($fileCmd) = shift;

    my($cmd) = "$self->{'CMD_qsub'} $fileCmd";
    my($ret) = `$cmd`;

    my($id) = ($ret =~ /(\d+)/);
    $self->setJobId($id);
    print STDERR "DBG :: JOBID=$id :: $cmd\n" if ($main::DEBUG);

    return $id;
}

###############################################################################
#
sub execOneJobfile {
    my($self) = shift;
    my($fileCmd) = shift;

    my($id) = $self->execJobfileUnlimit($fileCmd);
    $self->waitOneJob($id);

    return;
}

###############################################################################
#
sub execOneJob {
    my($self) = shift;
    my($cmd) = shift;

    #
    my($filename) = $self->createJobfile($cmd);
    $self->execOneJobfile($filename);

    unlink <$filename>;
    unlink <$filename.o*>;
    unlink <$filename.e*>;
}

###############################################################################
#
sub execJobfile {
    my($self) = shift;
    my($limit) = shift;
    my($file) = shift;

    my($t) = $self->getSleepTime();

    $self->waitJobs($limit);
    my($id) = $self->execJobfileUnlimit($file);

    return $id;
}

###############################################################################
#
sub execJob {
    my($self) = shift;
    my($limit) = shift;
    my($cmd) = shift;

    my($filename) = $self->createJobfile($cmd);
    my($id) = $self->execJobfile($limit, $filename);

    return $id;
}

###############################################################################
package main;
if ($0 eq __FILE__) {
    $main::DEBUG = 1;
    my($objNqs) = new Nqs($main::DIR_cmd, $main::DIR_pub);

    #
    for(my$i = 0; $i < 10; $i++) {
        my($cmd) = join(";", "sleep " . int(rand(10)),
                             "touch test.out.$i");
        $objNqs->execJob(3, $cmd);
    }
    $objNqs->waitAllJobs();
}

###############################################################################
1;#
###############################################################################
