#!/usr/bin/perl -s
use strict;
use FileHandle;
use MBGD::DB;
use RECOG;
use RECOG::DomClustCommon;
use RECOG::DomClust;
use RECOG::MBGD::ClusterTable;
use RECOG::MBGD::OutputDomClust;
use MBGD::Taxonomy;

$| = 1;

# domclust$B$r(Bfork$B$9$k$+H]$+$r7hDj$9$k(B
# $BI,$:$I$N=hM}$G$b%A%'%C%/7k2L$rJV$9!#(B
#  1$B$N>l9g!"%A%'%C%/7k2L$H%X%C%@!<>pJs$rJV$9!#<!$N%9%F%C%W$G(Bdomclust$B$r(Bfork$B$9$k(B
#  0$B$N>l9g!"%A%'%C%/7k2L$HI=<(>pJs$rJV$9!#(B
#  1 ---> fork$B$N<B9T(B
#  0 ---> $B<B9TCf(B
# -1 ---> $B<B9T=*N;(Bor$B<B9T%(%i!<=*N;!#(Bfork$B$r<B9T$7$J$$$G(Bdeomclust$B$r<B9T(B
#  2 ---> $B:o=|=hM};~!JL$BP1~!K(B
# DomClust $B<B9T%9%F!<%?%9$N%A%'%C%/(B
# $B%9%F!<%?%9(B
#     0      $BB>%W%m%;%9$,<B9T;~(B
#    -1      $B<B9T%(%i!<;~(B
#    -1      $B<B9T=*N;;~(B
#     2      $B:o=|=hM};~(B
#     1      $BL$<B9T!":F<B9T2DG=>uBV(B
#
sub checkRecogProgress {
	my $refOpt = shift;
	my $progress;
	my $db = new MBGD::DB($main::DOMCLUST_DB);
	my $st = new RECOG::MBGD::OutputDomClust;

	# $BF~NO%Q%i%a!<%?$,L5$$>l9g(B
	if(! $refOpt) {
		return undef;
	}

    #
    my $cmd = &createCmdline($refOpt);

	my $clusterID = getTabid($db, $cmd);
	if(!$clusterID) {
		return undef;
	}

 	# $B<B9T%9%F!<%?%9$N%A%'%C%/(B
	my $status = &getStatus_fr_cmd($db, $cmd);

	# $B%9%F!<%?%9$N%A%'%C%/(B
	if($status == $$) {
		# $B$3$l$+$i<B9T(B
		my $info = $st->runTabID($db, $clusterID, $refOpt->{'-out_format'}, $refOpt->{'-dbtype'}, $refOpt);
		return (1, $info);
	} elsif($status == -1) {
		# $B<B9T:Q$_(B
		return (-1);
    } elsif($status < -1) {
	    # $B<B9T%(%i!<(B
		# $B%j%H%i%$%+%&%s%H$,5,DjCMFb$J$i$3$l$+$i:F<B9T(B
		# $B%j%H%i%$%+%&%s%H$,5,DjCM$r%*!<%P!<$7$F$$$?>l9g!"%(%i!<(B
		if(&canRetry($db, $clusterID)) {
			my $info = $st->runTabID($db, $clusterID, $refOpt->{'-out_format'}, $refOpt->{'-dbtype'}, $refOpt);
			return(1, $info);
		} else {
			return(-1);
		}
	} else {
		# $B<B9TCf(B
		# $BK\Ev$K<B9TCf$+$I$&$+$rD4::$9$k(B
		if(isAlive($status) && $status != 1 && $status !=0) {
			# $B=hM}Cf$N>l9g!"?JD=$r<hF@$7$F=PNO$9$k(B
			my $info = $st->runTabID($db, $clusterID, $refOpt->{'-out_format'}, $refOpt->{'-dbtype'}, $refOpt);
			return(0, $info);
		} else {
			# $B<B9T$7$F$$$J$$(B
			# $B%j%H%i%$%+%&%s%H$,5,DjCM$r%*!<%P!<$7$F$$$?>l9g!"%(%i!<$r=PNO$9$k(B
			# $B%j%H%i%$%+%&%s%H$,5,DjCMFb$J$i$3$l$+$i:F<B9T$r$9$k!&2?$b$7$J$$(B
			if(&canRetry($db, $clusterID)) {
				my $info = $st->runTabID($db, $clusterID, $refOpt->{'-out_format'}, $refOpt->{'-dbtype'}, $refOpt);
				return(1, $info);
			} else {
				return(-1);
			}
        }
	}
}

#
# $B=hM}$N?JD=$r<hF@$9$k(B
#
# $B0z?t!!(B$id$B!!%/%i%9%?!<(BID
#
# $BLa$jCM(B $B%m%0%U%!%$%k$NKvHx0l9T(B($B=hM}>u67(B\t$B?JD=>u67!s(B\n)
#
sub getProgress {
	my $id = shift;

	# $B%m%0%U%!%$%k$NKvHx(B3$B9T$r<hF@$9$k(B
	my $logfile = $main::DOMCLUST_TMP_DIR . "/". $main::PREF_DOMCLUST_PROG . "_" . $id;
	my $line = `tail -n 3 $logfile`;

	# $B40A4$K<hF@=PMh$F$$$k9T(B($BKvHx$K2~9T%3!<%I$,$"$k9T(B)$B$r=PNO$9$k(B
    my $c = ($line =~ s/\n/\n/g);
	my @log = split/\n/,$line;
	
	return($log[$c-1]);
}

###############################################################################
###############################################################################

#
# $B%9%F!<%?%9$KBP1~$9$k%W%m%0%i%`$r5/F0$9$k(B
#
sub execRecogDomclust {
    my ($refOpt) = shift;

	my $db = new MBGD::DB($main::DOMCLUST_DB,{'new' => 1});
    my $od = new RECOG::MBGD::OutputDomClust;

	# $B%(%i!<=PNO%O%s%I%k$r:n@.(B
	my $eH;
	if($refOpt->{'-err'}) {
		$eH = new FileHandle('>>' . $refOpt->{'-err'});
	}

	my $cmd;
	my $status;
	# clusterID$B$N8!:w$G5/F0$5$l$?>l9g!"(BID$B$+$i%3%^%s%I$r@8@.$9$k(B
	if($refOpt->{'-clusterID'}) {
		# ID$B$,B8:_$9$k$+%A%'%C%/$9$k(B
		# ID$B$,B8:_$7$?>l9g!"(B$refOpt $B$r:F@8@.$7!"%9%F!<%?%9$r5a$a$k(B
		my $clusterID = $refOpt->{'-clusterID'};
	    $status = getStatus_fr_id($db,$clusterID) ;
		if(! $status) {
			&printSTD($od->output_Error("clusterID:$clusterID is invalid.",,$refOpt->{'-out_format'}),$eH);
			return;
		}
		$cmd = getCmd($db, $clusterID);
		my($sp,$opt) = idtoOpt($db, $clusterID);
		foreach my $k (keys%{$opt}) {
			my $v = $opt->{$k};
			$refOpt->{$k} = $v;
		}
	} else {
		# ingroup$B%*%W%7%g%s$,L5$$>l9g!"%(%i!<$r=P$7$F=*N;(B
		if(!$refOpt->{'-ingroup'}) {
			&printSTD($od->output_Error("-ingroup option was necessary.",,$refOpt->{'-out_format'}),$eH);
			return ;
		}
		# $B%3%^%s%I$+$i%9%F!<%?%9$r%A%'%C%/$9$k(B
		$cmd = &createCmdline($refOpt);
		$status = getStatus_fr_cmd($db, $cmd);
	}

	if(! $status) {
		my $clusterID = getTabid($db, $cmd);
        &printSTD($od->output_Error(-99,$clusterID,$refOpt->{'-out_format'}), $eH);
        return;
	}

    # $B<B9T=*N;(B
    if($status == -1) {
        # $B<B9T7k2L$r=PNO$9$k(B
		outputDomclustResult($od, $db, $cmd, $refOpt);
        return;
    }
    # $B<B9T=`Hw(BOK
    elsif($status == getppid) {
		# domclust$B$N<B9T(B
		&doExec($od, $cmd, $refOpt,$eH);
		# $B7k2L$r<hF@$7$FI=<($9$k(B
		my $st = getStatus_fr_cmd($db, $cmd);
		if($st == -1) {
			outputDomclustResult($od, $db, $cmd, $refOpt);
		} else {
			my $clusterID = getTabid($db, $cmd);
			&printSTD($od->output_Error(3,$clusterID,$refOpt->{'-out_format'}), $eH);
		}
		return;
    }
	# $B%j%H%i%$2DG=$+3NG'$7!"2DG=$J$i:F<B9T!"IT2DG=$J$i%(%i!<$r=P$7$F=*N;(B
    elsif($status < -1) {
		my $clusterID = getTabid($db, $cmd);
		if(&canRetry($db, $clusterID)) {
			&uploadRetryStatus($db, $clusterID);
			&doExec($od, $cmd, $refOpt,$eH);
                # $B7k2L$r<hF@$7$FI=<($9$k(B
			my $st = getStatus_fr_cmd($db, $cmd);
			if($st == -1) {
				outputDomclustResult($od, $db, $cmd, $refOpt);
				return;
			}
		}
		&printSTD($od->output_Error(3,$clusterID,$refOpt->{'-out_format'}), $eH);
		return;
	}
	# $BB>$N%W%m%;%9$,<B9TCf(B
	elsif($status > 0) {
        if(isAlive($status)) {
		    &printERR("Already running. Please wait running process.\n",$eH);
			my $clusterID = getTabid($db, $cmd);
			# $B?JD=$r<hF@$9$k(B
			checkExecProg($od, $db, $clusterID, $eH);
		    # $B%W%m%;%9=*N;8e!"7k2LI=<((B
		    my $st = getStatus_fr_cmd($db, $cmd);
		    if($st == -1) {
			    outputDomclustResult($od, $db, $cmd, $refOpt);
		    } else {
			    my $clusterID = getTabid($db, $cmd);
			    &printSTD($od->output_Error(3,$clusterID,$refOpt->{'-out_format'}), $eH);
		    }
		    return ;
	    }
        else {
            # $BB>$N%W%m%;%9$OF0$$$F$$$J$+$C$?(B($B%j%H%i%$2DG=$+$r:FD4::$9$k!#2DG=$J$i:F<B9T(B)
            my $clusterID = getTabid($db, $cmd);
            if(&canRetry($db, $clusterID)) {
                &uploadRetryStatus($db, $clusterID);
				&doExec($od, $cmd, $refOpt,$eH);
				# $B7k2L$r<hF@$7$FI=<($9$k(B
				my $st = getStatus_fr_cmd($db, $cmd);
				if($st == -1) {
					outputDomclustResult($od, $db, $cmd, $refOpt);
				} else {
				    &printSTD($od->output_Error(3,$clusterID,$refOpt->{'-out_format'}), $eH);
				}
				return;
            } else {
				&printSTD($od->output_Error(3,$clusterID,$refOpt->{'-out_format'}), $eH);
				return;
			}
        }
    }
	# $BIT@5<B9T(B
	else {
		my $clusterID = getTabid($db, $cmd);
		&printSTD($od->output_Error(-99,$clusterID,$refOpt->{'-out_format'}), $eH);
		return;
    }
}

# $B<B9T7k2L$r=PNO$9$k(B
sub outputDomclustResult {
	my ($od) = shift;
	my ($db) = shift ;
	my ($cmd) = shift;
	my ($opt_ref) = shift;
	
	my $clusterID = getTabid($db, $cmd);
	my $info = getHeaderInfo($db, $clusterID);

	my($retOdWrite) = $od->write($db, $opt_ref->{'-out_format'},
                                      $opt_ref->{'-output_type'},
                                      $clusterID,
                                      $opt_ref->{'-dbtype'},
                                      $info);
	&printSTD($retOdWrite, $opt_ref);

}

# domclust$B$r<B9T$9$k(B
# $B<+?H$r8F$S=P$9(B
sub doExec {
	my($od) = shift;
	my($cmd) = shift;
	my($opt_ref) = shift;
	my($eH) = shift;

	my $pid;
  FORK: {
	$pid = fork();
	my $db = new MBGD::DB($main::DOMCLUST_DB, {'new' => 1});
	my $clusterID = getTabid($db, $cmd);
	my $res = updateRunningStatus($db, $clusterID, $$);

	if($pid) {
        &checkExecProg($od, $db, $clusterID, $eH);
		waitpid($pid,0);
	} 
	elsif (defined $pid) {
		# domclust$B$N<B9T(B
		my $dc = new RECOG::DomClust();
		my $r = $dc->exec($clusterID, $cmd);

		# $B<B9T%(%i!<$N>l9g!"%(%i!<%9%F!<%?%9$rEPO?$7$F=*N;$9$k!#(B
        if(!$r) {
			uploadWarnings($db,$clusterID,$dc->{'TmpErrorfile'});
            exit;
        }

        # domclust$B$,(Bwarning$B$r=P$7$F$$$?$i(BDB$B$K(Bwarning$B$rEPO?$9$k(B
		if(-s $dc->{'TmpErrorfile'}) {
			uploadWarnings($db,$clusterID,$dc->{'TmpErrorfile'});
		}

		# $B%/%i%9%?>pJs$r%F!<%V%k$H$7$F<hF@$9$k!#(B		
		my $ctbl;
		my($ing, $outg, $species) = &uniqSpecies($opt_ref);
		$ctbl = $dc->getClusterTableInst($cmd, $ing, $outg, $species);
	
        # $B<hF@$7$?%/%i%9%??t$r(BDB$B$KEPO?(B
		my $cluster_Count = $dc->{'ClusterCount'};
		uploadNdomclust($db,$clusterID,$cluster_Count);

        # $B%G!<%?$rDI2C$9$k(B

		$ctbl->addGeneInfoFuncLog2($dc->{'TmpProgfile'});

        # domclust$B$N<B9T7k2L$r(Bcluster_result_$clusterID$B$XEPO?$9$k(B
		my $cfile = $dc->{'Tmpfile'};
		createResultTable($db,$clusterID,$cfile);

        # $B%U%!%s%/%7%g%s%G!<%?$r(BDB$B$XEPO?$9$k(B
        $ctbl->write($db,(format => 'db',
                          FuncDB => $main::TBL_DOMFUNC_DB,
                          GeneDesc => $main::TBL_DOMFUNC_GENE,
                          clusterID => $clusterID)
                     );
        # $B=*N;%9%F!<%?%9$r(BDB$B$KEPO?$9$k(B
        my $optionlines = 'clusterID=' . $clusterID . " " .
                          'clusternum=' . $cluster_Count . " " .
                          'spec='      . join(",", @$species) . " " .
                          'ingroup='   . join(",", @$ing) . " " .
                          'outgroup='  . join(",", @$outg);

		uploadFinishStatus($db,$clusterID,$optionlines);

		exit;
	} else {
        die "Can't fork: $\n";
    }

} # End Of Label:FORK

    return;
}

# $B%W%m%0%i%`$N?JD=$r4F;k$9$k(B
sub checkExecProg {
	my $od = shift;
	my $db = shift;
	my $id = shift;
	my $eH = shift;

	my $res = "";
	my $stdoutfile = $main::DOMCLUST_TMP_DIR . "/". $main::PREF_DOMCLUST_PROG . "_" . $id;
	while(! -f $stdoutfile) {
		sleep(1);
	}

	while(&getStatus_fr_id($db,$id) > 0) {
		my $log = `tail -n 3 $stdoutfile`;
		if($log eq $res) {
			next;
		}
		else {
			my ($status, $per) = $od->getNowProg($db, $id);
			$res = $log;
			my $line = "";
			if($per) {
				$line = "STATUS::$status >> $per %\n";
			} else {
				$line = "STATUS::$status\n";
			}

			printERR($line, $eH);
		}
	}
	return;
}

sub printSTD {
	my $line = shift;
    my ($opt_ref) = shift;

    my $file = $opt_ref->{'-out'};
    if($file) {
        my $fh = new FileHandle('>' .$file);
        if($fh) {
            print $fh $line;
        } else {
            print STDOUT $line;
        }
    } else {
        print STDOUT $line;
    }
}

sub printERR {
	my $line = shift;
	my $eH = shift;

	if($eH) {
		print $eH $line;
	} else {
		print STDERR $line;
	}
}

###############################################################################

sub parseDomclustOutTree {
    my($fh) = shift;
    my($refFunc) = shift || sub { my($cid, $scid, $tree) = @_; };

    my($clustId);
    my($subClustId);
    my($tree) = '';
    while(my$line = $fh->getline()) {
        next if ($line =~ /^\s*$/);

        if ($line =~ /^Cluster\s+(\d+)/i) {
            my($tmpClustId) = $1;
            if ($tree) {
                &$refFunc($clustId, $subClustId, $tree);
            }
            $clustId = $tmpClustId;
            $subClustId = 1;
            $tree = '';
        }
        elsif ($line =~ /^SubCluster\s+(\d+)/i) {
            my($tmpSubClustId) = $1;
            if ($tree) {
                &$refFunc($clustId, $subClustId, $tree);
            }
            $subClustId = $tmpSubClustId;
            $tree = '';
        }
        elsif ($line =~ /^OutGroup/i) {
            if ($tree) {
                &$refFunc($clustId, $subClustId, $tree);
            }
            $subClustId = 0;
            $tree = '';
        }
        else {
            $tree .= $line;
        }
    }
    if ($tree) {
        &$refFunc($clustId, $subClustId, $tree);
    }

    return;
}

###############################################################################
1;#
###############################################################################
