#!/usr/bin/perl -s
package RECOG::MBGD::ClusterTable;
###############################################################################
# ̾
#     RECOG::MBGD::ClusterTable.pm
#
# 
#     ClusterTable쥯饹ȤMBGDͭ°䵡ǽɲä饹
#
# 
#     ClusterTable饹ˡMBGDղþ(̾ǽ̾)ɲ
#     ȤȤˡMBGDϽ(ʪ)˴Ťơơ֥
#     󤹤롣
#     
#     㡧
#       my $ctbl = new DomClust::CGI(....);
#
#       # 饹ơ֥MBGDղþͿ롣
#       my $mbgdTable = new MBGD::ClusterTable($ctbl);
#
#       # ֶڤΥƥȤɽϤ롣
#       $mbgdTable->write(format => 'text', type => 'boolean');
#       
# ѥåѿ
#     
# Сѿ (ܥ饹ͭΤ)
#     
# ᥽åɰ
#     new()
#     _init()
#     write()
#     sortSpeicies()
#     getSpeciesOrder()
#     addCoutupRes()
#     countupGeneFuncDesc()
#     get_function_db()
#     getFunctionCategory()
#     addGeneInfoFuncLog()
#     getGeneInfo()
#     getClusterGeneInfo()
#     getGeneInfoTopPri()
#     dumpDB()
#     loadDB()
#
# 
#
###############################################################################
use strict;
our(@ISA);                                   # require 5.6.0;
use FileHandle;
use IO::File;
use RECOG::ClusterTable;
use MBGD;
use MBGD::Taxonomy;
use MBGD::FuncCat;
use MBGD::FunctionCategory;
use RECOG::MBGD::ClusterTable::Writer;
use ConsenseTitle;
use Time::HiRes;
require "libMBGDFuncCat.pl";

# ѥåѿ
@ISA = ( "RECOG::ClusterTable" );    # require 5.6.0;

###############################################################################
# ̾
#     new()
# 
#     󥹥ȥ饯
# 
#     $that  : 饹̾(⤷ϥ󥹥󥹤Υե)
# 
#     󥹥󥹤ؤΥե
# 
#
# 
#
sub new {
    my $that = shift;

    # $that ե󥹤ʤ顢ѥå̾롣
    my $class = ref($that) || $that;

    my $self = {};
    bless($self, $class);

    $self->_init();

    return $self;
}

###############################################################################
# ̾
#     _init()
# 
#     
# 
#     $self : 󥹥󥹤ؤΥե
# 
#     ʤ
# 
#     
# 
#
sub _init {
    my $self = shift;
#    my $ctbl = shift;

#    # ʲ˽
    $self->SUPER::_init();

    # ѿ'Species', 'InGroup', 'OutGroup'¸ߤ硢
    # 󤹤롣
    if(exists $self->{'Species'} || 
       exists $self->{'InGroup'} || 
       exists $self->{'OutGroup'}) {
	$self->sortSpecies();
#	my $odr = $self->getSpeciesOrder();
#
#	# In Group, Out Group ʪν󤹤롣
#	$self->setSpecies(sort {$odr->{$a} <=> $odr->{$b}} $self->getSpecies());
#	$self->setInGroup(sort {$odr->{$a} <=> $odr->{$b}} $self->getInGroup());
#	$self->setOutGroup(sort {$odr->{$a} <=> $odr->{$b}} $self->getOutGroup());
    }

    #
    $self->{'LIST_FUNC_DB'} = [ 'mbgd', 'cog', 'kegg', 'tigr' ];
    my($dir) = "$ENV{'MBGD_HOME'}/database/function";
    my($orig) = 1;
    foreach my$dbname (@{$self->{'LIST_FUNC_DB'}}) {
        $self->{'FUNC_DB'}->{"$dbname"} = MBGD::FunctionCategory->new($dbname, $dir, $orig);
    }

    return;
}

###############################################################################
# ̾
#     DESTROY()
# 
#     ǥȥ饯
# 
#     $self : 󥹥󥹤Υե
# 
#     ʤ
# 
#
# 
#     ̾ѿλѤեϥɥλѤξϥǥȥ饯Ѱ
#     ʤƤŬڤ˴롣
#     եʤɤ롣
#
#sub DESTROY {
#    my $self = shift;
#
#    # ȤΥ饹˴³
#    # ѡ饹Υ󥹥ѿѤƤʤϡ
#    # ѡ饹 DESTROY() ƤӽФθǤ褤
#
#    # ǥȥ饯Ͽƥ饹ʤƤ줿褤
#    $self->SUPER::DESTROY;
#}

###############################################################################
# ̾
#     write()
# 
#     饹ơ֥Ƥե˽Ϥ롣
# 
#     $self : 󥹥󥹤Υե
#     %args : ˼ϥå
#         'file'  => ե̾      : ϥե̾(άSTDOUT)
#         'format'=> ϥեޥå: text ⤷ html(άhtml)
#         'type'  => ϥǡ: complete, phylopat, count(άcomplete)
#                                      complete : Ƥΰ̾ɽ
#                                      phylopat : Ҥ̵ͭ1/0ɽ
#                                      count    : ҿɽ
#    	  'clusterID' => 饹ID
# 
#     ʤ
# 
#     MBGD::ClusterTable::WriterΥ󥹥󥹤ѿ'Table'Ƥ
#     Ϥ롣
#     MBGD::ClusterTable::WriterΥ󥹥󥹤ϡܥ᥽åɤ¹ԤƤ֤
#     ͭȤ롣
#     եޥåȤѹٽϤ뤳ȤꤷƤ
# 
#     
sub write {
    my $self = shift;
	my $db = shift;
    my %args = @_;

    my $wh = new RECOG::MBGD::ClusterTable::Writer('file'   => $args{'file'},
					    'format' => (defined $args{'format'} ? $args{'format'}
							                         : 'html'));
    if(exists $args{'clusterID'}) {

		if($args{'format'} eq 'text') {
			$wh->write(
				   $db,
				   $self->{'Table'},
				   $self->{'InGroup'},
				   $self->{'OutGroup'},
				   (defined $args{'type'} ? $args{'type'} : 'complete'),
				   $args{'clusterID'});
		} else {
			$wh->write(
					   $db,
					   $self->{'InGroup'},
					   $self->{'OutGroup'},
					   (defined $args{'type'} ? $args{'type'} : 'complete'),
					   $args{'clusterID'});
		}
    } else {
		die "cluster Table ID was undefined.";
    }
}

###############################################################################
# ̾
#     sortSpecies
# 
#     ѿ Species, InGroup, OutGroup ݻʪ̾ΥꥹȤ
#     MBGDƤ˥Ȥ롣
# 
#     $self : 󥹥󥹤Υե
# 
#     ʤ
# 
#
# 
#
sub sortSpecies {
    my $self = shift;

    my $odr = $self->getSpeciesOrder();

    # In Group, Out Group ʪν󤹤롣
    $self->setSpecies(sort {$odr->{$a} <=> $odr->{$b}} $self->getSpecies());
    $self->setInGroup(sort {$odr->{$a} <=> $odr->{$b}} $self->getInGroup());
    $self->setOutGroup(sort {$odr->{$a} <=> $odr->{$b}} $self->getOutGroup());
}

###############################################################################
# ̾
#     getSpeciesOrder
# 
#     ʪ̾ɽֹݻϥå롣
# 
#     $self : 󥹥󥹤Υե
# 
#     ʪ̾(ά)򥭡ֹͤȤƻĥϥåΥե󥹡
# 
#
# 
#
sub getSpeciesOrder {
    my $self = shift;

    my $hash = {};
    my $no   = 1;

    my @out;
    my $tax = MBGD::Taxonomy->new();
    $tax->print_tab(\@out);
    foreach my $sps (@out) {
	$sps =~ s/[\r\n]*$//;
	my ($lev, $specname, $list, $rank, $div, $status, $url) = split(/\t/, $sps);

	$hash->{$list} = $no++     if ($rank =~ /^genome/i);
	##print STDERR $list, "\n" if ($rank =~ /^genome/i);
    }

    return $hash;
}

###############################################################################
#
sub addCoutupRes {
    my($self) = shift;
    my($gall) = shift;
    my($gsub) = shift;

    # GENE
    my($t) = 'GENE';
    foreach my$key (keys(%{$gsub->{"$t"}})) {
        $gall->{"$t"}->{"$key"} += $gsub->{"$t"}->{"$key"};
    }

    # PRODUCT
    my($t) = 'PRODUCT';
    foreach my$key (keys(%{$gsub->{"$t"}})) {
        $gall->{"$t"}->{"$key"} += $gsub->{"$t"}->{"$key"};
    }

    # FUNCTION
    my($t) = 'FUNCTION';
    foreach my$db (keys(%{$gsub->{"$t"}})) {
        foreach my$key (keys(%{$gsub->{"$t"}->{"$db"}})) {
            $gall->{"$t"}->{"$db"}->{"$key"} += $gsub->{"$t"}->{"$db"}->{"$key"};
        }
    }

    return $gall
}

###############################################################################
#
sub countupGeneFuncDesc {
    my($self) = shift;
    my($ginfo) = shift;

    #
    my($countup_ref) = {};

#    # 饹ե뤬Ĥʤerr80
#    # ǽƥ꤬Ҥͥ褵Τǡ80ʾΤΤϵǽƥ̵ΤȤ롣
#    foreach my$fdbname (@{$self->{'LIST_FUNC_DB'}}) {
#        $countup_ref->{''}{'err'}{$fdbname}{"80"} = 1;
#    }

    #
    foreach my $e (@$ginfo) {
        # ̤̾˽и򥫥Ȥ
        my $gname = $e->{'gene'};
        if ($gname !~ /^\s*$/) {
            $countup_ref->{'GENE'}->{"$gname"}++;
        }

        # ץ̾ORF̤̾¸
        my $product = $e->{'descr'};
        if($product !~ /^\s*$/) {
            $countup_ref->{'PRODUCT'}->{"$product"}++;
        }

        # ǽƥORF̤̾¸
        foreach my$fdbname (@{$self->{'LIST_FUNC_DB'}}) {
            my($func_ref) = $e->{'function'}->{"$fdbname"};
            if ($func_ref->{'LEVEL'} ne '') {
                my($funcNum) = $func_ref->{'LEVEL'};
                if($func_ref->{'NAME'}) {
                    $countup_ref->{$gname}{'func'}{$fdbname}{$funcNum}++;
                    if(length {$e->{'descr'}} > 0) {
                        $countup_ref->{'FUNCTION'}->{"$fdbname"}->{"$funcNum"}++;
                    }
                }
            }
            else {
                my $funcNum = 90; # ǽ̤
            }
        }
    }

    return $countup_ref;
}

###############################################################################
#
sub get_function_db {
    my($self) = shift;
    my($func_db_name) = shift;

    return $self->{'FUNC_DB'}->{"$func_db_name"};
}

###############################################################################
#
sub getFunctionCategory {
    my($self) = shift;
    my($func_db_name) = shift;
    my($sporf) = shift;

    #
    my($fdb) = $self->get_function_db($func_db_name);
    my($refFuncList) = $fdb->getFunctionListBySporf($sporf);
    my($refFunc) = $refFuncList->[0];

    return $refFunc;
}

###############################################################################
#
# addGeneInfoFuncοĽtmpե˽ϤС
#
sub addGeneInfoFuncLog {
	my $self    = shift;
	my $file    = shift;
	my $dbname  = shift;      # ǡ١̾

    #
    my($fh_progress);
    if (defined($file)) {
        $fh_progress = FileHandle->new(">>$file");
    }
    if (!defined($fh_progress)) {
        # $file  open ʤ
        # progress Ϥʤ
        $fh_progress = FileHandle->new(">/dev/null");
    }
    $fh_progress->autoflush(1);

    #
	$dbname = $main::DBNAME_FUNC unless(defined $dbname);

	# å夬̵ɤǧ롣
	# СνϹԤʤʤ
	# 'Table'(饹ơ֥)˴ޤޤ饹оݤȤ롣

	# Ľե˿ĽϤ롣
	my $counter=0;
	$fh_progress->print("create_result_table $counter\n");

    # ̤ descr 
    my($constit_all) = ConsenseTitle->new($main::FILE_consense_title);
    my($constit_sub) = ConsenseTitle->new($main::FILE_consense_title);

    #
	my $table = $self->{'Table'};
	foreach my $clst (values %$table) {
       	my $gall = {};               # 饹ñ̤ΰҾ

        # 饹˴ޤޤ ORF ξ
        my($cluster_gene_ref) = $self->getClusterGeneInfo($dbname, $clst);

       	# ֥饹˰̾ǽƥξ
        $constit_all->clear();
       	foreach my $subc (values %{$clst->{'subcluster'}}) {
            $constit_sub->clear();

			# ֥饹ORF̾
			my @orfs = ();
			foreach my $sp (keys %{$subc->{'ingroup'}}) {
                my(@orfs_sp) = keys %{$subc->{'ingroup'}{$sp}};
				push(@orfs, @orfs_sp);
			}

			# ORF̾ΥꥹȤбҾ
#			my $ginfo = $self->getGeneInfo($dbname, @orfs);
            my $ginfo = [];
            foreach my$orf (@orfs) {
                my($orf_nodom) = $orf;
                $orf_nodom =~ s#\(\d+\)$##;
                my($gene_ref) = $cluster_gene_ref->{"$orf_nodom"};
                push(@{$ginfo}, $gene_ref);

                # 饹 title
                $constit_all->set_title($gene_ref->{'descr'});

                # ֥饹 title
                $constit_sub->set_title($gene_ref->{'descr'});
            }

			# ҾˤĤơ̾ȵǽƥ̾
			# и٤򥫥Ȥ롣
            my($gsub) = $self->countupGeneFuncDesc($ginfo);

            # 饹ΤΥ
            $self->addCoutupRes($gall, $gsub);

			# Ǥͥ٤ι⤤̾ǽƥ̾
			my($genename, $product, @genefunc) = $self->getGeneInfoTopPri($gsub);

            #
            my($cons_tit, $cons_tit_orig, $cons_tit_score) = $constit_sub->consense_title();

			# äȤͥ٤⤤Τǡǽƥ̵꤬äΤˤĤƤ90줹롣
            my($gf_idx) = 0;
            foreach my$fdbname (@{$self->{'LIST_FUNC_DB'}}) {
                my($gf) = $genefunc[$gf_idx];
                if(!$gf) {
                    $gf = 90;
                    my $er = "";
                    foreach my $k (keys %{$gsub->{$genename}{'err'}{"$fdbname"}}) {
                        if(length($er) < 1) {
                            $er = $k;
                        }
                        else {
                            $er .= " ". $k;
                        }
                    }
                    $subc->{'err'} = $er; # 90errϿ
                }
                $gf_idx++;
             }

             # 򥵥֥饹ɲä
             $subc->{'genename'}  = $genename;
             $subc->{'product'}   = $product;
             $subc->{'descr'}     = $cons_tit;
             $subc->{'func_mbgd'} = $genefunc[0];
             $subc->{'func_cog'}  = $genefunc[1];
             $subc->{'func_kegg'} = $genefunc[2];
             $subc->{'func_tigr'} = $genefunc[3];
        }

        # ˤĤƤƱͤ˰̾ǽƥ̾
        my @orfs = ();
        foreach my$sp (keys(%{$clst->{'outgroup'}})) {
            push(@orfs, keys %{$clst->{'outgroup'}->{$sp}});
        }
#        my $ginfo = $self->getGeneInfo($dbname, @orfs);
        my($ginfo) = [];
        foreach my$orf (@orfs) {
            my($gene_ref) = $cluster_gene_ref->{"$orf"};
            push(@{$ginfo}, $gene_ref);

            # 饹 title
            $constit_all->set_title($gene_ref->{'descr'});
        }

        my($gsub) = $self->countupGeneFuncDesc($ginfo);
        $self->addCoutupRes($gall, $gsub);

        # ʻ饹ɽ롢̾ǽƥ̾
        my($genename, $product, @genefunc) = $self->getGeneInfoTopPri($gall);

        #
        my($cons_tit, $cons_tit_orig, $cons_tit_score) = $constit_sub->consense_title();

        # äȤͥ٤⤤Τǡǽƥ̵꤬äΤˤĤƤ90줹롣
        my($gf_idx) = 0;
        foreach my$fdbname (@{$self->{'LIST_FUNC_DB'}}) {
            my($gf) = $genefunc[$gf_idx];
            if(!$gf) {
                $genefunc[$gf_idx] = 90;
                my $er = "";
                foreach my $k (keys %{$gall->{$genename}{'err'}{"$fdbname"}}) {
                    if(length($er) < 1) {
                        $er = $k;
                    }
                    else {
                        $er .= " ". $k;
                    }
                }
                $clst->{'err'} = $er; # 90errϿ
            }

            $gf_idx++;
        }
        
		$clst->{'genename'}  = $genename;
		$clst->{'product'}   = $product;
		$clst->{'descr'}     = $cons_tit;
		$clst->{'func_mbgd'} = $genefunc[0];
		$clst->{'func_cog'}  = $genefunc[1];
		$clst->{'func_kegg'} = $genefunc[2];
		$clst->{'func_tigr'} = $genefunc[3];

		$counter++;
		my $dis = $counter % $main::PROGRESS_CREATE_TABLE;
		if($dis == 0) {
    	    $fh_progress->print("create_result_table $counter\n");
		}
	}

    $fh_progress->print("Done\n");
    $fh_progress->close();

    return;
}

###############################################################################
# ̾
#     getGeneInfo
# 
#     ꤵ줿ǡ١̾ǽƥ̾롣
# 
#     $self   : 󥹥󥹤Υե
#     $dbname : ǡ١̾
#     @orfs   : ORF̾Υꥹ
# 
#     ϥåΥե(Ҿޤ)Υꥹ
#     ϥåϼΤ褦ͤݻ롣
#     )
#     []  []
#     aalen          21
#     aaseq          167064
#     chrid          455
#     db             MBGD::DB=HASH(0x6000000000007160)
#     descr          thr operon leader peptide
#     dir            1
#     from1          190
#     funccat        1
#     gene           thrL
#     gi             1786182
#     id             337876
#     name           B0001
#     ntseq          174682
#     protid         AAC73112.1
#     schema         MBGD::Schema=HASH(0x600000000058d350)
#     sp             eco
#     to1            255
#     type           CDS
#     udate          2006-02-28 08:15:49
#     function       { "$dbname" => $self->getFunctionCategory($dbname, $orf) }
#     function_no    1.4.2
## ()    function_class Small-Molecule Metabolism ; Amino acid biosynthesis
# 
#     
# 
#
my($CACHE_gene) = {};
sub getGeneInfo {
    my $self   = shift;
    my $dbname = shift;  # 
    my @orfs = @_;     # ORFꥹ
    my $info = [];

    # Ķѿ MYSQL_DB ̤ξ硢MBGD ǥեȤ DB ³롣
    unless(defined $self->{'DBH'}) {
        $self->{'DBH'} = MBGD::DB->new($ENV{'MYSQL_DB'});
    }
    my $db = $self->{'DBH'};
    
    # MBGDORF̾бҾ
    my(@new_orfs);
    foreach my$o (@orfs) {
        $o =~ s#\(\d+\)##;
        push(@new_orfs, $o);
    }
    my(@listGeneInfo);
    my($sql) = "select * from gene where sp=?";
    my($sth) = $db->prepare($sql);
    foreach my$orf (@new_orfs) {
        my($sp, $name) = split(':', $orf);
        if (!exists($CACHE_gene->{"$sp"})) {

            $sth->execute($sp);
            while (my$ref = $sth->fetchrow_hashref()) {
                my($n) = $ref->{'name'};
                $CACHE_gene->{"$sp"}->{"$n"} = $ref;
            }
        }
        push(@listGeneInfo, $CACHE_gene->{"$sp"}->{"$name"});
    }

    # ưҾ˵ǽֹ桢ǽƥ̾ɲä롣
    foreach my $e (@listGeneInfo) {
        my $sp  = $e->{'sp'};
        my $orf = join(":", $e->{'sp'}, $e->{'name'});

        $e->{'spname'} = $orf;
#        $e->{'function_no'}     = MBGD::FuncCat::get_func_category($orf);
        foreach my$dbname (@{$self->{'LIST_FUNC_DB'}}) {
            $e->{'function'}->{"$dbname"} = $self->getFunctionCategory($dbname, $orf);
        }

        push(@$info, $e);
    }

    # (ꥹȤΥե)֤
    $info;
}

###############################################################################
#
sub getClusterGeneInfo {
    my $self   = shift;
    my $dbname = shift;  # 
    my $clst = shift;
    my $cluster_gene_ref = {};

    my(@orf_all);
    foreach my $subc (values %{$clst->{'subcluster'}}) {
        foreach my $sp (keys %{$subc->{'ingroup'}}) {
            my(@orfs_sp) = keys %{$subc->{'ingroup'}{$sp}};
            push(@orf_all, @orfs_sp);
        }
    }

    foreach my$sp (keys(%{$clst->{'outgroup'}})) {
        push(@orf_all, keys %{$clst->{'outgroup'}->{$sp}});
    }

    #
    my($ginfo) = $self->getGeneInfo($dbname, @orf_all);

    #
    foreach my$ref (@{$ginfo}) {
        my($spname) = $ref->{'spname'};
        $cluster_gene_ref->{"$spname"} = $ref;
    }

    return $cluster_gene_ref;
}

###############################################################################
# ̾
#     getGeneInfoTopPri
# 
#     MBGD̾ǽƥ̾ǺǤɽͥ٤⤤Τ
#     򤷡֤
# 
#     $ghash : и٤Υͤޤϥå
#     $ghash 
#       $ghash->{'GENE'}->{"$gene"}
#       $ghash->{'PRODUCT'}->{"$descr"}
#       $ghash->{'FUNCTION'}->{"$fdbname"}->{"$fid"}
#
# 
#     Ǥޤꥹ
#     1)ɽ̾
#     2)ɽҤбץ
#     3)ɽҤб뵡ǽƥ̾
# 
#     
# 
#
sub getGeneInfoTopPri {
    my $self = shift;
    my $ghash = shift;

    ##############
    # ɽ̾
    # 1. ̾νи()
    # 2. ̾ե٥åȽ
    my $evfg = sub {
        ($ghash->{'GENE'}->{"$b"} <=> $ghash->{'GENE'}->{"$a"})
            ||
        $a cmp $b
    };
    my($gname) = sort $evfg grep(!/^\s*$/, keys(%{$ghash->{'GENE'}}));

    ##################
    # ɽץ̾
    my $evfp = sub {
        ($ghash->{'PRODUCT'}->{"$b"} <=> $ghash->{'PRODUCT'}->{"$a"})
            ||
        $a cmp $b
    };
    my($product) = sort $evfp grep(!/^\s*$/, keys(%{$ghash->{'PRODUCT'}}));

    ###############
    # ɽ function
    my(@func) = (90, 90, 90, 90);  # ɽҤεǽƥ(mbgd/cog/kegg/tigr)
    my($fdb_idx) = 0;
    foreach my$fdbname (@{$self->{'LIST_FUNC_DB'}}) {
        my $evff = sub {
            $ghash->{'FUNCTION'}->{"$fdbname"}->{"$b"} <=> $ghash->{'FUNCTION'}->{"$fdbname"}->{"$a"}
                ||
            $b <=> $a
        };

        my($f) = sort $evff grep(!/^\s*$/, keys(%{$ghash->{'FUNCTION'}->{"$fdbname"}}));
        if ($f ne '') {
            $func[$fdb_idx] = $f;
        }

        $fdb_idx++;
    }

    return ($gname, $product, @func);
}

###############################################################################
# ̾
#     dumpDB
# 
#     ܥ饹ΥѿͤMySQLơ֥˽Ϥ롣
#     ϤˤCache::mysql饹εǽѤ롣
#     ѿ'DumpMember'˻ꤵƤѿоݤȤʤ롣
# 
#     $self  : 󥹥󥹤Υե
#     $cache : Cache::mysqlΥ󥹥
# 
#     ʤ
# 
#     ѿȤͤmysqlơ֥˽Ϥ롣
#     ͤPerl̵̾ϥåεˡϤΤǡevalˤǥɲǽʷ
#     Ǥ롣
#     ѿ'Table'ˤĤƤϡѿ̾饹IDͤΣܤϡ
#     ¾ѿˤĤƤϡѿͤΤߤϤ롣
# 
# 
sub dumpDB {
    my $self  = shift;
    my $cache = shift;


    foreach my $name (@{$self->{'DumpMember'}}) {
	# Tableξ硢ѿ̾饹ID饹Σܤ򥿥ֶڤǽ
	if($name eq 'Table') {
	    foreach my $id (sort {$a <=> $b} keys %{$self->{$name}}) {
#		printf($fh "%s\t%s\t%s\n",
#		       $name,
#		       $id,
#		       refSerialize($self->{$name}{$id}));
		$cache->write(refSerialize($self->{$name}{$id}),
			      $name,
			      $id);
	    }
	}
	# Tableʳϡѿ̾(󥳡ɤʸ)򥿥ֶڤǽ
	else {
	    # 裲եɤ϶Ȥޤ
#	    printf($fh "%s\t\t%s\n",
#		   $name,
#		   refSerialize($self->{$name}));
	    $cache->write(refSerialize($self->{$name}),
			  $name);
	}
    }
}

###############################################################################
# ̾
#     loadDB
# 
#     dump()᥽åɤǽϤơ֥뤫ǡɤ߹ߡѿȤ
#     롣
# 
#     $self  : 󥹥󥹤Υե
#     $cache : Cache::mysqlΥ󥹥
# 
#     ʤ
# 
#     ѿ̾Ȥͤ򤽤줾Фͤǥɤƥѿ
#     åȤ롣
#     ѿ'Table'ˤĤƤ㳰Ūˡѿ饹IDͤΣ
#     ꡢ$self->{'Table'}->{饹ID} = ǥɤ Ȥ
#     롣
# 
# 
sub loadDB {
    my $self  = shift;
    my $cache = shift;

    # Ԥĥե뤫쥳ɤɤ
    while(my($type, $id, $value) = $cache->getline()) {
	# Ƭɤ"Table"ʤ顢饹ID(饹)Ф
	# ǥɤͤԤ
	if($type eq 'Table') {
	    $self->{$type}{$id} = eval($value);
	}
	# ¾ξ硢ѿ̾ͤѤơ
	# ͤΥǥɤѿؤΥåȤԤ
	else {
	    $self->{$type} = eval($value);
	}
    }
}

##############################################################################
1; #
##############################################################################
__END__


##############################################################################
Gene 

use MBGD;

# Ķѿ MYSQL_DB ̤ξ硢MBGD ǥեȤ DB ³롣
my $db = MBGD::DB->new($ENV{'MYSQL_DB'});

my @listGeneInfo = MBGD::Gene->get($db, [@ARGV]);
foreach $geneInfo (@listGeneInfo) {
    print STDERR '#' x 60, "\n";
    foreach $key (sort(keys(%{$geneInfo}))) {
        print STDERR $key, "\t", $geneInfo->{$key}, "\n";
    }
}

¹

% ./geneInfo.pl eco:B0001
############################################################
aalen   21
aaseq   167064
chrid   455
db      MBGD::DB=HASH(0x6000000000007160)
descr   thr operon leader peptide
dir     1
from1   190
funccat 1
gene    thrL
gi      1786182
id      337876
name    B0001
ntseq   174682
protid  AAC73112.1
schema  MBGD::Schema=HASH(0x600000000058d350)
sp      eco
to1     255
type    CDS
udate   2006-02-28 08:15:49

Function Category

use MBGD;
use MBGD::FuncCat;

foreach $orf (@ARGV) {
    my ($sp, $name) = split(':', $orf);
    $funcNum = MBGD::FuncCat::get_func_category($orf);
    $func    = MBGD::FuncCat::get_class_info($sp, $funcNum);

    print STDERR '#' x 60, "\n";
    print STDERR $funcNum, "\n";
    print STDERR $func,    "\n";
}

¹

% ./getFunctionCategory.pl eco:B0001
############################################################
1.4.2
Small-Molecule Metabolism ; Amino acid biosynthesis ; Aspartate family
%

##############################################################################
