#!/usr/bin/perl -s
package RECOG::MBGD::ClusterTable::Writer;
###############################################################################
# ̾
#     MBGD::ClusterTable::Writer
# 
#     MBGD::ClusterTableݻǡɽƽϤ롣
#     ClusterTable饹󤹤륯饹ΣĤȤƵǽ롣
# 
#     ܥ⥸塼ɽǽϤ륯饹δ쥯饹Ǥꡢϥեޥå
#     (html, text)˱ơ֥饹Υ󥹥󥹤롣
# ѿ
#     'FileHandle'  : ϥեϥɥ
# ᥽åɰ
#     new()
#     DESTROY()
#     close()
# 
#
###############################################################################
use FileHandle;

###############################################################################
# ̾
#     new()
# 
#     󥹥ȥ饯
# 
#     $that  : 饹̾(⤷ϥ󥹥󥹤Υե)
#     %args  : 򥻥åȤϥå
#       $args{format} : ϥեޥå(html or text)
#       $args{file}   : ϥե̾(ǥեȡɸ)
# 
#     󥹥󥹤ؤΥե
# 
#
# 
#
sub new {
    my $that = shift;
    my %args = @_;

    # $that ե󥹤ʤ顢ѥå̾롣
    my $class = ref($that) || $that;

    # Ϸ˱ơ륵֥饹򤹤롣
    my $pm = sprintf("%s::", __PACKAGE__);
    $pm .= $args{'format'};
    eval "require $pm";
    my $self = $pm->new(%args);

    # ϥե뤬ꤵƤФ򥪡ץ󤹤롣
    # ꤵƤʤ硢ɸϤȤ롣
    my $outf = (defined $args{'file'} ? "> $args{'file'}" : ">-");
    my $fh = new FileHandle($outf) || die "open failure($!) : $args{'file'}\n";
    $self->{'FileHandle'} = $fh;

    return $self;
}

###############################################################################
# ̾
#     DESTROY()
# 
#     ǥȥ饯
# 
#     $self : 󥹥󥹤Υե
# 
#     ʤ
# 
#
# 
#     ̾ѿλѤեϥɥλѤξϥǥȥ饯Ѱ
#     ʤƤŬڤ˴롣
#     եʤɤ롣
#
#sub DESTROY {
#    my $self = shift;
#
#    # ȤΥ饹˴³
#    # ѡ饹Υ󥹥ѿѤƤʤϡ
#    # ѡ饹 DESTROY() ƤӽФθǤ褤
#
#    # ǥȥ饯Ͽƥ饹ʤƤ줿褤
#    $self->SUPER::DESTROY;
#}

###############################################################################
# ̾
#     close()
# 
#     ϥե򥯥롣
# 
#     ʤ
# 
#     ʤ
# 
#
# 
#
sub close {
    my $self = shift;
    my $fh = $self->{'FileHandle'};
    $fh->close;
}


###############################################################################
# ̾
#     transform()
# 
#     ORFꥹȤɽˡѹ
# 
#     $self    : 󥹥󥹤Υե
#     $type    : ϥסcomplete, phylopat, countΤ줫
#     @orfs    : ORFΥꥹ
# 
#     ʤ
# 
#
# 
#
sub transform {
    my $self   = shift;
    my $type = shift;
    my @orfs   = @_;

    if($type eq 'complete') {
		map { s/^[^:]+:// } @orfs;  # ORF̾Ƭʪ̾
		@orfs;
    }
    elsif($type eq 'count') {
		scalar(@orfs);
    }
#    elsif($type eq 'phylopat') {
    else {
		(scalar(@orfs) ? 1 : 0);
    }
}

sub transform_sort {
	my $self = shift;
	my $data = shift;

	my $sortlist = {};
	foreach my $d (@$data) {
		if($d =~ /^([^:]+):\S+/) {
			$sortlist->{$1}->{$d}++;
		}
		else {
			next;
		}
	}

	return $sortlist;

}

##############################################################################
1; #
##############################################################################
