#!/usr/bin/perl -s
package RECOG::ClusterTable;
###############################################################################
# ̾
#     ClusterTable.pm
# 
#     饹󥰷̤ɽǴ롣
# 
#     饹֥饹γؤǥǡ֥ͭ饹Ϥingroup,
#     outgroupʬ䤵롣줾ʪ˳̾ݻ롣
#     ʲˤΥǡ¤򼨤
#     $self->{'Table'} = {
#          '饹ֹ' => {
#               'id'   => 饹ֹ,
#               'subcluster => {
#                   '֥饹ֹ' => {
#                       'subid' => ֥饹ֹ, 
#                       'ingroup' => {
#                           'ʪ̾' => {
#                               'ORF̾' => {
#                                   'gene' => ORF̾,
#                                   'from' => ϰ,
#                                   'to'   => λ,
#                               },
#                           },
#                           Ʊ, ...
#                       },
#                   },
#                   Ʊ, ...
#               },
#               'outgroup' => {
#                   'ʪ̾' => {
#                       'ORF̾' => {
#                           'gene' => ORF̾,
#                           'from' => ϰ,
#                           'to'   => λ,
#                       },
#                   },
#                   Ʊ, ...
#               },
#          },
#          Ʊ, ...
#     };
# ѥåѿ
#     
# Сѿ
#     'Table'           : 饹ơ֥뤽ΤΤݻ
#     'Species'         : 饹˴ޤޤʪ̾(ά)ݻ
#     'InGroup'         : ingroup˴ޤޤʪ̾(ά)ݻ
#     'OutGroup'        : outgroup˴ޤޤʪ̾(ά)ݻ
#     'DumpMember'      : dump()᥽åɤǽϤѿΥꥹ
###     'NumberOfCluster' : 饹ơ֥˴ޤޤ饹ݻ
#     
# ᥽åɰ
#     new()
#     _init()
#     setClusterTable()
#     setSpecies()
#     setInGroup()
#     setOutGroup()
#     addCluster()
#     getClusterID()
#     getMaxClusterID()
#     getCluster()
#     getNumberOfCluster()
#     getSpecies()
#     getInGroup()
#     getOutGroup()
#     selectCluster()
#     selectClusterByID()
#     selectClusterBySize()
#     selectClusterByPattern()
#     dump()
#     load()
# 
#
###############################################################################
use strict;
#our(@ISA);                                   # require 5.6.0;
use FileHandle;
##use ClusterTable::Writer;
# ѥåѿ

###############################################################################
# ̾
#     new()
# 
#     󥹥ȥ饯
# 
#     $that  : 饹̾(⤷ϥ󥹥󥹤Υե)
#     @args  : domclustưץ(᥽åsetOption()򻲾)
# 
#     󥹥󥹤ؤΥե
# 
#
# 
#
sub new {
    my $that = shift;
    my @args = @_;
    my $self = {};

    # $that ե󥹤ʤ顢ѥå̾롣
    my $class = ref($that) || $that;

    bless($self, $class);
    $self->_init(@args);

    return $self;
}

###############################################################################
# ̾
#     _init()
# 
#     
# 
#     $self  : 󥹥󥹤ؤΥե
# 
#     ʤ
# 
#     ưѥ᡼Υǥեͤѿ¸롣
# 
#
sub _init {
    my $self  = shift;

#    # ʲ˽
#    $self->SUPER::_init(%param);

    # dump()᥽åɤǽоݤȤѿꤹ롣
    $self->{'DumpMember'} = ['Species', 'InGroup', 'OutGroup', 'Table'];

}

###############################################################################
# ̾
#     DESTROY()
# 
#     ǥȥ饯
# 
#     $self : 󥹥󥹤Υե
# 
#     ʤ
# 
#
# 
#     ̾ѿλѤեϥɥλѤξϥǥȥ饯Ѱ
#     ʤƤŬڤ˴롣
#     եʤɤ롣
#
#sub DESTROY {
#    my $self = shift;
#
#    # ȤΥ饹˴³
#    # ѡ饹Υ󥹥ѿѤƤʤϡ
#    # ѡ饹 DESTROY() ƤӽФθǤ褤
#
#    # ǥȥ饯Ͽƥ饹ʤƤ줿褤
#    $self->SUPER::DESTROY;
#}

###############################################################################
# ̾
#     setClusterTable()
# 
#     饹ơ֥ѿ˥åȤ롣
# 
#     $self  : 󥹥󥹤Υե
#     $table : 饹ơ֥(ϥå)ؤΥե
# 
#     ʤ
# 
#     饹ơ֥(Ƭ˵¤Υϥå)ؤΥե󥹤
#     ѿ'Table'ꤹ롣
# 
#     
sub setClusterTable {
    my $self  = shift;
    my $table = shift;

    if(ref $table eq 'HASH') {
	$self->{'Table'} = $table;
    }
    else {
	printf(STDERR "***** ERROR[%s] : cluster table invalid reference type [%s] *****\n",
	       __PACKAGE__, ref $table);
	die;
    }
}

###############################################################################
# ̾
#     setSpecies()
# 
#     ʪ̾ΥꥹȤѿ˥åȤ롣
# 
#     $self   : 󥹥󥹤Υե
#     @splist : ʪ̾Υꥹ
# 
#     ʤ
# 
#     ѿ'Species'ꤹ롣
# 
#     
sub setSpecies {
    my $self  = shift;
    my @splist = @_;

    $self->{'Species'} = \@splist;
}

###############################################################################
# ̾
#     setInGroup()
# 
#     In Group ˳ʪ̾ΥꥹȤѿ˥åȤ롣
# 
#     $self : 󥹥󥹤Υե
#     @igrp : In Group ˳ʪ̾Υꥹ
# 
#     ʤ
# 
#     ѿ'InGroup'ꤹ롣
# 
#     
sub setInGroup {
    my $self  = shift;
    my @igrp = @_;

    $self->{'InGroup'} = \@igrp;
}

###############################################################################
# ̾
#     setOutGroup()
# 
#     Out Group ˳ʪ̾ΥꥹȤѿ˥åȤ롣
# 
#     $self : 󥹥󥹤Υե
#     @ogrp : Out Group ˳ʪ̾Υꥹ
# 
#     ʤ
# 
#     ѿ'OutGroup'ꤹ롣
# 
#     
sub setOutGroup {
    my $self  = shift;
    my @ogrp = @_;

    $self->{'OutGroup'} = \@ogrp;
}

###############################################################################
# ̾
#     addCluster()
# 
#     饹ơ֥ˣĤΥ饹(ϥå)ɲä롣
# 
#     $self : 󥹥󥹤Υե
#     $crec : 饹󡧥饹ơ֥(ϥå)
# 
#     ʤ
# 
#     ѿ'Table'ꤹ롣
# 
#     
sub addCluster {
    my $self = shift;

    while(my $crec = shift) {
	my $id = $crec->{'id'};
	if(defined $id) {
	    if(exists $self->{'Table'}{$id}) {
		print(STDERR "# Cluster ID [$id] is already exists. Discards old data.\n");
	    }
	    
	    $self->{'Table'}{$id} = $crec;
	}
    }
}

###############################################################################
# ̾
#     getClusterID()
# 
#     饹ơ֥˴ޤޤƤΥ饹ID롣
# 
#     $self : 󥹥󥹤Υե
# 
#     饹IDΥꥹ
# 
#     饹ơ֥ˤƤΥ饹IDФȺѤߥꥹȤ
#     ֤
# 
#     
sub getClusterID {
    my $self  = shift;

    my $table = $self->{'Table'};
    sort {$a <=> $b} keys %$table;
}

###############################################################################
# ̾
#     getMaxClusterID()
# 
#     饹ơ֥ˤΥ饹ID롣
# 
#     $self : 󥹥󥹤Υե
# 
#     饹IDκ
# 
#     饹ơ֥ˤƤΥ饹IDФȺѤߥꥹȤ
#     ֤
# 
#     
sub getMaxClusterID {
    my $self  = shift;

    my $table = $self->{'Table'};
    my @tmp = sort {$a <=> $b} keys %$table;
    pop @tmp;
}

###############################################################################
# ̾
#     getCluster()
# 
#     饹ơ֥뤫Υ饹Τߤ롣
# 
#     $self : 󥹥󥹤Υե
#     $cid  : 饹ID
# 
#     ʤ
# 
#     ꤵ줿饹򥭡Ȥơ饹ơ֥뤫ͤФ
#     򤽤Τޤ֤
# 
#     
sub getCluster {
    my $self  = shift;
    my $cid   = shift;

    $self->{'Table'}{$cid};
}

###############################################################################
# ̾
#     getNumberOfCluster()
# 
#     饹ơ֥˴ޤޤ륯饹֤
# 
#     $self : 󥹥󥹤Υե
# 
#     饹ơ֥˴ޤޤ륯饹
# 
#     
# 
#     
sub getNumberOfCluster {
    my $self  = shift;

    scalar(keys %{$self->{'Table'}});
}

###############################################################################
# ̾
#     getSpecies()
# 
#     ʪ̾ΥꥹȤ֤
# 
#     $self : 󥹥󥹤Υե
# 
#     饹˴ޤޤʪ̾ƤΥꥹ
# 
#     ѿ'Species'Ǥ֤
# 
#     
sub getSpecies {
    my $self = shift;
    my @splist;

    @splist = @{$self->{'Species'}} if(defined $self->{'Species'});
    @splist;
}

###############################################################################
# ̾
#     getInGroup()
# 
#     In Group ˳ʪ̾ΥꥹȤ֤
# 
#     $self : 󥹥󥹤Υե
# 
#     In Group ˳ʪ̾Υꥹ
# 
#     ѿ'InGroup'Ǥ֤
# 
#     
sub getInGroup {
    my $self = shift;
    my @igrp;

    @igrp = @{$self->{'InGroup'}} if(defined $self->{'InGroup'});
    @igrp;
}

###############################################################################
# ̾
#     getOutGroup()
# 
#     Out Group ˳ʪ̾ΥꥹȤ֤
# 
#     $self : 󥹥󥹤Υե
# 
#     Out Group ˳ʪ̾Υꥹ
# 
#     ѿ'OutGroup'Ǥ֤
# 
#     
sub getOutGroup {
    my $self = shift;
    my @ogrp;

    @ogrp = @{$self->{'OutGroup'}} if(defined $self->{'OutGroup'});
}

###############################################################################
# ̾
#     selectCluster()
# 
#     ꤵ줿饹Τߤޤơ֥֤
# 
#     $self : 󥹥󥹤Υե
#     %args : ˼ϥå
#         []        : []
#         'start'       : Ф饹IDǺǾID
#         'count'       : Ф饹ID
# 
#     󥹥󥹤Υե
# 
#     
# 
#     
sub selectCluster {
    my $self = shift;
    my %args = @_;

    # ˰פ륯饹ͭ륤󥹥󥹤
#    my $pm = ref $self;                    # ֥饹ξθ
#    my $stbl = $pm->new();                 # 
    my $stbl = $self->new();
    $stbl->setSpecies($self->getSpecies());
    $stbl->setInGroup($self->getInGroup());
    $stbl->setOutGroup($self->getOutGroup());

    my $st = $args{'start'};
    my $no = $args{'count'};
    my $max = $self->getMaxClusterID();
    while($no > 0) {
	my $c = $self->getCluster($st);
	if(defined $c) {
	    $stbl->addCluster($c);
	    $no--;
	}
	$st++;
	last if($st > $max);
    }

    $stbl;
}

###############################################################################
# ̾
#     selectClusterByID()
# 
#     ꤵ줿IDΥ饹Τߤޤơ֥֤
# 
#     $self : 󥹥󥹤Υե
#     %args : ˼ϥå
#         'id' => [id-1, id-2, ...]  : Ф饹IDΥꥹ
# 
#     󥹥󥹤Υե
# 
#     
# 
#     
sub selectClusterByID {
    my $self = shift;
    my %args = @_;

    # ˰פ륯饹ͭ륤󥹥󥹤
#    my $pm = ref $self;                    # ֥饹ξθ
#    my $stbl = $pm->new();                 # 
    my $stbl = $self->new();
    $stbl->setSpecies($self->getSpecies());
    $stbl->setInGroup($self->getInGroup());
    $stbl->setOutGroup($self->getOutGroup());

    foreach my $id (@{$args{'id'}}) {
	$stbl->addCluster($self->getCluster($id));
    }

    $stbl;
}

###############################################################################
# ̾
#     selectClusterBySize()
# 
#     饹Τߤޤơ֥֤
# 
#     $self : 󥹥󥹤Υե
#     %args : ˼ϥå
#         []        : []
#         'species'     : 饹˴ޤޤʪκǾ
#         'orf'         : 饹˴ޤޤʪκǾ
# 
#     󥹥󥹤Υե
# 
#     
# 
#     
sub selectClusterBySize {
    my $self = shift;
    my %args = @_;

    # ǥեͤλ
    $args{'species'} = 0  unless defined($args{'species'});
    $args{'orf'}     = 0  unless defined($args{'orf'});

    # ˰פ륯饹ͭ륤󥹥󥹤
#    my $pm = ref $self;                    # ֥饹ξθ
#    my $stbl = $pm->new();                 # 
    my $stbl = $self->new();
    $stbl->setSpecies($self->getSpecies());
    $stbl->setInGroup($self->getInGroup());
    $stbl->setOutGroup($self->getOutGroup());

    # ꤵ줿ʾʪORF륯饹Τߤ򿷵󥹥󥹤
    # ɲä롣
    foreach my $id ($self->getClusterID()) {
	my $c = $self->getCluster($id);
	if($args{'species'} <= scalar(keys %{$c->{'species'}}) &&
	   $args{'orf'}     <= scalar(keys %{$c->{'orf'}})) {
	    $stbl->addCluster($c);
	}
    }

    $stbl;
}

###############################################################################
# ̾
#     selectClusterByPattern()
# 
#     ʪ¸ߥѥ(Occurence pattern)ˤꥯ饹ʹߡꤵ줿
#     饹Τߤޤơ֥֤
# 
#     $self     : 󥹥󥹤Υե
#     $pattern  : Occurence Pattern (ϥåΥե)
#         []        : []
#         ʪ̾      :  1 = ʪ郎¸ߤ
#                         -1 = ʪ¸ߤʤ
#         () {'hin' => 1, 'mja' => -1, ...}
#     $mismatch : ѥӤλ˵Ƥߥޥå
# 
#     󥹥󥹤Υե
# 
#     
# 
#     
sub selectClusterByPattern {
    my $self     = shift;
    my $pattern  = shift;
    my $mismatch = shift;

    # ˰פ륯饹ͭ륤󥹥󥹤
#    my $pm = ref $self;                    # ֥饹ξθ
#    my $stbl = $pm->new();                 # 
    my $stbl = $self->new();
    $stbl->setSpecies($self->getSpecies());
    $stbl->setInGroup($self->getInGroup());
    $stbl->setOutGroup($self->getOutGroup());

    # ꤵ줿ѥ򥳥ԡ¸ߤ٤ʪ򥫥Ȥ롣
    my %pat = %$pattern;
    my $excount = 0;
##    while(my ($s, $n) = each %pat) {
##	$excount++ if($n == 1);
##    }
    # ɤäȤФǤ礦
    foreach my $s ($self->getSpecies()) {
	$excount++ if($pat{$s} == 1);
    }

    # ꤵ줿ʾʪORF륯饹Τߤ򿷵󥹥󥹤
    # ɲä롣
    foreach my $id ($self->getClusterID()) {
	my $c = $self->getCluster($id);

	# ߥޥå¸ߤ٤ʪ郎饹ˤХǥȤ롣
	#               0 ˤʤСؼ줿ʪƤޥåȤˤʤ롣
	my $mcount = $excount;      # ¸ߤ٤ʪʤΤ¸ߤʤä
	my $ncount = 0;             # ¸ߤƤϤʤʪʤΤ¸ߤ

	# 饹ʪ̾򣱤ĤļФ
	foreach my $sp (keys %{$c->{'species'}}) {
	    # ¸ߤ٤Τʤ顢ߥޥåǥ
	    if($pat{$sp} == 1) {
		$mcount--;
	    }
	    # ¸ߤ٤ǤʤΤʤ顢ߥޥå򥤥󥯥
	    elsif($pat{$sp} == -1) {
##		$mcount++;
		$ncount++;
		last if($ncount > $mismatch); # οߥޥåƿĶ
		                              # ɾ³̣Ϥʤ
	    }
	}

	# ǽŪʥߥޥåʲʤС饹ȽǤ롣
##	if($mcount <= $mismatch) {
	if($mcount + $ncount <= $mismatch) {
	    $stbl->addCluster($c);
	}
    }

    $stbl;
}

################################################################################
## ̾
##     write()
## 
##     饹ơ֥Ƥե˽Ϥ롣
## 
##     $self : 󥹥󥹤Υե
##     %args : ˼ϥå
##         'file'  => ե̾      : ϥե̾(άSTDOUT)
##         'format'=> ϥեޥå: text ⤷ html(άhtml)
##         'type'  => ϥǡ: complete, phylopat, count(άcomplete)
##                                      complete : Ƥΰ̾ɽ
##                                      phylopat : Ҥ̵ͭ1/0ɽ
##                                      count    : ҿɽ
## 
##     ʤ
## 
##     ClusterTable::WriterΥ󥹥󥹤ѿ'Table'Ƥ
##     Ϥ롣
##     ClusterTable::WriterΥ󥹥󥹤ϡܥ᥽åɤ¹ԤƤ֤
##     ͭȤ롣
##     եޥåȤѹٽϤ뤳ȤꤷƤ
## 
##     
#sub write {
#    my $self = shift;
#    my %args = @_;
#
#    my $wh = new RECOG::ClusterTable::Writer('file'   => $args{'file'},
#				      'format' => (defined $args{'format'} ? $args{'format'} : 
#						                             'html'));
#
#    $wh->write($self->{'Table'}, 
#	       $self->{'InGroup'},
#	       $self->{'OutGroup'},
#	       (defined $args{'type'} ? $args{'type'} : 'complete'));
#}

###############################################################################
# ̾
#     setGeneInfo()
# 
#     饹ơ֥˰Ҿɲä롣
# 
#     $self  : 󥹥󥹤Υե
#     $sp    : ʪ̾(ά)
#     $orf   : ORF̾
#     $info  : ϿҾ
#     $cid   : 饹ID
#     $sid   : ֥饹ID$group'ingroup'ξͭ
#     $group : 롼ס'ingroup' ⤷ 'outgroup'
#              
# 
#     ʤ
# 
#     ClusterTable::WriterΥ󥹥󥹤ѿ'Table'Ƥ
#     Ϥ롣
#     ClusterTable::WriterΥ󥹥󥹤ϡܥ᥽åɤ¹ԤƤ֤
#     ͭȤ롣
#     եޥåȤѹٽϤ뤳ȤꤷƤ
# 
#     
sub setGeneInfo {
    my $self  = shift;
    my $sp    = shift;  # Species
    my $orf   = shift;  # orf name
    my $info  = shift;  # {gene => 'name', from => 'start_pos', to => 'end_pos'}
    my $cid   = shift;  # cluster ID.
    my $sid   = shift;  # subcluster ID.  (ingroup nomi yuukou)
    my $group = shift;  # ingroup or outgroup

    # 饹IDΥå
    unless($cid =~ /\S+/) {
	die sprintf("%s : invalid argument [cid=%s]\n", __PACKAGE__, $cid);
    }

    # 
    unless($orf =~ /\S+/) {
	die sprintf("%s : invalid argument [orf=%s]\n", __PACKAGE__, $orf);
    }

    unless(exists $self->{'Table'}{$cid}) {
	$self->{'Table'}{$cid} = {
	    'id'         => $cid,
	    'subcluster' => {},
	    'outgroup'   => {},
	};
    }

    # ingroupoutgroupλ˽äơҾ򥻥åȤ롣
    if($group eq 'ingroup') {
	unless($sid =~ /\S+/) {
	    die sprintf("%s : invalid parameter [sid=%s]\n", __PACKAGE__, $sid);
	}
	unless(exists $self->{'Table'}{$cid}{'subcluster'}{$sid}) {
	    $self->{'Table'}{$cid}{'subcluster'}{$sid} = {
		'subid'   => $sid,
		'ingroup' => {},
	    };
	}
	$self->{'Table'}{$cid}{'subcluster'}{$sid}{$group}{$sp}{$orf} = $info;
    }
    elsif($group eq 'outgroup') {
	$self->{'Table'}{$cid}{$group}{$sp}{$orf} = $info;
    }
    # group̵꤬ʾ硢顼åϤƥץλ롣
    else {
	die sprintf("%s : invalid parameter [group=%s]\n", __PACKAGE__, $group);
    }

    # 饹ʪORF̾¸롣
    $self->{'Table'}{$cid}{'species'}{$sp}++;  # ʪ̾򥭡ORF򥫥
    $self->{'Table'}{$cid}{'orf'}{$orf}++;     # ORF̾򥭡и򥫥
}


#
#
#
sub getGeneNames {
    my $self  = shift;
    my $cid   = shift;  # cluster ID.
    my $sid   = shift;  # subcluster ID.  (ingroup nomi yuukou)
    my $group = shift;  # ingroup or outgroup
    my $sp    = shift;  # Species

    my @list;
    if($group eq 'ingroup') {
	@list = keys %{$self->{'Table'}{$cid}{$sid}{$group}{$sp}};
    }
    elsif($group eq 'outgroup') {
	@list = keys %{$self->{'Table'}{$cid}{$group}{$sp}};
    }
    else {
	die sprintf("%s : invalid parameter [group=%s]\n", __PACKAGE__, $group);
    }

    sort @list;
}

#
#
#
sub getGeneInfo {
    my $self  = shift;
    my $cid   = shift;  # cluster ID.
    my $sid   = shift;  # subcluster ID.  (ingroup nomi yuukou)
    my $group = shift;  # ingroup or outgroup
    my $sp    = shift;  # Species
    my $gene  = shift;  # genename

    my $info;
    if($group eq 'ingroup') {
	$info = $self->{'Table'}{$cid}{$sid}{$group}{$sp}{$gene};
    }
    elsif($group eq 'outgroup') {
	$info = $self->{'Table'}{$cid}{$group}{$sp}{$gene};
    }
    else {
	die sprintf("%s : invalid parameter [group=%s]\n", __PACKAGE__, $group);
    }

    $info;
}

#
#
#
#sub getSpeciesByGroup {
#    my $self  = shift;
#    my $cid   = shift;  # cluster ID.
#    my $sid   = shift;  # subcluster ID.  (ingroup nomi yuukou)
#    my $group = shift;  # ingroup or outgroup
#
#    my @list;
#    if($group eq 'ingroup') {
#	@list = keys %{$self->{'Table'}{$cid}{$sid}{$group}};
#    }
#    elsif($group eq 'outgroup') {
#	@list = keys %{$self->{'Table'}{$cid}{$group}};
#    }
#    else {
#	die sprintf("%s : invalid parameter [group=%s]\n", __PACKAGE__, $group);
#    }
#
#    sort @list;
#}


###############################################################################
# ̾
#     dump
# 
#     ܥ饹Υѿͤե˽Ϥ롣
#     ѿ'DumpMember'˻ꤵƤѿоݤȤʤ롣
# 
#     $self  : 󥹥󥹤Υե
#     $fname : ϥե̾
# 
#     ʤ
# 
#     ѿȤͤ򥿥ֶڤΥƥȤȤƽϤ롣
#     ͤPerl̵̾ϥåεˡϤΤǡevalˤǥɲǽʷ
#     Ǥ롣
#     ѿ'Table'ˤĤƤ㳰Ūˡѿ饹IDͤΣ
#     򥿥ֶڤǽϤ롣
# 
# 
sub dump {
    my $self  = shift;
    my $fname = shift;

    # ϥե򥪡ץ󤹤롣
    my $ostream = (defined $fname ? "> $fname" : ">-");
    my $fh = new FileHandle($ostream) || die "open failure($!) : $fname\n";

    foreach my $name (@{$self->{'DumpMember'}}) {
	# Tableξ硢ѿ̾饹ID饹Σܤ򥿥ֶڤǽ
	if($name eq 'Table') {
	    foreach my $id (sort {$a <=> $b} keys %{$self->{$name}}) {
		printf($fh "%s\t%s\t%s\n",
		       $name,
		       $id,
		       refSerialize($self->{$name}{$id}));
	    }
	}
	# Tableʳϡѿ̾(󥳡ɤʸ)򥿥ֶڤǽ
	else {
	    printf($fh "%s\t%s\n",
		   $name,
		   refSerialize($self->{$name}));
	}
    }

    # ϥե򥯥
    $fh->close;
}

###############################################################################
# ̾
#     load
# 
#     dump()᥽åɤǽϤե뤫ǡɤ߹ߡѿȤ
#     롣
# 
#     $self  : 󥹥󥹤Υե
#     $fname : ϥե̾
# 
#     ʤ
# 
#     ѿȤͤ򤽤줾Фͤǥɤƥѿ˥å
#     롣
#     ѿ'Table'ˤĤƤ㳰Ūˡѿ饹IDͤΣ
#     ꡢ$self->{'Table'}->{饹ID} = ǥɤ Ȥ
#     롣
# 
# 
sub load {
    my $self  = shift;
    my $fname = shift;

    # ϥե򥪡ץ󤹤롣
    my $fh = new FileHandle($fname) || die "open failure($!) : $fname\n";

    # Ԥĥե뤫쥳ɤɤ
    while(my $line = $fh->getline) {
	# Ƭɤ"Table"ʤ顢饹ID(饹)Ф
	# ǥɤͤԤ
	if($line =~ /^Table\s/) {
	    my($k, $i, $v) = split /[\t\r\n]/, $line;
	    $self->{$k}{$i} = eval($v);
	}
	# ¾ξ硢裱եѿ̾裲եɤͤȤ
	# ͤΥǥɤѿؤΥåȤԤ
	else {
	    my($k, $v) = split /[\t\r\n]/, $line;
	    $self->{$k} = eval($v);
	}
    }

    # ϥե򥯥롣
    $fh->close;
}

###############################################################################
# ̾
#     refSerialize
# 
#     ѿͤե˽Ϥ뤿ᡢPerlʸˡ§äʸѴ
#     롣
# 
#     󥳡оݤ(ե)Υꥹ
# 
#     󥳡ɺѤʸ
# 
#     äͤ򣱤ĤɾHASHʤΤARRAYʤΤ顼ʤΤ
#     ȽǤʤ饨󥳡ɤ롣
#     ƵŪ˼ȤƤӽФʤ顢ĤʸؤΥ󥳡ɤ»ܤ롣
# 
# 
sub refSerialize {
    my $str;   # 󥳡ɷʸ
#
#  1. οĴ١ʤʤޤǰʲν򷫤֤
    while(scalar(@_)) {
#     1)򣱤ļФʸ̤ͤǤʤС", "ɲä롣
#       ʸ: ͤȤ֤ʸ -> ѿ $str
	my $var = shift @_;
	$str .= ', ' if(defined($str));
#
#     2)1)ǼФͤꥹȤؤΥե󥹤ʤСե󥹤Ÿ
#       ꥹȤȤܴؿƵŪ˸ƤӽФ
#       η̼äʸ"[", "]"ɲäʸʸ
#       ɲä롣
	# array ref
	if(ref $var eq 'ARRAY') {
	    $str .= '[' . refSerialize(@$var) . ']';
	}
#
#     3)1)ǼФͤϥåؤΥե󥹤ʤСͤ缡
#       Ф"=>"Ƿ礷ʸ롣
#       λϥåͼΤե󥹤ˤʤäƤθơͤ
#       ȤܴؿƵŪ˸ƤӽФͤʸ˥åȤ롣
#       ͤȹ礻ʸ(ʣ)줾","Ƿ礷
#       "{", "}"ͿƷʸɲä롣
	# hash ref
	elsif(ref $var eq 'HASH') {
	    my @substr;
	    foreach my $k (sort keys %$var) {
		my $v = $var->{$k};
		push(@substr, "'$k'=>" . refSerialize($v));
	    }
	    $str .= '{' . join(', ', @substr) . '}';
	}
#
#     4)嵭ʳξ硢äͤ"'"(󥰥륯)ղä
#       ʸʸɲä롣
        # not ref -> 顼ȤƲ
	else {
	    $var =~ s/\'/\\'/g;  # ͤ˥󥰥륯Ȥ硢򥨥פ
	    $str .= "'" . $var . "'";
	}
    }
#
#  2. ʸ꥿󤹤롣
    return($str);
}

##############################################################################
1; #
##############################################################################
