package RECOG_PROJECTS::Schema::GenePropertyDef;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("gene_property_def");
__PACKAGE__->add_columns(
  "id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "project_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "name",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 20,
  },
  "data_type",
  {
    data_type => "VARCHAR",
    default_value => undef,
    is_nullable => 0,
    size => 60,
  },
  "init_user_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "init_date",
  {
    data_type => "DATETIME",
    default_value => undef,
    is_nullable => 0,
    size => 19,
  },
  "last_user_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "last_date",
  {
    data_type => "TIMESTAMP",
    default_value => "CURRENT_TIMESTAMP",
    is_nullable => 0,
    size => 14,
  },
);
__PACKAGE__->set_primary_key("id");
__PACKAGE__->add_unique_constraint(
  "gene_property_def_uniq_proj_name_data_type",
  ["project_id", "name", "data_type"],
);


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-25 13:54:37
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:GhtZslziU6CFz04SZ4wlaQ

__PACKAGE__->belongs_to (
    project => 'RECOG_PROJECTS::Schema::Project', {
        'foreign.id' => 'self.project_id'
    }
);

__PACKAGE__->belongs_to (
    init_user => 'RECOG_PROJECTS::Schema::Member', {
        'foreign.id' => 'self.init_user_id'
    }
);

__PACKAGE__->belongs_to (
    last_user => 'RECOG_PROJECTS::Schema::Member', {
        'foreign.id' => 'self.last_user_id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
