package RECOG_PROJECTS::Schema::ProjectMember;

use strict;
use warnings;

use base 'DBIx::Class';

__PACKAGE__->load_components(
  "ResultSetManager",
#  "UTF8Columns",
  "InflateColumn::DateTime",
  "Core",
  "Core",
);
__PACKAGE__->table("project_member");
__PACKAGE__->add_columns(
  "project_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "member_id",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 10 },
  "udate",
  {
    data_type => "TIMESTAMP",
    default_value => "CURRENT_TIMESTAMP",
    is_nullable => 0,
    size => 14,
  },
  "rank",
  { data_type => "INT", default_value => undef, is_nullable => 0, size => 11 },
);
__PACKAGE__->set_primary_key("project_id", "member_id");


# Created by DBIx::Class::Schema::Loader v0.04005 @ 2009-03-25 13:54:37
# DO NOT MODIFY THIS OR ANYTHING ABOVE! md5sum:OvDLlQ+FfKmHlukvNKwowA

__PACKAGE__->belongs_to (
    project => 'RECOG_PROJECTS::Schema::Project', {
        'foreign.id' => 'self.project_id'
    }
);

__PACKAGE__->belongs_to (
    member => 'RECOG_PROJECTS::Schema::Member', {
        'foreign.id' => 'self.member_id'
    }
);

# You can replace this text with custom content, and it will be preserved on regeneration
1;
