#!/usr/bin/perl -s
use strict;
use DateTime;
use File::Basename;
use File::Path;
use FileHandle;
use RECOG_PROJECTS::Schema;

package RECOG_PROJECTS;

$RECOG_PROJECTS::DBNAME_PROJECT = 'recog_projects_draft';

###############################################################################
#
sub connect_db {
    #
    my($dbname) = $RECOG_PROJECTS::DBNAME_PROJECT;
    my($dbs) = 'dbi:mysql:' . $dbname;
    my($file_mycnf) = "$ENV{'MBGD_HOME'}/etc/my.cnf";
    if (-e $file_mycnf) {
        $dbs .= ";mysql_read_default_file=$file_mycnf";
    }
    my($db) = RECOG_PROJECTS::Schema->connect($dbs);

$db->storage->debug(1);

    return $db;
}

###############################################################################
#
sub validate_member_name {
    my($name) = shift;

    #
    if ($name =~ /[^0-9A-Za-z\_]/) {
        print STDERR "ERROR :: User-name contains illegal character. (0-9, A-Z, a-z and '_' )\n";
        return;
    }

    return 1;
}

###############################################################################
#
sub exist_member {
    my($db) = shift;
    my($name) = shift;

    #
    my($cond_member_ref) = { 'user_name' => $name,
                           };
    my($member_ref) = $db->resultset('Member')->find($cond_member_ref);
    if ($member_ref) {
        # already exists.
        return $member_ref;
    }

    return;
}

###############################################################################
#
sub validate_project_name {
    my($name) = shift;

    #
    if ($name =~ /[^0-9A-Za-z\_]/) {
        return;
    }

    return 1;
}

###############################################################################
#
sub exist_project {
    my($db) = shift;
    my($name) = shift;

    #
    my($cond_project_ref) = { 'proj_name' => $name,
                           };
    my($project_ref) = $db->resultset('Project')->find($cond_project_ref);
    if ($project_ref) {
        # already exists.
        return $project_ref;
    }

    return;
}

###############################################################################
#
sub exist_project_member {
    my($db) = shift;
    my($id_project) = shift;
    my($id_member) = shift;

    #
    my($cond_project_member_ref) = { 'project_id' => $id_project,
                                     'member_id'  => $id_member,
                                   };
    my($project_member_ref) = $db->resultset('ProjectMember')->find($cond_project_member_ref);
    if ($project_member_ref) {
        # already exists.
        return $project_member_ref;
    }

    return;
}

###############################################################################
#
sub print_html_menu {
    my($db) = shift;
    my($mode) = shift;

    my(@item_list) = ('', );

    foreach my$item (@item_list) {
    }


    return;
}

###############################################################################
#
sub create_htpasswd {
    my($account_name) = shift;
    my($account_pass) = shift;

    my($file_htpasswd) = "$ENV{'MBGD_HOME'}/etc/htpasswd_recog_proj";
    my($obj_htpasswd) = Htpasswd->new($file_htpasswd);
    my($sta_name) = $obj_htpasswd->valid_name($account_name);
    my($sta_pass) = $obj_htpasswd->valid_pass($account_pass);
    if (!$sta_name || !$sta_pass) {
        #
        return;
    }

    my($sta) = $obj_htpasswd->create_user($account_name,
                                          $account_pass);
    if (!$sta) {
        #
        return;
    }

    return 1;
}

###############################################################################
#
sub update_htpasswd {
    my($account_name) = shift;
    my($account_pass) = shift;

    return create_htpasswd($account_name, $account_pass);
}

###############################################################################
#
sub remove_htpasswd {
    my($account_name) = shift;

    my($file_htpasswd) = "$ENV{'MBGD_HOME'}/etc/htpasswd_recog_proj";
    my($obj_htpasswd) = Htpasswd->new($file_htpasswd);
    my($sta_name) = $obj_htpasswd->valid_name($account_name);
    if (!$sta_name) {
        #
        return;
    }

    my($sta) = $obj_htpasswd->delete_user($account_name);

    return 1;
}

###############################################################################
#
sub get_my_account {

    my($name) = $ENV{'REMOTE_USER'};

    if ($name =~ /^\s*$/) {
        return;
    }

    #
    my($db) = RECOG_PROJECTS::connect_db();

    #
    my($cond_account_ref) = { 'user_name' => $name,
                            };
    my($account_ref) = $db->resultset('Member')->find($cond_account_ref);

    return $account_ref;
}

###############################################################################
#
sub print_html_head {
    my($opt) = shift;

    my($account_ref) = get_my_account();

    print <<EOB;
Content-type: text/html

<?xml version="1.0" encoding="UTF-8">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_project.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
</head>

<body>
EOB

    if (!$opt->{'NO_USERNAME'}) {
        if ($account_ref) {
            my($name) = $account_ref->user_name;
            print "<div class=\"myname\">[$name]</div>";
        }
    }

    return;
}

###############################################################################
#
sub print_html_foot {
    print <<EOB;
</body>
</html>
EOB

    return;
}

###############################################################################
#
sub save_fh2file {
    my($fhr) = shift;
    my($file_out) = shift;
    my($buf);

    my($fh_out) = FileHandle->new(">$file_out") || die("Can not open $file_out($!)");
    while(read($fhr, $buf, 2048)) {
        $fh_out->print($buf);
    }
    $fh_out->close();

    return;
}

###############################################################################
#
sub parse_file_gene_property {
    my($filename) = shift;

    #
    my($gene_prop_ref) = {};
    $gene_prop_ref->{'LIST_KEY'}  = [];
    $gene_prop_ref->{'KEY2INDEX'} = {};
    $gene_prop_ref->{'HASH_VAL'}  = {};
    $gene_prop_ref->{'ERROR'}     = [];

    #
    my($fh) = FileHandle->new("$filename") || return;

    # data-header(1st line)
    my($line) = $fh->getline();
    $line =~ s#[\r\n]*$##;
    my($head_sp, $head_name, @list_key) = split(/\t/, $line);
    foreach my$key (@list_key) {
        my($name, $type) = ($key =~ /^\s*([^\(\)]+)\((.+)\)\s*$/);
        my($ent) = {};
        $ent->{'NAME'} = $name;
        $ent->{'TYPE'} = $type;
        push(@{$gene_prop_ref->{'LIST_KEY'}},  $ent);
    }

    #
    my($index) = 0;
    foreach my$key (@list_key) {
        if (exists($gene_prop_ref->{'KEY2INDEX'}->{"$key"})) {
            push(@{$gene_prop_ref->{'ERROR'}}, "Found same key. '$key'");
        }
        $gene_prop_ref->{'KEY2INDEX'}->{"$key"} = $index;
        $index++;
    }

    #
    while (my$line=$fh->getline()) {
        $line =~ s#[\r\n]*$##;

        my($sp, $name, @list_val) = split(/\t/, $line);

        $gene_prop_ref->{'HASH_VAL'}->{"$sp"}->{"$name"} = [];
        push(@{$gene_prop_ref->{'HASH_VAL'}->{"$sp"}->{"$name"}}, @list_val);
    }
    $fh->close();

    return $gene_prop_ref;
}

###############################################################################
#
sub store_gene_property_key {
    my($db) = shift;
    my($account_id) = shift;
    my($proj_id) = shift;
    my($gene_prop_key_ref) = shift;

    #
    my($prop_def_list_ref) = [];
    foreach my$ent (@{$gene_prop_key_ref}) {
        my($cond_prop_def_ref) = { 'name'      => $ent->{'NAME'},
                                 };
        my($prop_def_ref) = $db->resultset('GenePropertyDef')->find($cond_prop_def_ref);
        if (!$prop_def_ref) {
            my(%hash_gene_prop_def);
            $hash_gene_prop_def{'project_id'}   = $proj_id;
            $hash_gene_prop_def{'name'}         = $ent->{'NAME'};
            $hash_gene_prop_def{'data_type'}    = $ent->{'TYPE'};
            $hash_gene_prop_def{'init_user_id'} = $account_id;
            $hash_gene_prop_def{'init_date'}    = DateTime->now;
            $hash_gene_prop_def{'last_user_id'} = $account_id;
            $hash_gene_prop_def{'last_date'}    = DateTime->now;
            $prop_def_ref = $db->resultset('GenePropertyDef')->create(\%hash_gene_prop_def);
        }
        elsif ($prop_def_ref->data_type ne $ent->{'TYPE'}) {
            $prop_def_ref->data_type($ent->{'TYPE'});
            $prop_def_ref->init_user_id($account_id);
            $prop_def_ref->init_date(DateTime->now);
            $prop_def_ref->update;
        }

        push(@{$prop_def_list_ref}, $prop_def_ref);
    }

    return $prop_def_list_ref;
}

###############################################################################
#
sub store_gene_properties {
    my($db) = shift;
    my($prop_def_list_ref) = shift;
    my($sp) = shift;
    my($gene_prop_sp_ref) = shift;

    #
    my(@prop_key_list) = @{$prop_def_list_ref};

    #
    my(@name_list) = sort(keys(%{$gene_prop_sp_ref}));
    foreach my$name (@name_list) {
        my($gene_prop_spname_ref) = $gene_prop_sp_ref->{"$name"};
        my($idx) = 0;
        foreach my$prop_def_ref (@{$prop_def_list_ref}) {
            my($prop_def_id) = $prop_def_ref->id;
            my($val) = $gene_prop_spname_ref->[$idx];

            #
            my($cond_prop_ref) = { 'gene_property_def_id' => $prop_def_id,
                                   'sp'                   => $sp,
                                   'locus_tag'            => $name,
                                 };
            my$gene_prop_ref = $db->resultset('GeneProperty')->search($cond_prop_ref);

            #
            if ($val =~ /^\s*$/) {
                # clear this property(delete)
                if ($gene_prop_ref) {
                    while (my$ref=$gene_prop_ref->next) {
                        $ref->delete;
                    }
                }
            }
            else {
                # insert / update
                if ($gene_prop_ref->count == 0) {
                    my(%gene_prop_hash);
                    $gene_prop_hash{'gene_property_def_id'} = $prop_def_id;
                    $gene_prop_hash{'sp'}                   = $sp;
                    $gene_prop_hash{'locus_tag'}            = $name;
                    $gene_prop_hash{'value'}                = $val;

                    $db->resultset('GeneProperty')->create(\%gene_prop_hash);
                }
                else {
                    while (my$ref=$gene_prop_ref->next) {
                        if ($ref->value ne $val) {
                            $ref->value($val);
                            $ref->update;
                        }
                    }
                }
            }

            $idx++;
        }
    }

    return;
}

###############################################################################
#
sub move_to_project_list {

    print <<EOB;
<form name="fm_proj_list">
<input type="button" name="" value="Project list" onclick="list_project(); ">
</form>
EOB

    return;
}

###############################################################################
#
sub move_to_project {
    my($proj_id) = shift;

    print <<EOB;
<form name="fm_proj_list">
<input type="button" name="" value="Info project" onclick="info_project_win($proj_id); ">
</form>
EOB

    return;
}

###############################################################################
#
sub move_to_project_analysis {
    my($proj_id) = shift;

    print <<EOB;
<form name="fm_proj_list">
<input type="button" name="" value="Analysis list" onclick="list_analysis($proj_id); ">
</form>
EOB

    return;
}

###############################################################################
#
sub move_to_project_property {
    my($proj_id) = shift;

    print <<EOB;
<form name="fm_proj_list">
<input type="button" name="" value="Property list" onclick="list_properties($proj_id); ">
</form>
EOB

    return;
}

###############################################################################
1;#
###############################################################################
