#!/usr/local/bin/perl

package SimpleSet;

$DEFAULT_SEP = ',';

sub new {
	my($class, %opt) = @_;
	my($this) = {};
	bless $this, $class;
	if ($opt{list}) {
		$this->init($opt{list},$opt);
	}
	return $this;
}
sub init {
	my($this, $list, $opt) = @_;
	if (ref $list eq 'ARRAY') {
		$this->{list} = $list;
	} elsif (ref $list eq 'HASH') {
		if ($opt{'order_by_keys'}) {
			$this->{list} = sort keys %{$list};
		} elsif ($opt{'order_by_values'}) {
			$this->{list} = sort { $list->{$a}<=>$list->{$b} } keys %{$list};
		}
	} else {
		my($sep) = $opt{sep};
		$sep = $DEFAULT_SEP if (! $sep);
		my @splist = split(/$sep/,$list);
		$this->{list} = \@splist;
	}
	if (defined $this->{hash}) {
		$this->set_hash;
	}
}
sub set_hash {
	my($this) = @_;
	undef $this->{hash};
	my($i) = 0;
	foreach $el (@{$this->{list}}) {
		$this->{hash}->{$el} = $i++;
	}
}
sub find {
	my($this,$el) = @_;
	$this->set_hash if (!defined $this->{hash});
	return defined $this->{hash}->{$el};
}
sub findidx {
	my($this,$el) = @_;
	$this->set_hash if (!defined $this->{hash});
	return $this->{hash}->{$el};
}
sub list {
	my($this) = @_;
	return @{ $this->{list} };
}
# subsetPat:
#  input: subset of the list, output: pattern string
sub subsetPat {
	my($this,$subset,$yes,$no) = @_;
	my($pat) = "";
	$yes = '1' if (! defined $yes);
	$no = '0' if (! defined $no);
	foreach $sp ($this->list) {
		if ($subset->find($sp)) {
			$pat .= $yes;
		} else {
			$pat .= $no;
		}
	}
	$pat;
}
# subset:
#  input: pattern string, output: subset of list
sub subset {
	my($this,$pat,$yes,$no) = @_;
	my($i, @newlist);
	$yes = '1' if (! defined $yes);
	$no = '0' if (! defined $no);
	foreach $spflg (split(//,$pat)) {
		if ($spflg ne $no) {
			push(@newlist, $this->{list}->[$i]);
		}
		$i++;
	}
	return ref($this)->new(list=>\@newlist);
}
sub print {
	my($this) = @_;
	my($flag);
	print join(',', $this->list), "\n";
}

package main;
if ($0 eq __FILE__) {
	$list = SimpleSet->new(list=>['eco','bsu','syn']);
	$superlist = SimpleSet->new(list=>['eco','bsu','afu','mma','mac','syn','sau']);
	$pat =  $superlist->subsetPat($list),"\n";
	print "$pat\n";
	$newlist = $superlist->subset($pat)->print;
	$newlist = $superlist->subset('0101001')->print;
}
1;
