#!/usr/bin/perl

use MbgdUserGenomeCommon;

sub checkUploadGbkFile {
	my($dir) = @_;
	my($fileGbk) = "$dir/ncbiGbk";
	my($genbank_ref) = GenBank->new($fileGbk);
	my($uid) = 'dummy';
	my($idUserGenome, $idUserChromosome) = ($dir =~ m#gu(\d+)/.*/chr(\d+)#);
##	my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $idUserChromosome);
	my($fileError) = "$dir/error.txt";

	my(@err_msg_all);
	while (my $data = $genbank_ref->read_entry()) {
		my(@err_msg) = $genbank_ref->get_status_read_entry();
		if (scalar(@err_msg) != 0) {
##		      MbgdUserGenomeCommon::saveErrorMessage($fileError, @err_msg);
		} else {
			my($refGeneTab) = MbgdUserGenomeCommon::readGbkFile($data,
						    $idUserGenome, $idUserChromosome, '', '', $genbank_ref);
			checkUploadDataFile_sub($uid,
				$idUserGenome,
				$idUserChromosome,
				$refGeneTab,
				$refGeneTab,
				$fileError,
			        @{$refGeneTab->{'MSG_ERR'}});
    		}
    		push(@err_msg_all, @err_msg);
	}
	if (scalar(@err_msg_all) != 0) {
    		MbgdUserGenomeCommon::saveErrorMessage($fileError, @err_msg_all);
	}
}

sub checkUploadDataFile {
	my($dir) = @_;
	my($geneTabFile) = "$dir/origGeneTab";
	my($protSeqFile) = "$dir/origProtein";
	$refGeneTab = &MbgdUserGenomeCommon::readOrigGeneTab($geneTabFile, $protSeqFile);;
	$refFasta= $MbgdUserGenomeCommon::fefGeneTab->{PROT_SEQ_SET} = &MbgdUserGenomeCommon::readOrigFasta($protSeqFile);;
	my($gid, $cid) = ($dir =~ m#gu(\d+)/.*/chr(\d+)#);
	my($fileError) = "$dir/error.txt";
	my($uid) = 'dummy';

	$gid+=0; $cid+=0;
	

	&checkUploadDataFile_sub($uid,$gid,$cid,$refGeneTab, $refFasta, $fileError);
}

sub checkUploadDataFile_sub {
    my($uid) = shift;
    my($idUserGenome) = shift;
    my($idUserChromosome) = shift;
    my($refGeneTab) = shift;
    my($refFasta) = shift;
    my($fileError) = shift;
    my(@listReadErrMsg) = @_;
    my($msg);
    my($MAX_LEN_LOCUSTAG) = 32;

    #
    my($errCount) = scalar(@listReadErrMsg);

    #
    my(@listErrMsg);
    my($refGene);
    print STDERR "####genome=$idUserGenome,chr=$idUserChromosome\n";
    foreach $refGene (@{$refGeneTab->{'LIST'}}) {
        my($id) = $refGene->{'ID'};
        if ($MAX_LEN_LOCUSTAG < length($id)) {
            $msg = sprintf("Gene ID is too long (ID='%s' > $MAX_LEN_LOCUSTAG characters).", $id);
            push(@listErrMsg, $msg);
        }
        if ($refGene->{'type'} eq 'CDS' && ! exists($refFasta->{'HASH'}->{"$id"})) {
            $msg = sprintf("Not found sequence (ID=%s).", $id);
            push(@listErrMsg, $msg);
        }
    }
    foreach my$seqid (sort(keys(%{$refFasta->{'HASH'}}))) {
        if ($MAX_LEN_LOCUSTAG < length($seqid)) {
            $msg = sprintf("Proteinseq ID is too long (ID='%s' >  $MAX_LEN_LOCUSTAG characters).", $seqid);
            push(@listErrMsg, $msg);
        }
    }
    $errCount += scalar(@listErrMsg);

    if ($errCount == 0) { # <A5><A8><A5>顼̵<A4><B7>
        # Ʊ<B0><EC> UserGenome <C6><E2><A4><C7>¾<A4><CE> UserChromosome <A4><C8>Ʊ<A4><B8> ID <A4><AC>¸<BA>ߤ<B7><A4>ʤ<A4><A4><AB><A1><A9>
        my($cid);
        for($cid = 1; $cid <= $MbgdUserGenomeCommon::MAX_USER_CHROMOSOME; $cid++) {
            if ($idUserChromosome == $cid) {
                # <BC><AB>ʬ<BC><AB><BF><C8>(UserChromosome)<A4><CF> SKIP
                next;
            }

            my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid,
                                                                    $idUserGenome,
                                                                    $cid);
            if (! -e $dirUc) {
                next;
            }

            if (! MbgdUserGenomeCommon::getUserChromosomeStatus($uid, $idUserGenome, $cid)) {
                next;
            }

            #
            my($refGeneTab2) = MbgdUserGenomeCommon::readGeneTab($uid, $idUserGenome, $cid);
            foreach $refGene (@{$refGeneTab->{'LIST'}}) {
                my($id) = $refGene->{'ID'};
                if (exists($refGeneTab2->{'HASH'}->{"$id"})) {
                    $msg = sprintf("ID '%s' Exists at Chr#%d.", $id, $cid);
                    push(@listErrMsg, $msg);
                }
            }
        }

        $errCount = scalar(@listErrMsg);
        if ($errCount == 0) {
            # Upload <A4><B5><A4>줿<A5>ǡ<BC><A5><BF><A4><CE><C0><B0><B9><E7><C0><AD> OK
	    print STDERR "Check OK\n";
            MbgdUserGenomeCommon::setUserChromosomeStatus($uid,
                                                          $idUserGenome,
                                                          $idUserChromosome,
                                                          $main::TRUE);
        }
        else {
	    print STDERR "Check ERROR\n";
            MbgdUserGenomeCommon::saveErrorMessage($fileError, @listErrMsg);
        }
    }
    else {
        MbgdUserGenomeCommon::saveErrorMessage($fileError,
                                               @listReadErrMsg,
                                               @listErrMsg);
    }

    return;
}
1;
