#!/usr/bin/perl -s

use MBGD;

sub load_data_into_new_table {
	my($db, $infile, $table, $schema) = @_;
	my($newtable) = "${table}_new";
	my($bcktable) = "${table}_bck";
	&create_table($db, $newtable, $schema);
	&load_table($db, $infile, $newtable);
	&rename_tables($db, $newtable, $table, $bcktable);
}
sub create_table {
	my($db, $table, $schema) = @_;
print "create table: $table\n";
	$db->execute("drop table if exists $table");
	$db->execute("create table $table $schema");
}
sub load_table {
	my($db, $infile, $table) = @_;
	$db->execute("load data local infile '$infile' into table $table");
	$db->flush_table("$table");
}
sub rename_tables {
	my($db, $newtable, $table, $bcktable) = @_;

	if ($bcktable) {
		$db->execute("drop table if exists $bcktable");
		$db->execute("rename table $table to $bcktable");
	}
	else {
		$db->execute("drop table if exists $table");
	}
	$db->execute("rename table $newtable to $table");
}
1;
