#!/usr/bin/perl

require "MBGD_Conf.pl";
require "emergency.pl";

package main;

###############################################################################
#
sub get_genename_nodbm {
    my($orfname) = @_;
    my($file);

    return "$GENE{$orfname}" if (defined $GENE{$orfname});

    my($sp, $orf) = split(/:/, $orfname);
    return "" if (defined $ReadTit{$sp});

    $orf =~ tr/a-z/A-Z/;

    if (-e $ENV{'MYSQL_USER_DATABASE'}) {
	$file = "$ENV{'MYSQL_USER_DATABASE'}/sptit/sptit.$sp";
    }
    elsif ($ENV{UPDATE_PROC}) {
#	$file = "$main::DIR_database.work/sptit/sptit.$sp";
	$file = "$ENV{'MBGD_HOME'}/database.work/sptit/sptit.$sp";
    } else {
	$file = "$main::DIR_database/sptit/sptit.$sp";
    }
    open(TIT, "$file") || warn "Can't open $file($!)";
    while(<TIT>) {
	($name,$gene) = split(/\t/);
    	$gene =~ s/\[//;
    	$gene =~ s/\]//;
	$GENE{$name} = $gene;
    }
    close(TIT);
    $ReadTit{$sp} = 1;
    return $GENE{$orfname};
}

###############################################################################
#
$main::CACHE_get_genename_mysql = {};
$main::CACHE_get_genedscr_mysql = {};
sub get_genename_mysql {
    my($ent) = shift;


    my($sp, $name) = split(':', $ent);
    my($lcname) = lc($name);

    if (!exists($main::CACHE_get_genename_mysql->{"$sp"})) {
        my($genename_ref) = $main::CACHE_get_genename_mysql->{"$sp"} = {};
        my($genedscr_ref) = $main::CACHE_get_genedscr_mysql->{"$sp"} = {};

        my($dbname) = $main::ENV{'MYSQL_DB'};
        my($db) = MBGD::DB->new($dbname);

        my($sql) = "select name, gene, descr from gene where sp='$sp'";
        my($sth) = $db->execute($sql);
        while (my$ref = $sth->fetchrow_hashref()) {
            my($g_name) = lc($ref->{'name'});

            $genename_ref->{"$g_name"} = $ref->{'gene'};
            $genedscr_ref->{"$g_name"} = $ref->{'descr'};
        }
    }


    return $main::CACHE_get_genename_mysql->{"$sp"}->{"$lcname"};
}

###############################################################################
#
sub get_genename {
    my($orfname) = @_;

    print STDERR "DBG :: OBSOLETE :: get_genename()\n";
    return get_genename_mysql($orfname);
}

###############################################################################
#
sub get_title {
    my($orfname) = @_;
    print STDERR "DBG :: OBSOLETE :: get_title()\n";

    my($sp, $name) = split(':', $orfname);
    my($lcname) = lc($name);
    get_genename_mysql($orfname);

    return $main::CACHE_get_genedscr_mysql->{"$sp"}->{"$lcname"};
}

###############################################################################
#
sub create_dbm {
    my($sp) = @_;

    print STDERR "DBG :: OBSOLETE :: create_dbm()\n";

    return;
}

###############################################################################
1;
###############################################################################
