#!/usr/bin/perl -s
use strict;
use FileHandle;
use IO::Socket;
use RECOG;

my($file_log) = "$ENV{'MBGD_HOME'}/work/tmp_log.$$";
my($file_log) = '-';
if (defined($main::FILE_LOG)) {
    $file_log = $main::FILE_LOG;
}

my($fh_log);
if (defined($main::HOST) && defined($main::PORT)) {
    my($limit) = 10;
    my($i);
    for($i = 0; $i <= $limit; $i++) {
        my(%opt) = ( 'PeerAddr' => $main::HOST,
                     'PeerPort' => $main::PORT,
                     'Proto'    => 'tcp',
                     );
        $fh_log = IO::Socket::INET->new(%opt);
        if ($fh_log) {
            last;
        }

        sleep(2);
    }
    if ($limit <= $i) {
        print STDERR "ERROR(socket) :: Can not connect $main::HOST($main::PORT)\n";
        die;
    }
}
else {
    $fh_log = FileHandle->new(">$file_log") || die("Can not open $file_log($!)");
    $fh_log->autoflush(1);
}

TOP:
while(<>) {
    foreach my$pat (@RECOG::PAT_progress) {
        if (/^$pat/i) {
            $fh_log->print($_);
            next TOP;
        }
    }
}
$fh_log->close();
