#!/usr/bin/perl -s
use strict;
use File::Basename;
use IO::Dir;
use IO::File;
use NqsAxes;
require 'MBGD_common.pl';

###############################################################################
#
sub print_usage {
    print STDERR "Usage :: $0 clustalw_out.aln\n";

    return;
}

###############################################################################
#
sub parse_clustalw {
    my($file_aln) = shift;

    my($seq_hash_ref) = {};
    my($fh) = IO::File->new("$file_aln") || die("Can not open $file_aln($!)");
    while (my$line=$fh->getline()) {
        next if ($line =~ /^\s+/);
        next if ($line =~ /^CLUSTAL/i);

        $line =~ s#[\r\n]*$##;
        my($name, $seq) = split(/\s+/, $line);

        $seq_hash_ref->{"$name"} .= $seq;
    }
    $fh->close();

    return $seq_hash_ref;
}

###############################################################################
#
sub write_fasta {
    my($seq_hash_ref) = shift;

    foreach my$name (sort(keys(%{$seq_hash_ref}))) {
        my($seq) = $seq_hash_ref->{"$name"};
        $seq =~ s#(.{1,60})#$1\n#g;

        print(">$name\n");
        print($seq);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    if ($main::h) {
        print_usage();
        exit(0);
    }

    foreach my$file_aln (@ARGV) {
        my($seq_hash_ref) = parse_clustalw($file_aln);
        write_fasta($seq_hash_ref);
    }
}

###############################################################################
1;#
###############################################################################
