#!/usr/bin/perl -s
use strict;
use IO::File;
use MBGD::DB;

###############################################################################
#
sub mapview_file {
    my($file_mapview) = shift;
    my($mapview_ref) = {};

    my($fh) = IO::File->new("$file_mapview") || die("Can not open $file_mapview($!)");
    while (my$line=$fh->getline()) {
        next if ($line =~ /^\s*$/);
        next if ($line =~ /^\s*#/);

        $line =~ s#[\r\n]*$##;

        my($spid, $sp, $chrid, $contigid, $seqno, $ordno, $accession, $from1, $to1, $dir) = split(/\t/, $line);

        my($ent) = $mapview_ref->{"$sp"}->{"$seqno"}->{"$ordno"} = {};
        $ent->{'chrid'}     = $chrid;
        $ent->{'contigid'}  = $contigid;
        $ent->{'accession'} = $accession;
        $ent->{'from1'}     = $from1;
        $ent->{'to1'}       = $to1;
        $ent->{'dir'}       = $dir;
    }
    $fh->close();

    return $mapview_ref;
}

###############################################################################
#
sub mapview_mysql {
    my($db) = shift;
    my($spec) = shift;
    my($mapview_ref) = {};

    my($tab) = "mapview";
    my($where) = "sp=?";
    my($sql) = "select * from $tab where $where";

    my($sth) = $db->prepare($sql);
    $sth->execute($spec);
    while (my$ref=$sth->fetchrow_hashref()) {

        my($sp)    = $ref->{'sp'};
        my($seqno) = $ref->{'seqno'};
        my($ordno) = $ref->{'ordno'};
        my($ent) = $mapview_ref->{"$sp"}->{"$seqno"}->{"$ordno"} = {};
        $ent->{'chrid'}     = $ref->{'chrid'};
        $ent->{'contigid'}  = $ref->{'contigid'};
        $ent->{'accession'} = $ref->{'accession'};
        $ent->{'from1'}     = $ref->{'from1'};
        $ent->{'to1'}       = $ref->{'to1'};
        $ent->{'dir'}       = $ref->{'dir'};
    }

    return $mapview_ref;
}

###############################################################################
#
sub convgene_mapview {
    my($db) = shift;
    my($spec) = shift;
    my($mapview_ref) = shift;

    #
    my(@title_list) = ('sp', 'name', 'gene', 'from1', 'to1', 'dir', 'type', 'descr');
    print join("\t", @title_list), "\n";

    #
    my($ofs) = 0;
    my(@seqno_list) = sort {$a <=> $b} keys(%{$mapview_ref->{"$spec"}});
    foreach my$seqno (@seqno_list) {
        my(@ordno_list) = sort {$a <=> $b} keys(%{$mapview_ref->{"$spec"}->{"$seqno"}});
        foreach my$ordno (@ordno_list) {
            my($ent) = $mapview_ref->{"$spec"}->{"$seqno"}->{"$ordno"};

            my($tab) = 'gene';
            my($where) = "sp=? and contigid=?";
            my($order) = "from1";
            my($sql) = "select * from $tab where $where order by $order";
            my($sth) = $db->prepare($sql);
            $sth->execute($spec, $ent->{'contigid'});
            while (my$ref=$sth->fetchrow_hashref()) {
                my(@dat) = ();
                push(@dat, $ref->{'sp'});
                push(@dat, $ref->{'name'});
                push(@dat, $ref->{'gene'});
                push(@dat, $ref->{'from1'} + $ofs);
                push(@dat, $ref->{'to1'}   + $ofs);
                push(@dat, $ref->{'dir'});
                push(@dat, $ref->{'type'});
                push(@dat, $ref->{'descr'});

                print join("\t", @dat), "\n";
            }
            $ofs += $ent->{'to1'} - $ent->{'from1'} + 1;
        }
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    #
    my($spec) = $ARGV[0];
    if (!$spec) {
        die("Found no spec.");
    }

    #
    my($dbname) = $main::DBNAME_MBGD;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME
    }
    my($db) = MBGD::DB->new($dbname);

    #
    my($mapview_ref);
    if ($main::FILE_MAPVIEW) {
        $mapview_ref = mapview_file($main::FILE_MAPVIEW);
    }
    else {
        $mapview_ref = mapview_mysql($db, $spec);
    }

    #
    convgene_mapview($db, $spec, $mapview_ref);
}

###############################################################################
1;#
###############################################################################
