#!/usr/bin/perl -s
use strict;
use HTTP::Request::Common;
use HTTP::Request;
use LWP::UserAgent;

###############################################################################
#
sub post_domclust_request {
    my($timeout) = shift;
    my($param_ref) = shift;

    #
    my($public__server) = "http://mbgd.genome.ad.jp/htbin/RECOG/domclust.cgi";
    my($public__server) = "http://bias.nibb.ac.jp:8044/htbin/RECOG/domclust.cgi";

    #
    my($t_start) = time();

    #
    my($opts) = [ 'output_format' => 'o11',
                  'output_type'   => 'complete',
                ];

    my(@key_list) = ('ingroup', 'outgroup', '-c', '-ci', '-m', '-mr', '-C', '-V', '-n', '-ne', '-p', '-H', '-ai', '-ao', '-Ohorizweight', '-OtaxMapSpec');
    foreach my$key (@key_list) {
        if (!exists($param_ref->{"$key"})) {
            next;
        }

        push(@{$opts}, $key => $param_ref->{"$key"});
    }



    #
    for (;;) {
        my($user_agent) = LWP::UserAgent->new();
        my($res) = $user_agent->request(POST $public__server, $opts);
        my($contents) = $res->decoded_content();

        my($sta) = ($contents =~ /[\r\n]#status=(.+)[\r\n]/i);
        if ($sta =~ /^finished$/i) {
            my(@line_list) = split(/[\r\n]+/, $contents);
            while (my$line=shift(@line_list)) {
                if ($line eq '#START_DATA') {
                    print join("\n", @line_list), "\n";
                    return;
                }
            }
        }

        sleep(10);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($param_ref) = {};

    $param_ref->{'ingroup'} = "ape,sai,sso,sto,pai,afu,mca,hch,hdu";

    post_domclust_request(600, $param_ref);
}

###############################################################################
1;#
###############################################################################

