#!/usr/bin/perl -s
#
# ΰҾϤ
###############################################################################
use MBGD;
use GD;
use MBGD::Contig;
use MBGD::WWW;
use MIME::Base64;
require "libMBGDaxes.pl";
require "libMBGDImgMap.pl";
require "emergency.pl";

#
$libMBGDImgMap::MODE = 'RECOG';
$libMBGDImgMap::cgi_gene_info = 'RECOG_gene_info_frame.pl';


$WWW = MBGD::WWW->new(title=>"Region Map");
$uInfo = $WWW->uInfo;
$cgi = $WWW->cgi;
%Args = $WWW->cgiGetArgs;

$| = 1;

if (! $Args{spec} && $Args{name} =~ /:/) {
	($Organism,$GeneName)= split(/:/, $Args{name});
} else {
	$Organism = $Args{spec};
	$GeneName = $Args{name};
}
$tabid = $Args{'tabid'};

#
$funccatType = $cgi->param('funccat_type');
$pref = $uInfo->loadProperty("Property::Preference");
if ($funccatType && ($pref->getValue('funccat_type') ne $funccatType)) {
    # Property::Preference  Function Category Type 򹹿
    $pref->setValue('funccat_type', lc($funccatType));
    $uInfo->saveProperty($pref, "Property::Preference");
}
$funccatType = $pref->getValue('funccat_type');

# Хѿ
#$Path_htbin       = $MBGD_PATH_HTBIN;

#
$db = MBGD::DB->new($ENV{'MYSQL_DB'});

# get gene info
($geneInfo) = MBGD::Gene->get($db, ["$Organism:$GeneName"]);

# get chromosome info
$chrid    = $geneInfo->{'chrid'};
$contigid = $geneInfo->{'contigid'};
my($opt) = {'keys' => "sp:id", 'with_length' => 1};
if ($chrid) {
    ($chrInfo) = MBGD::Chromosome->get( $db, ["$Organism:$chrid"], $opt);
}
elsif ($contigid) {
    ($chrInfo) = MBGD::Contig->get( $db, ["$Organism:$contigid"], $opt);
}

$From     = $geneInfo->{'from1'};
$To       = $geneInfo->{'to1'};
$Position = int(($From + $To + 1) / 2);
$Shape    = $chrInfo->{'shape'};
$ChrLen   = $chrInfo->{'length'};


$WWW->start_html;

$RegWidth = 20000;
# GeneInfo
if($Shape =~ /LINEAR/) {
    if($Position < $RegWidth / 2) {
	$Position = int($RegWidth / 2);
    }
    elsif($Position > ($ChrLen - int($RegWidth / 2))) {
	$Position = $ChrLen - int($RegWidth / 2);
    }
}    

@commands = &MBGDImg_Layout( $Organism, $chrid, $contigid, $Position, $RegWidth,
		{ MODE=>'funccat', 'FUNCCAT_TYPE'=>$funccatType, 'CenterGene'=>$GeneName } );
$image = &MBGDImg_Draw( @commands );

$TMPGIF = "tmpgif.$$";
open(TMP, ">$DIR_image/$TMPGIF");
print TMP $image->gif;
close(TMP);

foreach my$type ('MBGD', 'COG', 'KEGG', 'TIGR') {
    if ($type =~ /^$funccatType$/i) {
        print "<b>";
    }
    else {
        print "<a href=\"RECOG_region_map_html.pl?name=$Organism:$GeneName&funccat_type=$type&tabid=$tabid\">";
    }
    print "[$type]";
    if ($type =~ /^$funccatType$/i) {
        print "</b>";
    }
    else {
        print "</a>";
    }
    print "\n";
}
print "<br>\n";

print qq{<IMG SRC="/image/$TMPGIF" USEMAP="#REGION_MAP" BORDER=0>};
if (($pid = fork) == 0) {
	close(STDIN); close(STDOUT);
	close(STDERR);
	sleep 4;
	unlink("$DIR_image/$TMPGIF");
	exit;
}

# å֥롦ޥåפ
%opt;
$opt{'tabid'} = $tabid;
$ImageMap = &create_clickable_map($Organism, $chrid, $contigid, $Position, $RegWidth, $Dir, %opt);

print "<MAP NAME=\"REGION_MAP\">\n";
print "$ImageMap\n";
print "</MAP>\n";

print "\n";
print "\n";
print "<P>\n";
print "</FORM>\n";
print "\n";
print "</BODY>\n";
print "</HTML>\n";

exit;

###############################################################################
sub sort_org_and_genes {
    local( $org, @list ) = @_;
    local( @result );
    local( $buf, @match, @unmatch );

    while( scalar( @list )) {
	$buf = shift( @list );
	if( $buf =~ /^\s*$org:/ ) {
	    push( @match, $buf );
	}
	else {
	    push( @unmatch, $buf );
	}
    }

    push( @result, @match, sort @unmatch );
    @result;
}

###############################################################################
1;#
###############################################################################
