#!/usr/bin/perl -s

$MAX_LIMIT = 5000;

use MBGD::WWW;
use MBGD;
require("MBGD_common.pl");
require("libMBGDaxes.pl");
require "emergency.pl";

###use UserInfo;
###require("libCGI.pl");
###require("libHTML.pl");
###require("libMBGDlogo.pl");
#require("libMBGDHomolParam.pl");
#require("libMBGDUserInfo.pl");
#require("libMBGDSpecSelect.pl");

$WWW = MBGD::WWW->new(title=>"Motif Search Result");
%Args = $WWW->cgiGetArgs;

###%Args = &CGI_GetArgs;
$MOTLIB   = $Args{'motlib'};
if (ref($MOTLIB)) {
    @MOTLIB = @{$MOTLIB};
} else {
    @MOTLIB = ($MOTLIB) if ($MOTLIB !~ /^\s*$/);
}
foreach $m (@MOTLIB){
    $HasEval = 1 if ($m !~ /regexp/);
}

$SP       = $Args{'sp'};
$MOTID    = $Args{'motid'};
$START    = $Args{'start'};
$LIMIT    = $Args{'limit'};
$SelectGene = $Args{'selectgene'};

%param = $WWW->uInfo->getHomolParamHash;

if (! $Args{'motname'}) {
	$mot = MBGD::Motif->get("$Args{motlib}:$Args{motid}");
	$Args{'motname'} = $mot->{motname};
}

if (! $SP) {
##	if ($Args{SPEC}) {
##		@species = split(/,/, $Args{SPEC});
##		$SP = \@species;
	if ($Args{species}) {
		@species = split(/\|/, $Args{species});
		$SP = \@species;
	} else {
		if ($param{species}) {
			@species = split(/\|/, $param{species});
			$SP = \@species;
		} else {
			@species = &MBGD_SpecTableGetDefaultSpecies;
		}
	}
}

if (scalar(@MOTLIB) == 0) {
    print "Content-type: text/html\n";
    print "\n";

    print "<H2> Motif-lib selection is invalid </H2>\n";
    exit;
}

#
$paraMotlib = "";
foreach $motlib (@MOTLIB) {
    $paraMotlib .= "&" if ($paraMotlib ne '');
    $paraMotlib .= "motlib=$motlib";
}
print STDERR ">>$paraMotlib<<\n";

if ($START <= 0) {
    $START = 0;
}

if ($LIMIT =~ /^all$/) {
    $LIMIT = -1;
} elsif ($LIMIT > 0 && $LIMIT < 10) {
    $LIMIT = 10;
} elsif ($MAX_LIMIT < $LIMIT) {
    $LIMIT = $MAX_LIMIT;
}

$CUTOFF = $param{motif_eval};
$CUTOFF = $Args{eval_cut} if ($Args{eval_cut});

##print "Content-type: text/html; charset=us-ascii\n";
##print "\n";

$searchRes = &MBGD_SearchGeneByMotif(\@MOTLIB,
                                     $SP,
                                     $MOTID,
                                     $CUTOFF,
		## do not use limit; all results should be retrieved
                                     0, 0, $Args{count});

$idx     = $START;
$maxrows = $searchRes->{'MAXROWS'};
$rows    = $searchRes->{'ROWS'};

$fileScript = $ENV{'SCRIPT_NAME'};

$WWW->start_html;


if ($Args{motlib} =~ /prosite/i) {
	$LinkURL = "http://kr.expasy.org/cgi-bin/nicesite.pl?$Args{motid}";
} elsif ($Args{motlib} =~ /(pfam|smart|cd|cog)/i) {
	$LinkURL = "http://www.ncbi.nlm.nih.gov/Structure/cdd/cddsrv.cgi?uid=$Args{motid}";
} else {
	$LinkURL = "";
}
print "<H2>Motif search result: ";
if ($LinkURL) {
	print "<A HREF=\"$LinkURL\">$Args{motid} $Args{motname}</A>";
} else {
	print "$Args{motid} $Args{motname}";
}
print "</H2>\n";

#
if (! $Args{count} && 0 < $LIMIT) {
    if (0 < $idx) {
        $start = $START;
        $start -= $LIMIT;
        if ($start < 0) {
            $start = 0;
        }

        #
        $para = $WWW->cgiGetQueryString;
	if ($para !~ /start/) {
		$para .= "&start=$start";
	} else {
	        $para =~ s#start=\d+#start=$start#;
	}
        print "<A HREF=\"$fileScript?$para\">Prev Page</A>\n";
    }

    $start = $START + $LIMIT;
    if ($start < $maxrows) {
        $para = $WWW->cgiGetQueryString;
	if ($para !~ /start/) {
		$para .= "&start=$start";
	} else {
        	$para =~ s#start=\d+#start=$start#;
	}
        print "<A HREF=\"$fileScript?$para\">Next Page</A>\n";
    }
}


print "<HR>\n";

# 
print "<FORM ACTION=\"/htbin/cluster\" METHOD=\"POST\">\n";
print "<INPUT TYPE=\"hidden\" NAME=\"selectgene\" VALUE=\"$SelectGene\">\n";

# ɽ
if ($Args{count}) {
	%Count = %{$searchRes};
	&printCountTable;
} else {
	print "<TABLE>\n";
	print "<TH>";
	print join("<TH>",
		"", "Name", "from", "to", "score", "E-val", "description");
	$idx = 0;
	foreach $refInfo (@{$searchRes->{'INFO'}}) {
		($sp, $name, $from1, $to1, $score, $eval, $program, $descr)
			= @{$refInfo};
		if ($program eq 'regexp') {
			$score = $eval = '-';
		}
		if ($Args{count}) {
			$Count{$sp}++;
			$Flag_output = 0;
    		} elsif ($LIMIT<=0 || $idx >= $START && $idx < $START + $LIMIT) {
			$Flag_output = 1;
    		} else {
			$Flag_output = 0;
    		}
    		$idx++;
    		if ($Flag_output) {
    			print "<TR><TH>", $idx;
    			print "<TD>";
    		}
    		$eff_score = ($score eq '-' ? 1 : $score);
    		if ($Flag_output && $SelectGene =~ /^on$/i) {
			print "<INPUT TYPE=\"checkbox\" NAME=\"hgenes\" VALUE=\"$sp:$name,$eval,$eff_score,$from1,$to1\" CHECKED>\n";
		} else {
       	 		print "<INPUT TYPE=\"hidden\" NAME=\"hgenes\" VALUE=\"$sp:$name,$eval,$eff_score,$from1,$to1\">\n";
    		}
		if ($Flag_output) {
	    		print "<A HREF=\"RECOG_gene_info_frame.pl?spec=$sp&name=$name";
	    		print "\"><b>$sp:$name</b></A>";

	    		foreach $val ($from1, $to1, $score, $eval) {
	        		if ($val =~ /^\s*$/) {
	            			print "<TD><BR>";
       				} else {
         	   			print "<TD ALIGN=\"right\">$val";
        			}
    	    		}
			print "<TD>", $descr;
    			print "\n";
    		}
	}
	print "</TABLE>\n";
}

#if ($Args{count}) {
#	&printCountTable;
#} else {
#	print "</TABLE>\n";
#}
print STDERR "OK\n";

print "<!--\n";
print "<P>\n";
print "<INPUT TYPE=\"submit\" VALUE=\"Find cluster(s)\">\n";
#print "<INPUT TYPE=\"hidden\" NAME=\"connect\" VALUE=\"nearest\">\n";
print "<INPUT TYPE=\"hidden\" NAME=\"motif\" VALUE=\"on\">\n";
print "<INPUT TYPE=\"hidden\" NAME=\"missdist\" VALUE=\"0\">\n";
#print "<INPUT TYPE=\"hidden\" NAME=\"motsearch\">\n";
#if ($SelectGene =~ /^on$/i) {
#    print "<INPUT TYPE=\"hidden\" NAME=\"motselectuser\">\n";
#} else {
#    print "<INPUT TYPE=\"hidden\" NAME=\"motselectdb\">\n";
#}

#foreach $motlib (@MOTLIB) {
#    print "<INPUT TYPE=\"hidden\" NAME=\"motlib\" VALUE=\"$motlib\">\n";
#}

###print "<INPUT TYPE=\"hidden\" NAME=\"motsp\" VALUE=\"$SP\">\n";
if ($Args{count}) {
    ($motlib) = split(/:/,$Args{motlib});
    print "<INPUT TYPE=\"hidden\" NAME=\"motsearch_id\" VALUE=\"$motlib:$MOTID\">\n";
    print "<INPUT TYPE=\"hidden\" NAME=\"motsearchcutoff\" VALUE=\"$CUTOFF\">\n";
}

print "</FORM>\n";

# gene β/Բĥܥ
print "<FORM ACTION=\"$ENV{'SCRIPT_NAME'}\" METHOD=\"POST\">\n";

if ($HasEval) {
	print "cutoff : E-value\n";
	print "<INPUT TYPE=\"text\" NAME=\"eval_cut\" VALUE=\"$CUTOFF\" SIZE=\"5\">\n";
}

$CHECKED = "CHECKED" if ($Args{selectgene});
if ($Args{count}) {
	if ($HasEval) {
		print "<INPUT TYPE=\"submit\" NAME=\"count\" VALUE=\"Re-display\">\n";
	}
	print "<INPUT TYPE=\"submit\" VALUE=\"Show All results\">\n";
} else {
	print "<INPUT TYPE=\"checkbox\" NAME=\"selectgene\" VALUE=\"on\" $CHECKED>individual gene selection\n";
	print "<INPUT TYPE=\"submit\" VALUE=\"Re-display\">\n";
}

	foreach $key (keys(%Args)) {
	    next if ($key =~ /^(selectgene|eval_cut|count)$/);
	    if (ref($Args{"$key"})) {
	        foreach $val (@{$Args{"$key"}}) {
	            print "<INPUT TYPE=\"hidden\" NAME=\"$key\" VALUE=\"$val\">\n";
	        }
	    } else {
	        print "<INPUT TYPE=\"hidden\" NAME=\"$key\" VALUE=\"", $Args{"$key"}, "\">\n";
	    }
	}

	print "</FORM>\n";
print "-->\n";

#$WWW->page_footer;
#$WWW->end_html;



sub printCountTable {
	my($idx);
	print "<TABLE BORDER>\n";
	print "<TR>\n";
	if (@species > 100) {
		$RowNum  = 20;
	} else {
		$RowNum  = 10;
	}
	foreach $sp (@species) {
	    	if ($idx++ % $RowNum == 0) {
			print "</TABLE>" if ($idx > 1);
	    		print "<TD VALIGN=\"top\">\n";
			print "<TABLE>\n";
	    		print "<TR>\n";
	    		foreach $val ("", "sp", "count") {
	       	 	print "<TH>$val</TH>";
	    		}
	    		print "</TR>\n";
	    	}
         	print "<TR><TH>", $idx, "</TH>";
        	print "<TD>$sp</TD>";
        	print "<TD ALIGN=\"right\">";
		if ($Count{$sp}) {
			print "<A HREF=\"searchGeneByMotif.pl?";
        		print $paraMotlib,   "&";
        		print $paraProgram,  "&";
        		print "sp=",    $sp, "&";
        		print "motid=", $MOTID, "&";
        		print "start=", 0,   "&";
        		print "limit=", $LIMIT, "&";
        		print "eval_cut=", $Args{eval_cut}, "&";
        		print "selectgene=\"off\"";
        		print "\">";
		}
		print 0+$Count{$sp};
		if ($Count{$sp}) {
			print "</A>";
		}
		print "</TD></TR>\n";
    	}
	print "</TABLE></TD>\n";
	print "</TR></TABLE\n";
}
