#!/usr/bin/perl -s
use strict;
use MBGD::DB;
use CGI;
use MBGD::DB;
require 'MBGD_Conf.pl';

###############################################################################
#
sub view_attribute {
    my(@category_name_list) = ( 'genome:species_metagenome',
                                'genome:species_incomplete',
                              );

    print "Content-type: text/html\n";
    print "\n";

    print "<html>\n";
    print "<head>\n";
    print '<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />', "\n";
    print "<script>\n";
    print "function edit_attribute(key) {\n";
    print "  var doc = this.document;\n";
    print "\n";
    print "  doc.frm_edit_attr.key_name.value = key;\n";
    print "  doc.frm_edit_attr.action = '/htbin/RECOG/edit_attribute_win.cgi';\n";
    print "  doc.frm_edit_attr.submit();\n";
    print "}\n";
    print "</script>\n";
    print "</head>\n";

    print "<body>\n";

    # 
    my($dbname) = $main::DBNAME_MBGD;
    my($db) = MBGD::DB->new($dbname);
    my($tab) = "attribute";

    print "<table border>\n";
    print "<tr>\n";
    print "<th></th>\n";
    print "<th>Category</th>\n";
    print "<th>Name</th>\n";
    print "<th>Value</th>\n";
    print "</tr>\n";

    #
    my($order) = "category, name";
    my($sql) = "select * from $tab order by $order";
    my($sth) = $db->execute($sql);
    while (my$ref=$sth->fetchrow_hashref()) {
        my($category_name) = join(':', $ref->{'category'}, $ref->{'name'});
        print qq{<tr>\n};
        print qq{  <td><input type="button" name="btn_attr" value="Edit" onclick="edit_attribute('$category_name')"></td>\n};
        print qq{  <td>$ref->{'category'}</td>\n};
        print qq{  <td>$ref->{'name'}</td>\n};
        print qq{  <td>$ref->{'value'}</td\n};
        print qq{</tr>\n};
    }
    print "</table>\n";

    print qq{<form name="frm_edit_attr" method="post" action="">\n};
    print qq{<input type="hidden" name="key_name" value="">\n};
    print qq{</form>};

    print "</body>\n";
    print "</html>\n";
    
    return;
}

###############################################################################
if ($0 eq __FILE__) {
    view_attribute();
}

###############################################################################
1;#
###############################################################################
