#!/usr/bin/perl

###############################################################################
#
#
#
###############################################################################
use File::Path;
use MBGD::WWW;
use MBGD::GOLD;
use Property::HomolParam;
use MbgdUserGenomeCommon;
use SelectByTaxonomy;
use PhylopatImage;
use RecogProjectCommon;
require "MBGD_Conf.pl";
require "MBGD_common.pl";
require "libMBGDaxes.pl";

$WWWROOT   = $ENV{'WWWROOT'};

my(@ranks_choose) = ('species', 'genus','family','order','class','phylum');

# Get Cookies
#

$WWW = MBGD::WWW->new();
%Args = $WWW->cgiGetArgs;
$uInfo = $WWW->uInfo;
$uid = $uInfo->uid();
my($homParam) = $uInfo->loadHomolParams();
my($param) = $homParam->asHashRef();
my($uinfo_param_ref) = $uInfo->loadParams();

# mode= selection / simpat / color
my($mode) = $Args{'mode'};
if ($mode !~ /(selection|simpat|color|recog_build)/) {
    $mode = 'selection';
}

$title = 'Organism Selection';
if ($mode =~ /^color$/i) {
    $title = 'Organism Color';
}
$WWW->set_title($title);

#
my(%spec_selected);
if ($mode !~ /^recog_build$/i) {
    foreach my$sp (split(/[\,\|]/, $param->{'species'})) {
        $spec_selected{"$sp"} = 1;
    }
}

#
$taxondir = '';
if (MbgdUserGenomeCommon::isMymbgdMode($uid)) {
    $taxondir  = MbgdUserGenomeCommon::getDirUserGenomeDatabase($uid);
    $taxonfile = "$taxondir/tax";
    MbgdUserGenomeCommon::createFileTaxon($uid);
}
elsif ($mode =~ /^recog_build$/i) {
    my($dir) = sprintf("%s/etc/public-server", $ENV{'RECOG_HOME'});
    $tax_public = MBGD::Taxonomy->new($dir);
    RecogProjectCommon::loadGenomeInfo("$dir/species");
    RecogProjectCommon::loadGoldInfo("$dir/gold", "$dir/gold_mbgd");

    #
    %spec_selected = ();
#    my(@spec_list);
#    my($file_spec_project) = "$dir/species";
#    my($fh) = FileHandle->new("$file_spec_project") || die("Can not open $file_spec_project($!)");
#    while (my$line=$fh->getline()) {
#        next if ($line =~ /^\s*#/);
#        next if ($line =~ /^\s*$/);
#
#        $line =~ s#[\r\n]*$##;
#        push(@spec_list, split(/,/, $line));
#    }
#    $fh->close();
#    foreach my$sp (@spec_list) {
#        $spec_selected{"$sp"} = 1;
#    }
}

$tax = MBGD::Taxonomy->new($taxondir);

$hom = $uInfo->loadHomolParams();
%param = $uInfo->getHomolParamHash; ## hash accessible as %param
$cluster_MAXSP        = $hom->getMaxSpec('MBGD',   $uid);
$cluster_MAXSP_MyMBGD = $hom->getMaxSpec('MyMBGD', $uid);

#if ($Args{'species'}) {
#    @species = $uInfo->setSpecies($Args{'species'});
#} else {
#    @species = split(/\|/, $param{'species'});
#}

$connect     = 'nearest';

my($tabid) = $WWW->uInfo->currentTableID;

@AllSpec = &MBGD_SpecTableGetAllSpec($taxondir);
if ($mode =~ /^recog_build$/) {
    @AllSpec = $tax_public->get_all_spec;
}
if (! defined $Args{species}) {
    @species = split(/\|/, $param{'species'});
    foreach $sp (@species) {
        $species{$sp} = 1;
    }
} else {
    my(@spList);
    if (ref($Args{species})) {
        @spList = @{ $Args{species} };
    }
    else {
        @spList = split(/,/, $Args{species});
    }
    foreach $sp (@spList) {
        $species{$sp} = 1;
    }
    foreach $sp (@AllSpec) {
        if ($species{$sp}) {
            push(@species, $sp);
        }
    }
    $param{'species'} = join('|',@species);
    $uInfo->saveParams(\%param);
}
if ($mode !~ /^(selection|recog_build)$/i) {
    @AllSpec = grep { $species{$_} } @AllSpec;
}

$| = 1;

$Script =<< "EndScript";
function clearSelect(){
    for (var i = 0; i < document.specForm.species_list.length; i++)
    {
        document.specForm.species_list.options[i].selected = false;
    }
}
function update_color() {
    var doc = document;

    var key = 'organism_color';
    var elm = doc.getElementById(key);
    var col = elm.value;

    var key = 'organism_color_disp';
    var elm = doc.getElementById(key);
    elm.innerHTML = '';
    if (col != '') {
        elm.innerHTML = '###';
    }
    elm.style.color = col;
    elm.style.backgroundColor = col;

    return;
}

EndScript

$WWW->start_html(-script=>{-language=>'JavaScript', -code=>$Script}, -onLoad=>"change_spec_list();",);

$WWW->page_header;

print <<END_JAVASCRIPT;
<script language="JavaScript" src="/js/common.js"></script>
<script language="JavaScript" src="/js/mbgd.js"></script>
<script language="JavaScript" src="/js/organism_selection.js"></script>
<script language="JavaScript" src="/js/create_tax.js"></script>
END_JAVASCRIPT

print <<END_FORM;
<FORM id="form_select_organism" name="specForm" METHOD="POST"
 ACTION="/htbin/cluster"
 TARGET="_top">
END_FORM

$staMymbgd = 'FALSE';
if ($staLoginMymbgd) {
    $staMymbgd = 'TRUE';
}
print "<input type=\"hidden\" name=\"sta_login_mymbgd\" value=\"$staMymbgd\">\n";
print "<input type=\"hidden\" name=\"phylopat_tabid\" value=\"$tabid\">\n";

#$filename = "$ENV{'WWWROOT'}/htdocs/Cluster.html";
#open(CLUSTHTML, "$filename") || die "File($filename) open error.";

#
my($btn_sel_orgs);
my($btn_list_orgs);
if ($mode =~ /^color$/) {
    $btn_sel_orgs = q{<input type="button" name="" value="Set color" onclick="set_species_color(this.form.selected_species); upd_species_color();">};
    $btn_list_orgs = q{<input type="button" name="" value="Set color" onclick="set_species_color(this.form.species_list); upd_species_color();">};
}
elsif ($mode =~ /^simpat$/i) {
    $btn_list_orgs = q{
<input type="button" name="" value="Add to presence" onclick="add_selected_species(this.form.species_all, this.form.species_list, this.form.presence_species); check_occurrence_organisms(this.form.species_all, this.form.presence_species, this.form.absence_species); upd_phylopat_image(); ">
<input type="button" name="" value="Add to absence" onclick="add_selected_species(this.form.species_all, this.form.species_list, this.form.absence_species); check_occurrence_organisms(this.form.species_all, this.form.absence_species, this.form.presence_species); upd_phylopat_image(); ">
};

    my($phylopat) = '';
    foreach my$sp (@AllSpec) {
        my($key) = "exist_$sp";
        if ($Args{"$key"} < 0) {
            # absense
            $phylopat .= '1';
            $sp_absence_hash{"$sp"} = 1; 
       }
        elsif (0 < $Args{"$key"}) {
            # presence
            $phylopat .= '2';
            $sp_presence_hash{"$sp"} = 1; 
        }
        else {
            # no check
            $phylopat .= '0';
        }
    }

    #
    my($map_phylopat) = PhylopatImageMap->new();
    my($xlen) = 600;
    my($ylen) =  15;
    $map_phylopat->set_size($xlen, $ylen);
    $map_phylopat->set_scale(1);
    $map_phylopat->set_border(1);
    $map_phylopat->set_patterm($phylopat);
    my($patlen) = $map_phylopat->get_pattern_length();
    my($cell_width) = int($xlen / $patlen);
    $cell_width = 2 if ($cell_width < 2);
    $map_phylopat->set_cell($cell_width);

    #
    my($html_name) = 'phylopat_map';
    my($html_id)   = 'phylopat_map';
    my(@name_list);
    my(%ghash);
    my(@glist) = MBGD::Genome->get();
    foreach my$ref (@glist) {
        my($sp) = $ref->{'sp'};
        $ghash{"$sp"} = $ref;
    }
    foreach my$sp (@AllSpec) {
        my($ref) = $ghash{"$sp"};
        my($fullname) = $ref->{'orgname'};
        if ($ref->{'strain'}) {
            $fullname .= "(" . $ref->{'strain'} . ")";
        }
        my($name) = "[$sp] $fullname";
        push(@name_list, $name);
    }
    my($html_map) .= $map_phylopat->print_phylopat($html_name,
                                                   $html_id,
                                                   @name_list);

    my($color) = 'ffff66,009900';
    print qq{
$html_map
<img id="img_phylopat" src= "/htbin/create_phylopat_gif?tabid=$tabid&spcolor=off&phylopat=$phylopat&color=$color" usemap="#phylopat_map" style="border:0px;">
    };
}
else {
    $btn_sel_orgs = '';
    $btn_sel_orgs .= q{<input type="button" name="" value="Default Organisms" onclick="setDefault(); ">};
    $btn_sel_orgs .= q{<input type="button" name="" value="Clear" onclick="remove_all_species(this.form.selected_species);">};
    $btn_sel_orgs .= q{<input type="button" name="" value="Remove" onclick="remove_selected_species(this.form.selected_species);">};
    $btn_sel_orgs .= q{&nbsp;&nbsp;};
    $btn_list_orgs = q{<input type="button" name="" value="<< Add" onclick="add_selected_species(this.form.species_all, this.form.species_list, this.form.selected_species); change_spec_list();">};
    $btn_list_orgs .= q{&nbsp;&nbsp;};
}

#
my($html_sel_spec_all) = '';
my($html_sel_spec_selected) = '';
my($html_hidden_spec_color) = '';
foreach $sp (@AllSpec) {
    my(%spInfo) = &MBGD_GetGenomeInfo($sp);
    if (MbgdUserGenomeCommon::isUserGenome($sp)) {
        my($gid) = MbgdUserGenomeCommon::getUserGenomeId($sp);
        %spInfo = MbgdUserGenomeCommon::getGenomeInfo($uid, $gid);
    }
    elsif ($mode =~ /^recog_build$/) {
        %spInfo = RecogProjectCommon::getGenomeInfo($sp);
    }
    my($html_selopt) = '';
    $html_selopt .= "<OPTION id=\"spname_opt_$sp\" VALUE=\"$sp\"";
    if ($mode !~ /^color$/i) {
        $html_selopt .= " SELECTED" if ($species{$sp});
    }
    $html_selopt .= ">";
#    $html_selopt .= "[$sp]";
    $html_selopt .= "$spInfo{'orgname'}";
    if ($spInfo{"strain"} ne '') {
        $html_selopt .= "(" . $spInfo{"strain"} . ")";
    }
#    $html_selopt .= "</OPTION>";
    $html_selopt .= "\n";

    $html_sel_spec_all .= $html_selopt;
    if ($spec_selected{"$sp"} == 1) {
        $html_sel_spec_selected .= $html_selopt;
    }

    if ($sp_absence_hash{"$sp"}) {
        $html_sel_spec_absence .= $html_selopt;
    }
    elsif ($sp_presence_hash{"$sp"}) {
        $html_sel_spec_presence .= $html_selopt;
    }

    my($key) = "spec_color_$sp";
    my($color) = $uinfo_param_ref->{"$key"};
    $html_hidden_spec_color .= qq{<input type="hidden" id="$key"  name="$key" value="$color">\n};
}

if ($mode =~ /^color$/) {
    $html_sel_spec_all = $html_sel_spec_selected;
    print qq{<input type="button" name="" value="Choose color" onclick="open_color_chooser('organism_color');">};
    print qq{<span id="organism_color_disp"></span>};
    print $html_hidden_spec_color, "\n";
}

#
my($min_width) = '500 px';
print <<EOB;
<table height="100%" border>
<tr>
<td style="vertical-align: top;" width="450px">
EOB

print qq{
<span style="white-space: nowrap;">
<span id="span_sel_org" style="cursor: pointer;" onclick="open_close_tab('tab_sel_org', this);">[-]</span>
<span id="tab_sel_org" style="white-space: nowrap; text-align:left;">
<span style="white-space: nowrap;">
};

if ($mode !~ /^simpat$/i) {
    print <<EOB;
<b>Selected organisms</b>
$btn_sel_orgs<br>
<select name="selected_species" style="width: 100%; height: 500px; " multiple>
$html_sel_spec_selected
</select>
EOB

}
else {
    print <<EOB;
<span style="white-space: nowrap;">
<b>Presence organisms</b>
<input type="button" name="" value="Remove All" onclick="remove_all_species(this.form.presence_species); upd_phylopat_image(); ">
<input type="button" name="" value="Remove" onclick="remove_selected_species(this.form.presence_species); upd_phylopat_image(); ">
<br>
</span>
<select name="presence_species" style="width:100%; min-width: $min_width; height: 250px; " multiple>
$html_sel_spec_presence
</select>
<hr>
<span style="white-space: nowrap;">
<b>Absence organisms</b>
<input type="button" name="" value="Remove All" onclick="remove_all_species(this.form.absence_species); upd_phylopat_image(); ">
<input type="button" name="" value="Remove" onclick="remove_selected_species(this.form.absence_species); upd_phylopat_image(); ">
<br>
</span>
<select name="absence_species" style="width:100%; min-width: $min_width; height: 250px; " multiple>
$html_sel_spec_absence
</select>

EOB

}

print <<EOB;
</span>
</span>
</span>

</td>
<td style="vertical-align: top;" width="500px">
<span style="white-space: nowrap; ">
<span id="span_lst_org" style="cursor: pointer; " onclick="open_close_tab('tab_lst_org', this);">[-]</span>
<span id="tab_lst_org" style="min-width: $min_width; white-space: nowrap; text-align:left;">
<span style="white-space: nowrap;"><b>List of organisms</b>
$btn_list_orgs
</span>

<input type="hidden" id="organism_color" name="organism_color" value="">
<br>
<div id="organism_selection_list" style="display: block; ">
<SELECT name="species_list" onChange="sync_spec_taxonomy(true);" style="width:100%; min-width: $min_width; height: 500px; " MULTIPLE>
$html_sel_spec_all
</SELECT>
</div>

<div id="id_div_sp_orig" style="display:none">
<SELECT name="species_all" disabled MULTIPLE>
$html_sel_spec_all
</SELECT>
<INPUT TYPE=button NAME="clrSel" VALUE="Clear" onClick="clearSelect()">
</div>
</span>
</span>
</td>

<td style="vertical-align: top; ">

<input type="button" name="" value="GOLD" onclick="disp_organism_selection(this.form, 'gold'); ">
<input type="button" name="" value="Taxonomy" onclick="disp_organism_selection(this.form, 'taxonomy'); sync_spec_taxonomy(true); ">
<br>
EOB


#
my(%ElimOrg);
my(@ElimOrgArray);
my(@deforg);
foreach my $sp (MBGD_SpecTableGetDefaultSpecies()) {
    push(@deforg, $sp);
}
my($default_orgs) = '"' . join('","', @deforg) . '"';
foreach $rank (@ranks_choose) {
    my @orglist = $tax->get_species({'one_strain'=>$rank});
    foreach my$o (@orglist) {
        $ElimOrg{$o}++;
    }
}
my($n_ranks_choose) = scalar(@ranks_choose);
foreach my$org ($tax->get_all_spec()) {
    my($num) = $n_ranks_choose - $ElimOrg{$org};
    if ($ElimOrg{$org} < $n_ranks_choose) {
        push(@ElimOrgArray, qq{"$org:$ElimOrg{$org}"});
    }
}
my($def_species) = join(',', @ElimOrgArray);

print <<EOB;
<script defer="defer">
function select_genome_each(elm_sel) {
    var doc = document;
    var orglist = new Array( $def_species );
    var orglist2 = new Array( orglist.length );

    var key = 'sel_choose_genome';
    var elm = doc.getElementById(key);

    var rank = elm.selectedIndex;
    for (var i = 0; i < orglist.length; i++) {
        var tmpArray = orglist[ i ].split(":");
        orglist2[ tmpArray[0] ] = tmpArray[1];
    }

    for (var i = 0; i < doc.specForm.species.length; i++) {
        if (orglist2[ doc.specForm.species[i].value ] < rank) {
            doc.specForm.species[i].checked = false;
            click_species(doc.specForm.species[i].value);
        }
    }

    return;
}
</script>
EOB

my($sta_display) = 'none';
my($sta_checked) = '';
if ($mode !~ /^(simpat|color)$/) {
    $sta_display = 'inline';
    $sta_checked = 'checked';
}

print <<EOB;
<span style="white-space: nowrap; display: $sta_display; ">
<input id="cb_choose_one_genome" type="checkbox" name="choose_one_genome" value="yes" $sta_checked>
Choose one genome for each
<SELECT id="sel_choose_genome" NAME="rank" onChange="elimNonDefault(this.document); sync_spec_taxonomy(false); ">
<OPTION VALUE="strain" >strain
EOB

my($sta_select) = 'selected';
foreach my$rank (@ranks_choose) {
    print "<option value=\"$rank\" $sta_select>$rank\n";
    $sta_select = '';
}

print <<EOB;
</SELECT>
</span>
<INPUT TYPE="button"  VALUE="Select all" onClick="selectAll(document, 0, 0, true);">
<INPUT TYPE="button"  VALUE="Clear all" onClick="selectAll(document, 0, 0, false);">
EOB


print <<EOB;
<div id="organism_selection_taxonomy" style="width: 100%; height: 500px; overflow: scroll; display: none; ">
EOB

#
my($wk_tax) = $tax;
if ($mode =~ /^recog_build$/) {
    $wk_tax = $tax_public;
}
print_html_organism_selection_taxonomy($wk_tax, 'mbgd');
print "</div>\n";


#
print "<div id=\"organism_selection_gold\" style=\"height: 500px; overflow: scroll; display: block; \">";
my(@gold_disp_field_list) = (
                              'superkingdom',
                              'phylum',
                              'class',
                              'order_',
                              'family',
                              'genus',
##                              'species',
#                              'domain',
##                              'organism',
##                              'strain',
#                              'serovar',
#                              'sequencing_method',
#                              'sequencing_depth',
#                              'straininfo',
#                              'culture',
#                              'symbiont',
#                              'type',
#                              'phylogeny',
#                              'sequencing_status',
#                              'project_status',
                              'phenotype',
                              'relevance',
                              'disease',
                              'habitat',
                              'ph',
                              'oxygen_requirements',
                              'cell_shape',
                              'cell_arrangement',
                              'motility',
                              'sporulation',
                              'energy_source',
                              'temperature_range',
#                              'temperature',
                              'salinity',
#                              'isolation',
#                              'country',
#                              'gc_percent',
#                              'availability',
#                              'goldstamp',
#                              'goldstamp_old',
#                              'greengenes_id',
#                              'homd_id',
#                              'gcat_id',
#                              'taxon_id',
#                              'entrez_pid',
#                              'img_oid',
#                              'size_kb',
#                              'orfs',
#                              'chromosomes',
#                              'plasmids',
#                              'data',
#                              'dbs',
#                              'institute',
#                              'funding',
#                              'publication',
#                              'date',
#                              'contact_name',
#                              'contact_email',
                            );
my(%gold_disp_field_hash);
foreach my$f (@gold_disp_field_list) {
    $gold_disp_field_hash{"$f"} = 1;
}

my(@gold_numeric_field_list) = (
                              'straininfo',
                              'ph',
                              'temperature',
                              'gc_percent',
                              'size_kb',
                              'orfs',
                              'chromosomes',
                              'plasmids',
                            );

my(@gold_multi_val_field_list) = (
                                   'phenotype',
                                   'relevance',
                                   'disease',
                                   'habitat',
                                   'cell_arrangement',
                                   'energy_source',
                                   'data',
                                   'dbs',
                                   'institute',
                                   'funding',
                                   );
my(%gold_multi_val_field_hash);
foreach my$f (@gold_multi_val_field_list) {
    $gold_multi_val_field_hash{"$f"} = 1;
}

my($gold_ref);
my(@gold_field_list);
if ($mode !~ /^recog_build$/) {
    $gold_ref = MBGD::GOLD->new();
    @gold_field_list = $gold_ref->getFieldList();
}
else {
    @gold_field_list = RecogProjectCommon::getGoldFieldList();
}

my(@disp_gold_field_list);
my($bgcolor) = '#d8f0d8';
foreach my$f (@gold_field_list) {
    next if (!$gold_disp_field_hash{"$f"});

    print "<a id=\"gold_lnk_$f\" href=\"javascript:void(0);\" style=\"background-color:$bgcolor;\" onclick=\"change_gold_field('$f'); return false;\">$f</a>\n";
    $bgcolor = '#b0d2b0';

    push(@disp_gold_field_list, $f);
}
print "<div style=\"display:none;\">\n";
print "<select id=\"gold_sel_field\" name=\"gold_field\">\n";
foreach my$f (@disp_gold_field_list) {
    print "<option value=\"$f\">\n";
}
print "</select>\n";
print "</div>\n";
print "<br>\n";
print "<input type=\"button\" name=\"\" value=\"Clear All GOLD Filters\" onclick=\"clear_gold_field_all(); update_list_spec(this.form);\"><br>\n";
print "<br>\n";

my($gold_info_ref);
if ($mode !~ /^recog_build$/) {
    $gold_info_ref = $gold_ref->getInfo(\@disp_gold_field_list);
}
else {
    $gold_info_ref = RecogProjectCommon::getGoldInfo();
}

my(@all_sp_list) = keys(%{$gold_info_ref});
my($sta_display) = 'inline';
foreach my$f (@disp_gold_field_list) {
    my($gold_field_value) = {};
    foreach my$sp (@all_sp_list) {
        my($val) = $gold_info_ref->{"$sp"}->{"$f"};
        my(@v_list) = ($val);
        if ($gold_multi_val_field_hash{"$f"}) {
            @v_list = split(/\s*,\s*/, $val);
        }
        foreach my$v (@v_list) {
            if ($v !~ /^\s*$/) {
                $gold_field_value->{"$v"}->{"$sp"} = 1;
            }
            else {
                $gold_field_value->{""}->{"$sp"} = 1;
            }
        }
    }

    #
    my(@val_list) = sort(keys(%{$gold_field_value}));
    print "<span id=\"gold_spn_$f\" style=\"display:$sta_display\">\n";
    print "<b>$f</b>\n";
#    print "<input type=\"button\" name=\"\" value=\"Clear\" onclick=\"clear_gold_field('$f'); update_list_spec(this.form); \">";
#    print "<input type=\"text\" name=\"filter_keyword\" value=\"\">\n";
#    print "<input type=\"button\" name=\"\" value=\"Filter\" onclick=\"\">\n";
    print "<br>\n";
    print "<select id=\"gold_sel_$f\" name=\"gold_value_$f\" size=\"12\" style=\"width:100%; min-width:300px;\" onchange=\"update_list_spec(this.form);\" multiple>\n";


    if ($gold_multi_val_field_hash{"$f"}) {
        my(%v_hash);
        foreach my$val (@val_list) {
            my(@v_list) = split(/\s*,\s*/, $val);
            foreach my$v (@v_list) {
                $v_hash{"$v"} = 1;
            }
        }
        @val_list = sort(keys(%v_hash));
    }

    #
    foreach my$val (@val_list) {
        next if ($val eq '');

        my($val_sp) = join(',', keys(%{$gold_field_value->{"$val"}}));
        print "<option value=\"$val_sp\">$val\n";
    }

    my($val_sp) = join(',', keys(%{$gold_field_value->{''}}));
    if ($val_sp ne '') {
        print "<option value=\"$val_sp\">None Assigned\n";
    }
#    print "<input id=\"gold_non_$f\" type=\"checkbox\" name=\"gold_sel_$f\" value=\"$val_sp\" onclick=\"update_list_spec(this.form); \" $sta_non>Select none assigned\n";
    print "</select><br>\n";
    print "</span>\n";

    $sta_display = 'none';
}

print <<EOB;
</div>
EOB
print "</div>\n";


print "</td></tr></table>\n";

if ($mode =~ /^selection$/i) {
    print "You can choose up to $cluster_MAXSP organisms for creating a new classification table.<br>\n";
#   print "You can use the <A HREF=/htbin/create_tax?mode=mbgd&action=cluster> taxonomy browser</A> for the organism selection.<p>";

    print "<INPUT type=hidden NAME=show_summary VALUE=on>\n";
    print "<INPUT type=hidden NAME=initial VALUE=yes>\n";
##  print "<INPUT type=hidden NAME=motif VALUE=on>\n";
    print "<INPUT type=hidden NAME=description VALUE=on>\n";
    print "<INPUT type=hidden NAME=class VALUE=on>\n";
    print "<INPUT type=hidden NAME=cons_gene VALUE=on>\n";

    if (@species >= 0) {
        my($refUserInfo) = MbgdUserGenomeCommon::loadUserInfo($uid);
        my($email) = $refUserInfo->{'email_clustering'};
        if (! $email) {
            $email = $refUserInfo->{'email'};
        }
        $email = '' if ($email eq $uid);
        my($staChecked) = '';
        if ($email !~ /^\s*$/) {
            $staChecked = 'checked';
        }

        #
        foreach my $sp (&MBGD_SpecTableGetDefaultSpecies()) {
            next if (MbgdUserGenomeCommon::isUserGenome($sp));    # default $B$+$i(B UserGenome $B$r=|5n(B
            push(@deforg, $sp);
        }
        $default_orgs = '"' . join('","', @deforg)  . '"';
        $all_orgs     = '"' . join('","', @AllSpec) . '"';

        print<<EOB;
<input type="checkbox" name="receive_email" value="yes" $staChecked>
Send me an e-mail when the clustering process is finished.<br>
E-mail : <input type="text" name="email" value="$email" size="30">
<br>
<br>
<script defer="defer">
function setDefault() {
    var doc = document;
    var frm = doc.specForm;

    var add_spec = new Object();
    var del_spec = new Object();
    var deforg = new Array( $default_orgs );
    var n = deforg.length;
    for (var i = 0; i < n; i++) {
        var sp = deforg[i];
        add_spec[sp] = 1;
    }

    //
    remove_all_species(frm.selected_species);
    mod_selected_species(frm.species_all, frm.selected_species, add_spec, del_spec);

    return;
}

function isDefault(document) {
    var document = this.document;

    var deforg = new Array( $default_orgs );
    var deforg2 = new Array( deforg.length );
    for (var i = 0; i < deforg.length; i++) {
        deforg2[ deforg[i] ] = 1;
    }

    var nDefaultSpec = 0;
    for (var i = 0; i < document.specForm.species_list.options.length; i++) {
        if (document.specForm.species_list.options[i].selected) {
            if (deforg2[ document.specForm.species_list.options[i].value ] == 1) {
                // default spec
                nDefaultSpec++;
            }
            else {
                return false;
            }
        }
    }

    if (deforg.length != nDefaultSpec) {
        return false;
    }

    return true;
}

function isAll(document) {
    var document = this.document;

    var allorg = new Array( $all_orgs );
    var allorg2 = new Array( allorg.length );
    for (var i = 0; i < allorg.length; i++) {
        allorg2[ allorg[i] ] = 1;
    }

    var nSpec = 0;
    for (var i = 0; i < document.specForm.species_list.options.length; i++) {
        if (document.specForm.species_list.options[i].selected) {
            if (allorg2[ document.specForm.species_list.options[i].value ] == 1) {
                nSpec++;
            }
            else {
                return false;
            }
        }
    }

    if (allorg.length != nSpec) {
        return false;
    }

    return true;
}

//
selectedUserGenome = false;
function chkSelectedSpecies() {
    var f = this.document.specForm;
    var i;

    selectedUserGenome = false;
    var n = f.selected_species.length;
    for(i = 0; i < n; i++) {
        if (isUserGenome(f.selected_species.options[i].value)) {
            selectedUserGenome = true;
        }
    }

    if (n == 0) {
        var msg = 'Error: no organism is selected.\\n'
                + 'Choose a set of organisms in the central organism list and press [Add] button.';
        alert(msg);
        return false;
    }
    else if (isDefault()) {
        // this is default species set.
    }
    else if (isAll()) {
        // this is all species set.
    }
    else if (f.sta_login_mymbgd.value == 'TRUE') {
        if (selectedUserGenome != true) {
            alert('Please select User Genome');
            return false;
        }
        if ($cluster_MAXSP_MyMBGD < n) {
            msg = 'Total ' + n + ' species selected.' + '\\n' + 'Max : ' + $cluster_MAXSP_MyMBGD + ' Genomes';
            alert(msg);
            return false;
        }
    }
    else {
        if ($cluster_MAXSP < n) {
            msg = 'Total ' + n + ' species selected.' + '\\n' + 'Max : ' + $cluster_MAXSP + ' Genomes';
            alert(msg);
            return false;
        }
    }

    return true;
}

function chkEmail() {
    var f = this.document.specForm;

    if (f.receive_email.checked && f.email.value.match(/^\\s*\$/)) {
        alert('Please input your E-mail.');
        f.email.focus();
        return false;
    }

    return true;
}
function doSubmit() {
    var doc = this.document;
    var sta;

    //
    sta = chkSelectedSpecies();
    if (! sta) {
        return;
    }

    //
    sta = chkEmail();
    if (! sta) {
        return;
    }

    var n = this.document.specForm.selected_species.length;
    var opts = this.document.specForm.selected_species;
    for (var i = 0; i < n; i++) {
        opts[i].selected = true;
    }
    this.document.specForm.submit();
}
</script>
EOB
    }

    print q{<INPUT type="button" name="organism_selection" value="Execute Clustering" onclick="doSubmit();">};
}
elsif ($mode =~ /^simpat$/i) {
    print q{<INPUT type="button" name="organism_selection" value="Set occurrence pattern" onclick="set_occurrence_pattern(); ">};
}
elsif ($mode =~ /^color$/i) {
    print q{<INPUT type="button" name="organism_selection" value="Save organisms color" onclick="save_species_color(); ">};
}
elsif ($mode =~ /^recog_build$/i) {
    my($project_id) = $Args{'project_id'};
    print qq{<input type="hidden" name="project_id" value="$project_id">};
    print q{<input type="button" name="organism_selection" value="Select species" onclick="select_public_species();">};
}
else {
}

print "</FORM>\n";

if ($mode =~ /^selection$/i) {
    print "<hr>\n";
    print "<FORM METHOD=\"POST\" ACTION=\"/htbin/SetParamScreen.pl\">\n";
    print "<INPUT TYPE=submit VALUE=\"Change Homology Paramters\">\n";
    print "</FORM>\n";

    print "<FORM METHOD=POST ACTION=\"/htbin/SetDefaultParam.pl\">\n";
    print "<INPUT TYPE=submit VALUE=\"Clear Organism and Set Default Value\">\n";
    print "</FORM>\n";
}
elsif ($mode =~ /^color$/i) {
    print "<script>\n";
    print "upd_species_color();\n";
    print "</script>\n";
}

if ($mode !~ /^(recog_build)$/) {
    $WWW->page_footer;
    $WWW->end_html;
}
exit;

###############################################################################
#
sub check {
    ($a, $b, $ret) = @_;
    return $ret if ($a eq $b);
    return '';
}

###############################################################################
1;#
###############################################################################
