#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use File::Path;
use MBGD::WWW;
use MbgdUserGenomeCommon;
require 'InfoSpec.pl';

###############################################################################
#
sub modUserGenome {
    my($uid) = shift;
    my($formOpt) = shift;

    if ($formOpt->{'id_user_genome'} <= 0) {
        #  UserGenome ---> ID ȯ
        $formOpt->{'id_user_genome'} = MbgdUserGenomeCommon::getNewUserGenomeId($uid);
        if (! $formOpt->{'id_user_genome'}) {
            # ȯֽʤ ---> ¸ UserGenome Ƥ餦

            return;
        }
    }

        #
        my($spidUg) = MbgdUserGenomeCommon::getUserGenomeSpid($formOpt->{'id_user_genome'});
        my($specUg);
	if ($formOpt->{sp}) {
		$specUg = $formOpt->{sp};
	} else {
 		$specUg = MbgdUserGenomeCommon::getUserGenomeSpec($formOpt->{'id_user_genome'});
	}
        my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab";
        my($spid_tab_ref) = getInfoSpecTab($file_spid_tab);
        if (!exists($spid_tab_ref->{'NAME2DIR'}->{"$specUg"})) {
            my($spidDir) = "$ENV{'MBGD_HOME'}/species/$spidUg";
            my($specDir) = "$ENV{'MBGD_HOME'}/species/$spidUg";
            addInfoSpecTabEntry($spid_tab_ref, $spidUg, $specUg, $spidDir);
            setInfoSpecTab($file_spid_tab, $spid_tab_ref);

            mkpath("$specDir", 0, 0750);
#            symlink($specDir, $spidDir);
        }

    #
    my($idUserGenome) = $formOpt->{'id_user_genome'};

    # UserGenome ¸
    MbgdUserGenomeCommon::saveUserGenomeInfo($uid, $formOpt);
    MbgdUserGenomeCommon::convUserGenome_ug_txt($uid, $idUserGenome);

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mymbgd.css" type="text/css" />
<script language="JavaScript" src="/js/mymbgd.js"></script>
<script>
function isChanged() {
    return isChangedFormData(this.document);
}

</script>
</head>

<body onload="updateUserGenomeList($idUserGenome);">

<form>
Saved.<br>
<input type="button" value="Ok" onclick="updateUserGenome($idUserGenome);">
</form>

</body>
</html>
EOB

}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    my($key);

    #
    my($cgi) = new CGI();

    my($formOpt) = {};

    foreach $key (@MbgdUserGenomeCommon::LST_KEY_GENOME) {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    modUserGenome($uid, $formOpt);
}
###############################################################################
1;#
###############################################################################
