#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::WWW;
use MbgdUserGenomeCommon;

###############################################################################
#
sub modUserGenomeWin {
    my($uid) = shift;
    my($formOpt) = shift;

    #
    my($refUserGenome) = {};
    my($loadUserChromosome) = '';
    my($idUserGenome) = $formOpt->{'id_user_genome'};
    if ($idUserGenome == 0) {
        $idUserGenome = MbgdUserGenomeCommon::getFirstUserGenomeId($uid);
    }

    my($userGenomeNo) = '[NEW]';
    if ($idUserGenome > 0) {
        # ϿѤߤ UserGenome ɤ߹
        $refUserGenome = MbgdUserGenomeCommon::loadUserGenomeInfo($uid, $idUserGenome);

        #
        my($idUserChromosome) = MbgdUserGenomeCommon::getFirstUserChromosomeId($uid, $idUserGenome);
        $loadUserChromosome = "loadUserChromosome($idUserGenome, '$idUserChromosome');";

        $userGenomeNo = "#$idUserGenome";
    }
    my(%type_selected);
    $type_selected{$refUserGenome->{type}} = 'selected';

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mymbgd.css" type="text/css" />
<script language="JavaScript" src="/js/mymbgd.js"></script>
<script>
function isChanged() {
    return isChangedFormData(this.document);
}

function checkInputGenomeInfo() {
    var f = this.document.formUserGenome;
    var elm;
    var txt;

    elm = f.species_name;
    txt = 'Species Name';
    trim(elm);
    if (elm.value == '') {
        alert('Please input ' + txt);
        elm.focus();
        return false;
    }

    elm = f.abbreviation_name;
    txt = 'Abbreviation Name';
    trim(elm);
    if (elm.value == '') {
        alert('Please input ' + txt);
        elm.focus();
        return false;
    }

//    elm = f.strain;
//    txt = 'Strain';
//    trim(elm);
//    if (elm.value == '') {
//        alert('Please input ' + txt);
//        elm.focus();
//        return false;
//    }

    elm = f.taxonomy_id;
    txt = 'Taxonomy ID';
    trim(elm);
    if (elm.value == '') {
        alert('Please input ' + txt);
        elm.focus();
        return false;
    }

    return true;
}

function submitUserGenome() {
    var sta;

    sta = checkInputGenomeInfo();
    if (! sta) {
        return;
    }

    this.document.formUserGenome.submit();
}
</script>
</head>

<body onload="saveFormData(this.document); $loadUserChromosome">

<form name="formUserGenome" method="post" action="/htbin/recog_build/modUserGenome.cgi">

<table bgcolor="#007000" width="100%">
<tr><td><font color="#e8f8e8">User Genome $userGenomeNo</font></td>
</tr>
<tr><td>
<table bgcolor="#e8f8e8" width="100%" border>
<tr><th nowrap>
        Species Name<br/>
        (e.g. Escherichia coli)</th>
    <td nowrap>
        <input type="text" name="species_name" value="$refUserGenome->{'species_name'}" size="40"></td>
</tr>

<tr><th nowrap>
        Abbreviation Name<br/>
        (e.g. E.coli)</th>
    <td nowrap>
        <input type="text" name="abbreviation_name" value="$refUserGenome->{'abbreviation_name'}" size="40">
        <input type="button" value="Set" onclick="setShortName(species_name, abbreviation_name);"></td>
</tr>

<tr><th nowrap>
        Species code (3-5 letters)<br/>
        (e.g. eco)</th>
    <td nowrap>
        <input type="text" name="sp" value="$refUserGenome->{'sp'}" size="40">
</tr>

<tr><th nowrap>Strain</th>
    <td nowrap>
        <input type="text" name="strain" value="$refUserGenome->{'strain'}" size="40"></td>
</tr>

<tr><th nowrap>Taxonomy ID</th>
    <td nowrap>
        <input type="text" name="taxonomy_id" value="$refUserGenome->{'taxonomy_id'}" size="10">
        <input type="button" name="" value="Search the NCBI Taxonomy DB" onclick="searchTaxonomyId(species_name, abbreviation_name);">
    </td>
</tr>

<tr><th nowrap>Data Type</th>
    <td nowrap>
        <select name="type">
        <option value="complete" $type_selected{complete}d>Complete Genome</option>
        <option value="incomplete" $type_selected{incomplete}>Incomplete Genome</option>
        <option value="partial" $type_selected{partial}>Partial Sequence/Transcriptome</option>
        <option value="metagenome" $type_selected{metagenome}>Metagenome</option>
	</select>
</table>
</td></tr>
</table>

<div id="btn">
<input type="button" name="" value="Save" onclick="submitUserGenome();">
</div>

<input type="hidden" name="id_user_genome" value="$idUserGenome">
</form>

</body>
</html>
EOB

}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    my($key);

    #
    my($cgi) = new CGI();

    my($formOpt) = {};

    $key = 'id_user_genome';
    $formOpt->{"$key"} = $cgi->param($key);

    modUserGenomeWin($uid, $formOpt);

    exit(0);
}
###############################################################################
1;#
###############################################################################
