#!/usr/bin/perl -s
use strict;
use CGI;
use File::Path;
use MBGD::DB;
use RecogProjectCommon;
require "MBGD_Conf.pl";
require "InfoSpec.pl";

###############################################################################
sub organism_selection_recog_save {
    my($formOpt) = shift;

    #
    print "Content-type: text/html\n";
    print "\n";

    my($user) = $ENV{'REMOTE_USER'};
    my($proj_id) = $formOpt->{'project_id'};
    my($spec_list) = $formOpt->{'selected_species'};

    #
    my($proj_ref) = RecogProjectCommon::get_project($proj_id);
    if (!$proj_ref) {
        # NOT found project
        print "<h2>Found no project.</h2>\n";
        print "$proj_id\n";
        return;
    }

    my($proj_name) = $proj_ref->{'NAME'};
    my(@spid_list) = @{$proj_ref->{'SPID_LIST'}};
    my(%spid_hash);
    foreach my$spid (@spid_list) {
        next if ($spid =~ /^gm\d+$/);

        $spid_hash{"$spid"} = 1;
    }

    #
    my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab.dist";
    my($spid_dist_ref) = getInfoSpecTab($file_spid_tab);

    foreach my$spec (split(/,/, $spec_list)) {
        my($spid) = $spid_dist_ref->{'NAME2SPID'}->{"$spec"};
        $spid_hash{"$spid"} = 1;
    }
    my(@spid_list) = sort(keys(%spid_hash));

    #
    RecogProjectCommon::set_project($proj_id,
                                    $proj_ref->{'descr'},
                                    @spid_list);
    print "<h2>Updated</h2>\n";

    print qq{<form>\n};
    print qq{<input type="button" name="btn_close" value="close" onclick="close(); ">\n};
    print qq{</form>\n};

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    my($key) = 'selected_species';
    $formOpt->{"$key"} = join(",", $cgi->param($key));

    my($key) = 'project_id';
    $formOpt->{"$key"} = join(",", $cgi->param($key));

    #
    organism_selection_recog_save($formOpt);
}

###############################################################################1;#
###############################################################################
