#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use MBGD::DB;
use RecogBuild;
use RecogProjectCommon;

###############################################################################
#
sub select_user_genome {
    my($formOpt) = shift;

    my($user) = $ENV{'REMOTE_USER'};
    my($proj_id) = $formOpt->{'project_id'};

    #
    my($proj_ref) = RecogProjectCommon::get_project($proj_id);
    my($proj_name) = $proj_ref->{'NAME'};
    my(@spid_list) = @{$proj_ref->{'SPID_LIST'}};
    my(%spid_hash);
    foreach my$spid (@spid_list) {
        next if ($spid =~ /^gu\d+$/);

        $spid_hash{"$spid"} = 1;
    }

    #
    my($dir) = "$ENV{'RECOG_HOME'}/species";
    foreach my$spid (@{$formOpt->{'spid'}}) {
        next if ($spid !~ /^gu\d+$/);

        my($dir) = "$ENV{'RECOG_HOME'}/species/$spid";
        if (! -d $dir) {
            next;
        }

        $spid_hash{"$spid"} = 1;
    }
    my(@spid_list) = sort(keys(%spid_hash));
    RecogProjectCommon::set_project_spid($proj_id,
                                         @spid_list);

    #
    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/mymbgd.js"></script>
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
<script>
</script>
</head>

<body>

<h1>Select user genome</h1>

Done.<br>

</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('project_id') {
        $formOpt->{"$key"} = $cgi->param($key);
    }
    my($key) = 'spid';
    $formOpt->{"$key"} = [];
    push(@{$formOpt->{"$key"}}, $cgi->param($key));

    select_user_genome($formOpt);
}

###############################################################################
1;#
###############################################################################
