#!/usr/bin/perl -s
use strict;

sub update_kegg_orgs_win {
    print "Content-type: text/html\n";
    print "\n";

    my($dir) = "$ENV{'RECOG_HOME'}/database.work";
    my($file_kegg_orgs) = "$dir/kegg_org_list.html";
    my($tm_kegg_orgs) = 'Not found';
    if (-e $file_kegg_orgs) {
        my(@stat_list) = stat($file_kegg_orgs);
        my($sec, $min, $hour, $mday, $mon, $year) = localtime($stat_list[9]);
        $year += 1900;
        $mon++;
        $tm_kegg_orgs = sprintf("%04d/%02d/%02d", $year, $mon, $mday);
    }

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>

<body>

<div id="id_msg">
<h1>Update KEGG Organisms</h1>
Download KEGG Organisms from <a href="http://www.genome.jp/kegg/catalog/org_list.html">www.genome.jp</a><br />
<p>
timestamp : $tm_kegg_orgs<br>
</div>

<form name="frm_update_kegg_orgs" method="post">
<input type="button" name="btn_update_kegg_orgs" value="Update" onclick="update_kegg_orgs();">
</form>
</body>
</html>
EOB

    return;
}

################################################################################
if ($0 eq __FILE__) {
    update_kegg_orgs_win();
}
1;#
