#!/usr/bin/perl -s
use strict;
use CGI;
use FileHandle;
use RecogBuild;
require "MBGD_Conf.pl";
require "InfoSpec.pl";

###############################################################################
sub exec_mirror_spid {
    my(@spid_list) = @_;

    my(@upd_spid_list);
    foreach my$spid (@spid_list) {
        next if ($spid !~ /^gm\d+$/);

        push(@upd_spid_list, $spid);
    }

    my($cmd) = "$ENV{'MBGD_HOME'}/build/mirrorSpidData.pl @upd_spid_list";
    system("$cmd");

    return;
}

###############################################################################
sub update_mysql_species {
    my($formOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($name) = 'upd-species';
    my($cgi) = "/htbin/recog_build/update_mysql_species.cgi";
    my($file_pid) = "$ENV{'RECOG_HOME'}/etc/$name.pid";
    my($file_err) = "$ENV{'RECOG_HOME'}/etc/$name.err";
    my($file_sta) = "$ENV{'RECOG_HOME'}/etc/$name.sta";
    my($t) = $formOpt->{'t'};
    $t = int($t * 1.2);
    if (60 < $t) {
        $t = 60;
    }

    #
    my($pid) = $formOpt->{'pid'};
    if ($pid) {
        my($sta) = kill(0 => $pid);
        if ($sta) {
            # running!
            RecogBuild::print_html_running_update($name, $cgi, $pid, $t, $file_sta);
        }
        else {
            # finished
            my($msg) = '';
            if (-e $file_err) {
                # Found err
                my($fh) = FileHandle->new("$file_err");
                $msg = join("<br>", $fh->getlines());
                $fh->close();
            }
            RecogBuild::print_html_finished_update($name, $msg);
        }
        exit(0);
    }

    #
    if (-e $file_pid) {
        my($fh) = FileHandle->new("$file_pid") || die("Can not open $file_pid($!)");
        $pid = $fh->getline();
        $pid =~ s#[\r\n]*$##;
        $fh->close();

        my($sta) = kill(0 => $pid);
        if (!$sta) {
            # NOT found :: PID=$pid
            unlink("$file_pid");
        }
        else {
            RecogBuild::print_html_running_update($name, $cgi, $pid, $t);
            exit(0);
        }
    }

    #
    my($pid) = fork();
    if ($pid) {
        sleep(2);
        RecogBuild::print_html_running_update($name, $cgi, $pid, $t);
        exit(0);
    }

    my($recog_proj_ref) = RECOG::RecogProject->new();

    # download local-spec and base-cluster-spec
#    my(@all_spid_list) = $recog_proj_ref->get_spid_list_all($user);
    my(@all_spid_list) = $recog_proj_ref->get_spid_list_all_base_cluster($user);
    if (scalar(@all_spid_list) != 0) {
        my($fileSpidDist) = "$main::FILE_spidtab.dist";
        my($refSpidDist) = getInfoSpecTab($fileSpidDist);
        my($fileSpidTab) = "$main::FILE_spidtab";
        my($refSpidTab) = getInfoSpecTab($fileSpidTab);

        foreach my$spid (@all_spid_list) {
            copyInfoSpecTabEntry($refSpidDist, $refSpidTab, $spid);
        }
        setInfoSpecTab($fileSpidTab, $refSpidTab);
    }

    my(@no_download_spid) = RecogBuild::check_nodownload_species(@all_spid_list);
    print STDERR "LOG :: Download :: @no_download_spid\n";

    #
    close(STDIN);
    close(STDOUT);
#    close(STDERR);

    #
    if (!-e $file_pid) {
        my($fh) = FileHandle->new(">$file_pid") || die("Can not open $file_pid($!)");
        $fh->print($$, "\n");
        $fh->close();
    }
    unlink($file_err);

    #
    unlink(<$ENV{'RECOG_HOME'}/work/.m05*>);
    unlink(<$ENV{'RECOG_HOME'}/work/.m10*>);
    unlink(<$ENV{'RECOG_HOME'}/work/.m11*>);
    unlink(<$ENV{'RECOG_HOME'}/work/.m12*>);

    #
    exec_mirror_spid(@no_download_spid);

    #
    my($execOpt);
    if ($formOpt->{force_rebuild_insert}) {
    	unlink(<$ENV{'MBGD_HOME'}/work/.m042*>);
    }
    if ($formOpt->{force_rebuild_extract}) {
    	unlink(<$ENV{'MBGD_HOME'}/work/.m04[5-9]*>);
    }
    # Force to re-execute from m0450 to m0490
    if (! $formOpt->{useChkpnt})  {
	unlink(<$ENV{'MBGD_HOME'}/work/.m0400*>);
	$formOpt->{date} = '';
    }
    if ($formOpt->{date}) {
	$execOpt .= " -DATE=$formOpt->{date}";
    }
    my($cmd) = "$ENV{'MBGD_HOME'}/build/m0400InsertSpecInfo.pl -FILE_STA=$file_sta $execOpt";
    system("$cmd");

    unlink($file_pid, $file_sta);

    return;
}

################################################################################
if ($0 eq __FILE__) {
    my($cgi)  = CGI->new();

    my($formOpt) = {};
    foreach my$key ('pid', 't', 'useChkpnt', 'date', 'force_rebuild_insert', 'force_rebuild_extract') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    update_mysql_species($formOpt);
}
1;#
