#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RECOG::RecogProject;
use RecogProjectCommon;

###############################################################################
sub create_user {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if (!$sta_sysadm) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($msg);
    my($id);
    my($user_name) = $form_opt->{'user_name'};
    my($is_valid_name) = $auth->validate_user_name($user_name);
    my($sta) = $auth->exists_user($user, $user_name);
    if (!$user_name || !$is_valid_name) {
        $msg = "Sorry, invalid user name. [$user_name]\n";
    }
    elsif ($sta) {
        # Found user!
        $msg = "Already exists. [$user_name]";
    }
    else {
        #
        my($user_pass1) = $form_opt->{'user_pass1'};
        my($user_pass2) = $form_opt->{'user_pass2'};
        if ($user_pass1 ne $user_pass2) {
            $msg = "Not same password. [$user_name]";
        }
        elsif ($user_pass1 =~ /^\s*$/) {
            $msg = "Blank password. [$user_name]";
        }
        else {
            my($user_name) = $form_opt->{'user_name'};
            $id = RecogProjectCommon::create_user($user_name,
                                                  $user_pass1);
            $msg = "Success.";
        }
    }

    print "Content-type: text/html\n";
    print "\n";
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print <<EOB;
<script>
this.top.opener.location.reload();
</script>
EOB
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="text-align:right;">[ $user ]</div>\n};
    print "<h1>Create user</h1>\n";
    print $msg, "<br>\n";
    print qq{<input type="button" name="btn_close" value="Close" onclick="self.close();">\n};
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('user_name',
                    'user_pass1',
                    'user_pass2',
                   ) {
        $form_opt->{"$key"} = $cgi->param($key);
    }
    create_user($form_opt);
}

###############################################################################
1;#
###############################################################################
