#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;

###############################################################################
sub delete_project {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_DEL_PRJ);
    if (!$sta_sysadm) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($project_id) = $form_opt->{'project_id'};

    #
    $auth->del_project($user, $project_id);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print <<EOB;
<script>
this.top.opener.location.reload();
</script>
EOB
    print "</htad>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Delete project</h1>\n";

    #
    print "Done.<br>\n";
    print qq{<input type="button" name="btn_close" value="Close" onclick="window.close();">};
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('project_id') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    delete_project($form_opt);
}

###############################################################################
1;#
###############################################################################
