#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RECOG::RecogProject;
use RecogProjectCommon;

###############################################################################
sub edit_user {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($user_name) = $form_opt->{'user_name'};

    #
    my($auth) = RECOG::RecogProject->new();
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if ((!$sta_sysadm) && ($user ne $user_name)) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($user_ref) = RecogProjectCommon::get_user_info($user_name);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print <<EOB;
<script>
this.top.opener.location.reload();
</script>
EOB
    print "</htad>\n";
    print "<body>\n";
    print "<h1>Edit user</h1>\n";

    #
    if (!$user_ref) {
        print "Sorry, found no user.";
        print "</body>\n";
        print "</html>\n";

        return;
    }
    elsif (!$sta_sysadm && ($user ne $user_name)) {
        print "Sorry, can not edit '$user_name'.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    #
    $user_ref->{'organization'} = $form_opt->{'user_organization'};
    RecogProjectCommon::set_user_info($user_name, $user_ref);

    #
    print "Done.<br>\n";
    print qq{<input type="button" name="btn_close" value="Close" onclick="window.close();">};
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('user_name', 'user_organization') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    edit_user($form_opt);
}

###############################################################################
1;#
###############################################################################
