#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub get_project_cluster {
    my($form_opt) = shift;
    my($user_name) = $ENV{'REMOTE_USER'};

    #
    my($dbname) = $main::DBNAME_RECOG;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    #
    my($uid) = RecogProjectCommon::exists_user_name($user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($proj_id)    = $form_opt->{'proj_id'};
    my($clusttabid) = $form_opt->{'clusttabid'};
    my($name)       = $form_opt->{'name'};

    $proj_id = RecogProjectCommon::conv_proj_id($proj_id);

    #
    my($tab) = "project_domclust";
    my($where) = "proj_id=? and clusttabid=? and name=?";
    my($sql) = "select * from $tab where $where";
    my($sth) = $db->prepare($sql);
    $sth->execute($proj_id, $clusttabid, $name);
    my($ref) = $sth->fetchrow_hashref();
    my($view_opts) = $ref->{'view_opts'};
#    $view_opts =~ s#([^a-z0-9])#sprintf("%%%02x", ord($1))#gei;

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);
    print $view_opts;

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('proj_id', 'clusttabid', 'name');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    get_project_cluster($form_opt);
}

###############################################################################
1;#
###############################################################################
