#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub print_html {
    my($user_ref) = shift;

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print "<h1>View User</h1>\n";

    #
    if (!$user_ref) {
        print "Sorry, found no user.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    print <<EOB;
<table border>
<tr><th>e-mail</th>
    <td>$user_ref->{'email'}</td>
</tr>

<tr><th>Organization</th>
    <td>$user_ref->{'organization'}</td>
</tr>

</table>
</body>
</html>
EOB

    return;
}

###############################################################################
#
sub print_text {
    my($user_ref) = shift;

    #
    print "Content-type: text/plain\n";
    print "\n";

    #
    if (!$user_ref) {
        return;
    }

    foreach my$key ('name', 'descr', 'email', 'organization') {

        my($val) = $user_ref->{"$key"};
        $val = RecogProjectCommon::percent_encoding($val);
        print $key, "\t", $val, "\n";
    }

    return;
}

###############################################################################
sub view_user {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($user_ref) = RecogProjectCommon::get_user_info($form_opt->{'user_id'});

    #
    if ($form_opt->{'mode'} =~ /^text$/i) {
        print_text($user_ref);
    }
    else {
        print_html($user_ref);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('mode', 'user_id') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    view_user($form_opt);
}

###############################################################################
1;#
###############################################################################
