#!/usr/bin/perl -s

use File::Path;
use FileHandle;
use POSIX ":sys_wait_h";

################################################################################
# multi-FASTA Ϥ줿 pfsearch ˤ
#
# ɤ Accession number Υǡ˥ޥåΤ뤿
# prosite.dat  MATRIX ǡñ̤ pfsearch ư
#
# ա
# pfsearch ϡΥե̾Ĺ 64 ʸޤǤȤ¤ޤ
# ǡΥץȤǤϡMATRIX ǡե /tmp ˺
# ǡɸϤϤ褦ˤƤޤ
################################################################################

$CMD_PFSEARCH = "/bio/bin/pfsearch";
$PROFILE = "/bio/db/ideas/prosite/prosite.dat" if (! defined($PROFILE));

$PROCNUM = 6;

if (scalar(@ARGV) < 1) {
    die "Usage : $0 [-PROFILE=profile-file] sequence-file";
}
@SeqFiles = @ARGV;

$fh = new FileHandle($PROFILE);

$fileOutputDir = "/tmp/pfsearch.$$";
$fileMatrix = "$fileOutputDir/matrix.$$";
$fileOutput = "$fileOutputDir/result";
$flagMatrix = 0;
$skip_flag = 0;

mkpath($fileOutputDir);

while($line = <$fh>) {
    if ($line =~ /^ID\s+(\w+);\s+(\w+)/) {
	$motname = $1;
	$mottype = $2;
	if ($mottype eq 'MATRIX') {
        	$flagMatrix = 1;
	} else {
        	$flagMatrix = 0;
	}
	$skip_flag = 0;
	$matrix_data = '';
    } elsif ($line =~ /^AC\s+(\w+)/) {
	$motacc = $1;
    } elsif ($line =~ /^CC.*\/SKIP-FLAG=TRUE/) {
	$skip_flag = 1;
    }

    if ($flagMatrix) {
	$matrix_data .= $line;
    }
    if ($line =~ m#^//#
		&& $flagMatrix && ! $skip_flag) {
	$matfile = "${fileMatrix}_${motacc}";
       	open(MATRIX, "> $matfile") || die "Can not open $matfile($!)";
	print MATRIX $matrix_data;
        close(MATRIX);
	push(@MotAccs, $motacc);
        $flagMatrix = 0;
	$skip_flag = 0;
	$matrix_data = '';
    }
}
$fh->close;

foreach $motacc (@MotAccs) {
	my $matfile = "${fileMatrix}_${motacc}";
        my $cmd = "$CMD_PFSEARCH -f -x $matfile -";
        foreach $seqFile (@SeqFiles) {
            &execSearch("$cmd", $seqFile, "$fileOutput.$motacc");
        }
}

## waiting for all processes to be finished
&wait_procs(1);

opendir(DIR, $fileOutputDir);
while ($f = readdir(DIR)) {
	next if ($f !~ /^result/);
	if (! -z "$fileOutputDir/$f") {
		($motacc) = ($f =~ /result.(.*)/);
		print "AC $motacc;\n";
		open(F, "$fileOutputDir/$f");
		while (<F>) {
			print;
		}
		print "//\n";;
	}
}
rmtree($fileOutputDir);

exit;

sub execSearch {
	my($cmd, $infile, $outfile) = @_;
	&wait_procs($PROCNUM);
	if (my $chpid = fork) {
		$CurrProc{$chpid} = 1;
	} else {
		$fh->close();
		system("$cmd < $infile >> $outfile");
		exit(0);
	}
}
sub wait_procs {
	my($MaxProcnum) = @_;
	while ((@currproc = keys %CurrProc) >= $MaxProcnum) {
		foreach my $pid (@currproc) {
			if (my $found_pid =
				POSIX::waitpid($pid, &POSIX::WNOHANG)){
				delete $CurrProc{$found_pid};
			}
		}
		sleep 2;
	}
}

################################################################################
1;#
################################################################################

