#!/usr/bin/perl -s
use strict;
use File::Basename;
use DirHandle;
use FileHandle;

###############################################################################
#
sub print_usage {
    print STDERR <<EOB;

Usage :: $0 [-force] spid1 [spid2 ]

EOB

    return;
}

###############################################################################
#
sub convertDna2GeneSeq_file {
    my($spid) = shift;
    my($file_gene) = shift;
    my($file_chrseq) = shift;
    my($file_geneseq) = shift;

    #
    my($fh_gene)    = FileHandle->new("$file_gene");
    if (!$fh_gene) {
        print STDERR "ERROR :: Can not open $file_gene($!)\n";
        return;
    }
    my($fh_chrseq)  = FileHandle->new("$file_chrseq");
    if (!$fh_chrseq) {
        print STDERR "ERROR :: Can not open $file_chrseq($!)\n";
        return;
    }
    my($fh_geneseq) = FileHandle->new(">$file_geneseq");
    if (!$fh_geneseq) {
        print STDERR "ERROR :: Can not open $file_geneseq($!)\n";
        return;
    }

    #
    my($chrseq) = '';
    while (my$line=$fh_chrseq->getline()) {
        next if ($line =~ /^\s*\>/);
        $line =~ s#[\r\n]*$##;

        $chrseq .= $line;
    }
    $fh_chrseq->close();

    #
    $chrseq = lc($chrseq);
    while (my$line=$fh_gene->getline()) {
        $line =~ s#[\r\n]*$##;
        my($id, $name, $from1, $to1, $dir1, $type) = split(/\t/, $line);
        next if (!$from1 && !$to1);

        my($pos) = $from1 - 1;
        my($len) = $to1 - $from1 + 1;
        my($seq) = substr($chrseq, $pos, $len);
        if ($dir1 < 0) {
            $seq = reverse($seq);
            $seq =~ tr/u/a/;
            $seq =~ tr/acgtyrkmbdhv/tgcarymkvhdb/;
        }
        $seq =~ s#(.{1,60})#$1\n#g;

        $fh_geneseq->print(">$spid:$id\n");
        $fh_geneseq->print($seq);
    }

    #
    $fh_gene->close();
    $fh_geneseq->close();

    return;
}

###############################################################################
#
sub convertDna2GeneSeq {
    my($spid) = shift;

    my($dir) = sprintf("%s/species/%s/gm/data", $ENV{'MBGD_HOME'}, $spid);
    my($dh) = DirHandle->new("$dir");
    if (!$dh) {
        print STDERR "Not found $spid\n";
        return;
    }

    while (my$file=$dh->read()) {
        next if ($file !~ /\.gene$/);
        my($file_base) = basename($file, ".gene");

        my($file_gene)    = sprintf("%s/%s.gene",    $dir, $file_base);
        my($file_chrseq)  = sprintf("%s/%s.chrseq",  $dir, $file_base);
        my($file_geneseq) = sprintf("%s/%s.geneseq", $dir, $file_base);
        if (!$main::force && -s $file_geneseq) {
            print STDERR "WARNING :: SKIP :: File size is not 0.($file_geneseq)\n";
            next;
        }
        if (! -e $file_chrseq) {
            print STDERR "WARNING :: SKIP :: Not found $file_chrseq.\n";
            next;
        }
        convertDna2GeneSeq_file($spid, $file_gene, $file_chrseq, $file_geneseq);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    foreach my$spid (@ARGV) {
        convertDna2GeneSeq($spid);
    }
}
###############################################################################
1;
###############################################################################
