#!/usr/bin/perl -s
use strict;
use FileHandle;

sub filter_ftp_list {
    my($filename) = shift;
    my($fh) = FileHandle->new("$filename") || croak("Can not open $filename($!)");
    while(my$line = $fh->getline()) {
        my($name) = ($line =~ /(\d[^\s]+\.goa)/);

        next if (! $name);

        print "$name\n";
    }
    $fh->close();

    return;
}


if ($0 eq __FILE__) {
    foreach my$file (@ARGV) {
        filter_ftp_list($file);
    }
}
1;
