#!/usr/bin/perl -s
use strict;
use File::Path;
use FileHandle;
require "MBGD_common.pl";

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 [-DIR=dir] FILE_cdd.tar.gz\n";
}

###############################################################################
#
sub createUniprotDb {
    my($dirUniprot) = shift;
    my($dirGoa) = shift;

    #
    if ($main::DOWNLOAD) {
        chdir($dirUniprot);

        my($fileSprot) = "uniprot_sprot.dat.gz";
        if (-e "$fileSprot") {
            $cmd = "$main::CMD_cp -p $fileSprot $fileSprot.bak";
            system("$cmd");
        } else {
            new FileHandle(">$fileSprot.bak");
        }

        print STDERR "Download :: uniprot_sprot.dat.gz\n";
        my($url) = "ftp://ftp.uniprot.org/pub/databases/uniprot/current_release/knowledgebase/complete/uniprot_sprot.dat.gz";
        $cmd = "$main::CMD_curl -L -O $url";
        system("$cmd");

        #
        $cmd = "$main::CMD_cmp -s $fileSprot $fileSprot.bak";
        my$sta = system("$cmd");
        unlink("$fileSprot.bak") if (-e "$fileSprot.bak");
        if (($sta >> 8) == 0) {
#            print "Found no changes.\n";
#            exit(0);
        }

        my($fileTrembl) = "uniprot_trembl.dat.gz";
        if (-e "$fileTrembl") {
            $cmd = "$main::CMD_cp -p $fileTrembl $fileTrembl.bak";
            system("$cmd");
        } else {
            new FileHandle(">$fileTrembl.bak");
        }

        print STDERR "Download :: uniprot_trembl.dat.gz\n";
        my($url) = "ftp://ftp.uniprot.org/pub/databases/uniprot/current_release/knowledgebase/complete/uniprot_trembl.dat.gz";
        $cmd = "$main::CMD_curl -L -O $url";
        system("$cmd");

        #
        $cmd = "$main::CMD_cmp -s $fileTrembl $fileTrembl.bak";
        my$sta = system("$cmd");
        unlink("$fileTrembl.bak") if (-e "$fileTrembl.bak");
        if (($sta >> 8) == 0) {
#            print "Found no changes.\n";
#            exit(0);
        }

        #
        chdir($dirGoa);
        my($dirProteomes) = "proteomes";
        rmtree("$dirProteomes.bak") if (-e "$dirProteomes.bak");
        if (-e "$dirProteomes") {
            $cmd = "$main::CMD_cp -pr $dirProteomes $dirProteomes.bak";
            system("$cmd");
        } else {
            mkpath("$dirProteomes", 0);
        }
        print STDERR "Download :: goa/proteomes\n";

        my($url) = "ftp://ftp.ebi.ac.uk/pub/databases/GO/goa/proteomes/";
        $cmd = "$main::CMD_curl -l $url | $main::CMD_filter_goa -";
        my($fh) = FileHandle->new("$cmd |") || die("Can not open $cmd($!)");
        my(@file_list);
        while(my$file = $fh->getline()) {
            push(@file_list, $file);
        }
        $fh->close();
        foreach my$file (@file_list) {
            $cmd = "cd proteomes;"
                 . "$main::CMD_curl -L -O $url/$file";
        }

        #
        $cmd = "$main::CMD_diff -q $dirProteomes $dirProteomes.bak";
        rmtree("$dirProteomes.bak") if (-e "$dirProteomes.bak");
        my$sta = system("$cmd");
        if (($sta >> 8) == 0) {
            print "Found no changes.\n";
            exit(0);
        }
    }

    #
    chdir($dirUniprot);

    #
    $cmd = "$ENV{'MBGD_HOME'}/build/makeUniProtTable.pl -DIR_UNIPROT=$dirUniprot";
    system("$cmd");

    #
    $cmd = "$ENV{'MBGD_HOME'}/build/insertUniProt.pl -DIR=$dirUniprot";
    system("$cmd");

    #
    $cmd = "$ENV{'MBGD_HOME'}/build/insertGO.pl -DIR=$dirGoa";
    system("$cmd");

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dirUniprot) = "$main::DIR_ftp_uniprot";
    my($dirGoa)     = "$main::DIR_ftp_goa";
    if (! -e "$dirUniprot" || ! -e "$dirGoa") {
        $main::DOWNLOAD = 1;
        $dirUniprot = "$main::DIR_db_uniprot";
        $dirGoa     = "$main::DIR_db_goa";
    }
    mkpath($dir, 0, 0750) if (! -e "$dir");

    createUniprotDb($dirUniprot, $dirGoa);
}

1;#
